/* $Id: DataAccessManager.java,v 1.8 2005/08/26 04:53:29 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.jdbc.DataSourceFactory;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * f[^ANZX֘A̎ǗB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class DataAccessManager
{
	/** Xbh[JȃRlNV */
	static private final ThreadLocal connectionHolder = new ThreadLocal();
	/** Xbh[Jȃ^CX^v */
	static private final ThreadLocal timestampHolder = new ThreadLocal();

	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** f[^\[X */
	static private DataSource ds;
	
	/** DAOt@Ng */
	static private WorkflowDAOFactory daoFactory;
	
	/**
	 * DataAccessManageȑsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws WorkflowException
	{
		if (ds != null) {
			String msg = StringManager.get("E0070");
			eLog.error(msg);
			throw new WorkflowException(msg);
		}

		try {
			String dsfcn = System.getProperty(WorkflowEngineConstants.NAUTICA_DATASOURCE_FACTORY);
			DataSourceFactory factory = (DataSourceFactory)Class.forName(dsfcn).newInstance();
			ds = factory.getDataSource();

			String daofcn = System.getProperty(WorkflowEngineConstants.NAUTICA_DAO_FACTORY);
			daoFactory = (WorkflowDAOFactory)Class.forName(daofcn).newInstance();
		} catch (Exception ex) {
			String msg = StringManager.get("E0071");
			eLog.error(msg, ex);
			throw new WorkflowException(msg, ex);
		}
	}
	
	/**
	 * f[^\[XԂB
	 *
	 * @return f[^\[X
	 */
	static public DataSource getDataSource()
	{
		return ds;
	}
	
	/**
	 * DAOt@NgԂB
	 *
	 * @return DAOt@Ng
	 */
	static public WorkflowDAOFactory getDAOFactory()
	{
		return daoFactory;
	}
	
	/**
	 * gUNVJnB
	 *
	 * @param isAutoCommit R~bg[hȂtrue
	 * @throws SQLException SQL֘AO
	 */
	public static void begin(boolean isAutoCommit)
	throws SQLException
	{
		Connection conn = getConnection();
		conn.setAutoCommit(isAutoCommit);
	}
	
	/**
	 * gUNVR~bgB
	 *
	 * @throws SQLException SQL֘AO
	 * @throws WorkflowException [Nt[֘AO
	 */
	public static void commit()
	throws SQLException, WorkflowException
	{
		Connection conn = getConnection();
		conn.commit();
		close();
		
		SystemMessageTransporter.execute();
	}
	
	/**
	 * gUNV[obNB
	 *
	 * @throws SQLException SQL֘AO
	 */
	public static void rollback()
	throws SQLException
	{
		Connection conn = getConnection();
		if (conn != null && (! conn.isClosed())) {
			conn.rollback();
		}
		close();
	}

	/**
	 * JDBCڑoB
	 *
	 * @return JDBCڑ
	 * @throws SQLException SQL֘AO
	 */
	public static Connection getConnection()
	throws SQLException
	{
		Connection conn = (Connection)connectionHolder.get();
		
		if (conn == null) {
			conn = ds.getConnection();
			connectionHolder.set(conn);
			long now = System.currentTimeMillis();
			Timestamp ts = new Timestamp(now);
			timestampHolder.set(ts);
		}
		return conn;
	}

	/**
	 * gUNVł̃ANZXԂB
	 *
	 * @return ANZX
	 * @throws SQLException SQL֘AO
	 */
	public static Timestamp getAccessTime()
	throws SQLException
	{
		getConnection();
		Timestamp ts = (Timestamp)timestampHolder.get();
		return ts;
	}
	
	/**
	 * JDBCڑB
	 *
	 * @throws SQLException SQL֘AO
	 */
	public static void close()
	throws SQLException
	{
		Connection conn = (Connection)connectionHolder.get();
		connectionHolder.set(null);
		timestampHolder.set(null);
		if (conn != null && (! conn.isClosed())) {
			conn.close();
		}
	}
}
