/* $Id: DefinitionCache.java,v 1.16 2005/08/26 04:53:05 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.DefinitionLoader;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * `̃LbVVXeB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.16 $
 * @since   Nautica Workflow 0.9
 */
class DefinitionCache
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** `[_[ */
	static private DefinitionLoader loader;

	/** LbV`̊lBݒt@CɂĕύX\ */
	static private int DEFAULT_MAX_COUNT = 20;
	
	/** ݂̓o^\ő吔 */
	private int maxCacheCount = DEFAULT_MAX_COUNT;

	
	/**
	 * `ꗗB
	 * LbVvf́Aݒt@C
	 * nautica.workflow.repository.maxCacheCount̒lɂB
	 * ftHg20B
	 */
	private List definitions = new ArrayList();

	static
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		loader = new DefinitionLoader(home + separator + "repository");
	}
	
	/**
	 * `LbV𐶐B
	 */
	DefinitionCache()
	{
		String s = System.getProperty(WorkflowEngineConstants.NAUTICA_REPOSITORY_MAX_CACHE_COUNT);
		try {
			int count = Integer.parseInt(s);
			if (count < DEFAULT_MAX_COUNT) count = DEFAULT_MAX_COUNT;
			maxCacheCount = count;
			
			preload();
		} catch (Exception ex) {
		}
	}

	/**
	 * őLbV\ԂB
	 *
	 * @return őLbV\
	 */
	int getMaxCacheCount()
	{
		return maxCacheCount;
	}
	
	/**
	 * `ApbP[W`擾B
	 *
	 * @param name `
	 * @return pbP[W`
	 * @throws WorkflowException 擾ɗONꍇ
	 */
	synchronized PackageDefinition getPackageDefinition(String name)
	throws DefinitionNotFoundException, WorkflowException
	{
		try {
			DefinitionBean bean = getDefinitionBean(name);
			return findDefinition(bean);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// pbP[W`̎擾ɃG[N܂B
			String E0096 = StringManager.get("E0096");
			throw new WorkflowException(E0096, ex);
		}
	}
	
	/**
	 * `vZX`ԂB
	 *
	 * @param name `
	 * @return vZX`
	 * @throws DefinitionNotFoundException `Ȃꍇ
	 * @throws WorkflowException Cӂ̗ONꍇ
	 */
	synchronized ProcessDefinition getProcessDefinition(String name)
	throws DefinitionNotFoundException, WorkflowException
	{
		try {
			DefinitionBean bean = getDefinitionBean(name);
			String id = bean.getInternalPDID();

			PackageDefinition pkg = findDefinition(bean);
			Iterator it = pkg.getProcesses().iterator();
			while (it.hasNext()) {
				ProcessDefinition p = (ProcessDefinition)it.next();
				if (p.getID().equals(id)) {
					return p;
				}
			}
			// ΉvZX`݂܂B
			String E0094 = StringManager.get("E0094") + "(" + name + ")";
			throw new DefinitionNotFoundException(E0094);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX`̎擾ɃG[N܂B
			String E0097 = StringManager.get("E0097") + "(" + name + ")";
			throw new WorkflowException(E0097, ex);
		}
	}
	
	/**
	 * ``ԂB
	 *
	 * @param name `
	 * @return `
	 * @throws DefinitionNotFoundException `Ȃꍇ
	 * @throws WorkflowException Cӂ̗ONꍇ
	 */
	synchronized DefinitionBean getDefinitionBean(String name)
	throws DefinitionNotFoundException, Exception
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			DefinitionDAO dao = daoFactory.getDefinitionDAO();
			DefinitionBean bean = dao.findByPrimaryKey(name);

			if (bean == null) {
				// Ή`񂪑݂܂B
				String E0095 = StringManager.get("E0095") + "(" + name + ")";
				eLog.error(E0095);
				throw new DefinitionNotFoundException(E0095);
			}
			return bean;
		} catch (DefinitionNotFoundException ex) {
			throw ex;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// `̎擾ɃG[N܂B
			String E0098 = StringManager.get("E0098") + "(" + name + ")";
			throw new WorkflowException(E0098, ex);
		}
	}
	
	/**
	 * ݒ肩`t@C̎O[hsB
	 *
	 * @throws Exception
	 */
	private void preload() throws Exception
	{
		String s = System.getProperty(WorkflowEngineConstants.NAUTICA_REPOSITORY_PRELOAD_PATH);
		if (s == null || s.trim().equals("")) return;

		StringTokenizer st = new StringTokenizer(s, ";");
		while (st.hasMoreTokens()) {
			String path = st.nextToken();
			try {
				preloadDefinition(path);
			} catch (Exception ex) {
				// w肳ꂽ`t@CpX̎O[hɎs܂Ap܂B
				String W0005 = StringManager.get("W0005") + "(" + path + ")";
				eLog.warn(W0005);
			}
		}
	}
	
	/**
	 * `񂩂ApbP[W`擾B
	 *
	 * @param bean `
	 * @return pbP[W`
	 * @throws Exception Cӂ̗O
	 */
	private PackageDefinition findDefinition(DefinitionBean bean)
	throws Exception
	{
		String path = bean.getPath();
		String id = bean.getProcessDefinitionID();
		
		PackageDefinition pkg = findDefinitionByPath(path);
		if (pkg == null) {
			//`LbVĂȂꍇ́A|Wg烍[h
			pkg = loader.load(path);
			QueueItem item = new QueueItem(path, pkg);
			cache(item);
		}
		return pkg;
	}
	
	/**
	 * pXpbP[W`OLbVB
	 *
	 * @param path pX
	 * @throws Exception Cӂ̗O
	 */
	private void preloadDefinition(String path)
	throws Exception
	{		
		PackageDefinition pkg = findDefinitionByPath(path);
		if (pkg == null) {
			//`LbVĂȂꍇ́A|Wg烍[h
			pkg = loader.load(path);
			QueueItem item = new QueueItem(path, pkg);
			cache(item);
		}
	}
	
	/**
	 * pXpbP[W`擾B
	 *
	 * @param path pX
	 * @return pbP[W`
	 */
	private PackageDefinition findDefinitionByPath(String path)
	{
		Iterator it = definitions.iterator();
		
		PackageDefinition pkg = null;
		while (it.hasNext()) {
			QueueItem item = (QueueItem)it.next();
			if (path.equals(item.path)) {
				pkg = item.packageDefinition;
			}
		}
		return pkg;
	}
	
	/**
	 * L[vfLbVB
	 *
	 * @param item L[vf
	 */
	private void cache(QueueItem item)
	{
		int count = definitions.size();
		if (count == getMaxCacheCount()) {
			definitions.remove(0);
		}
		definitions.add(item);
	}
	
	/**
	 * LbVɃL[COvfIuWFNg
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.16 $
	 * @since   Nautica Workflow 0.9
	 */
	private class QueueItem
	{
		/** pX */
		private String path;
		/** pbP[W` */
		private PackageDefinition packageDefinition;
		
		/**
		 * vf𐶐B
		 *
		 * @param path pX
		 * @param pkg pbP[W`
		 */
		private QueueItem(String path, PackageDefinition pkg)
		{
			this.path = path;
			this.packageDefinition = pkg;
		}
	}
}
