/* $Id: EndActivityRequestMessage.java,v 1.8 2005/08/26 04:53:39 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * ANeBreBIvbZ[W\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class EndActivityRequestMessage extends RequestMessage
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** bZ[W̎ޔԍ */
	static public final int MESSAGE_TYPE = 103;

	/** vZXID */
	private String pid;

	/** ANeBreBID */
	private String aid;
	
	/** TuvZX̏I */
	private ProcessState state;

	/**
	 * ANeBreBIvbZ[W𐶐B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 */
	public EndActivityRequestMessage(String pid, String aid)
	{
		super(MESSAGE_TYPE);
		
		this.pid = pid;
		this.aid = aid;
	}

	/**
	 * ANeBreBIvbZ[W𐶐B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @param state TuvZX̏IԁBnull̂Ƃ́AcompleteƉ߂B
	 */
	public EndActivityRequestMessage(String pid, String aid, ProcessState state)
	{
		super(MESSAGE_TYPE);
		
		this.pid = pid;
		this.aid = aid;
		this.state = state;
	}

	/**
	 * vZXIDԂB
	 *
	 * @return vZXID
	 */
	public String getProcessID()
	{
		return pid;
	}

	/**
	 * ANeBreBIDԂB
	 *
	 * @return ANeBreBID
	 */
	public String getActivityID()
	{
		return aid;
	}

	/**
	 * TuvZX̏IԂԂB
	 *
	 * @return TuvZX̏I
	 */
	public ProcessState getSubprocessState()
	{
		return state;
	}
}
