/* $Id: EndActivityRequestWatcher.java,v 1.14 2005/08/26 04:53:44 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;


import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * ANeBreBIvL[ĎB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
class EndActivityRequestWatcher extends WorkflowMessageAdapter
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** bZ[WL[ */
	static public final String NAME = "END_ACTIVITY_REQUEST";
	
	/**
	 * ANeBreBIvL[Ď𐶐B
	 */
	EndActivityRequestWatcher()
	{
	}

	/**
	 * ANeBreBIvB
	 *
	 * @param message ANeBreBIv
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
	 */
	public void onMessage(WorkflowMessage message)
	{
		if (message instanceof EndActivityRequestMessage == false) {
			//Oɏo͂Ė
			// sȃbZ[W`łB
			String E0099 = StringManager.get("E0099");
			eLog.error(E0099);
			return;
		}
		EndActivityRequestMessage msg = (EndActivityRequestMessage)message;
		String pid = msg.getProcessID();
		String aid = msg.getActivityID();

		ActivityInternal act = null;
		try {
			DataAccessManager.begin(false);
			
			ProcessState subprocState = msg.getSubprocessState();
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			act = (ActivityInternal)proc.getStep(aid);
			
			if (subprocState == null || ProcessState.CLOSED_COMPLETED.equals(subprocState)) {
				act.complete();
			} else if (ProcessState.CLOSED_TERMINATED.equals(subprocState)) {
				act.terminate(false);
			} else if (ProcessState.CLOSED_ABORTED.equals(subprocState)) {
				act.abort(false);
			}
		} catch (Exception ex) {
			try {
				String E0103 = StringManager.get("E0103");
				eLog.error(E0103, ex);

				//ANeBreBُI݂B
				act.terminate(false);
			} catch (Exception ex2) {
				String F0103 = StringManager.get("F0103");
				eLog.fatal(F0103, ex);
			}
		} finally {
			try { DataAccessManager.commit(); } catch (Exception ex3) { /* Ignore */ }
		}
	}
}
