/* $Id: EndProcessRequestMessage.java,v 1.9 2005/08/26 04:53:19 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

/**
 * vZXIvbZ[W\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class EndProcessRequestMessage extends RequestMessage
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** bZ[W̎ޔԍ */
	static public final int MESSAGE_TYPE = 104;

	/** GWID */
	private String eid;

	/** vZXID */
	private String pid;

	/** ANeBreB̏I */
	private ActivityState astate;
	
	/**
	 * vZXIvbZ[W𐶐B
	 *
	 * @param pid vZXID
	 */
	public EndProcessRequestMessage(String pid)
	{
		super(MESSAGE_TYPE);
		
		this.pid = pid;
	}
	
	/**
	 * vZXIvbZ[W𐶐B
	 *
	 * @param eid GWID
	 * @param pid vZXID
	 */
	public EndProcessRequestMessage(String eid, String pid)
	{
		super(MESSAGE_TYPE);
		
		this.eid = eid;
		this.pid = pid;
	}

	/**
	 * vZXIvbZ[W𐶐B
	 *
	 * @param pid vZXID
	 * @param astate ANeBreB̏I
	 */
	public EndProcessRequestMessage(String pid, ActivityState astate)
	{
		super(MESSAGE_TYPE);
		
		this.pid = pid;
		this.astate = astate;
	}

	/**
	 * vZXIvbZ[W𐶐B
	 *
	 * @param eid GWID
	 * @param pid vZXID
	 * @param astate ANeBreB̏I
	 */
	public EndProcessRequestMessage(String eid, String pid, ActivityState astate)
	{
		super(MESSAGE_TYPE);
		
		this.eid = eid;
		this.pid = pid;
		this.astate = astate;
	}

	/**
	 * GWIDԂB
	 *
	 * @return GWID
	 */
	public String getEngineID()
	{
		return eid;
	}

	/**
	 * vZXIDԂB
	 *
	 * @return vZXID
	 */
	public String getProcessID()
	{
		return pid;
	}
	
	/**
	 * ANeBreB̏IԂԂB
	 *
	 * @return ANeBreB̏I
	 */
	public ActivityState getActivityState()
	{
		return astate;
	}
}
