/* $Id: EndProcessRequestWatcher.java,v 1.17 2005/08/26 04:53:48 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * vZXIvL[ĎB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.17 $
 * @since   Nautica Workflow 0.9
 */
class EndProcessRequestWatcher extends WorkflowMessageAdapter
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** bZ[WL[ */
	static public final String NAME = "END_PROCESS_REQUEST";
	
	/**
	 * vZXIvL[Ď𐶐B
	 */
	EndProcessRequestWatcher()
	{
	}

	/**
	 * vZXIvB
	 *
	 * @param message vZXIv
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
	 */
	public void onMessage(WorkflowMessage message)
	{
		if (message instanceof EndProcessRequestMessage == false) {
			//Oɏo͂Ė
			// sȃbZ[W`łB
			String E0099 = StringManager.get("E0099");
			eLog.error(E0099);
			return;
		}
		EndProcessRequestMessage msg = (EndProcessRequestMessage)message;
		String eid = msg.getEngineID();
		String spid = msg.getProcessID();
		ActivityState astate = msg.getActivityState();

		try {
			DataAccessManager.begin(false);
			endProcess(eid, spid, astate);
		} catch (Exception ex) {
			try {
				String E0101 = StringManager.get("E0101");
				eLog.error(E0101, ex);

				//Ԃ񖳗AvZXُI݂B
				endProcess(eid, spid, ActivityState.CLOSED_ABORTED);
			} catch (Exception ex2) {
				String F0101 = StringManager.get("F0101");
				eLog.fatal(F0101, ex);
			}
		} finally {
			try { DataAccessManager.commit(); } catch (Exception ex3) { /* Ignore */ }
		}
	}
	
	/**
	 * [J܂̓[g̃vZXIsB
	 *
	 * @param eid GWID
	 * @param spid vZXID
	 * @param astate ANeBreBI
	 * @throws Exception ̔Cӂ̗O
	 */
	private void endProcess(String eid, String spid, ActivityState astate)
	throws Exception
	{
		if (eid == null || eid.trim().equals("")) {
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(spid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(spid);
			
			ProcessState pstate = null;
			if (astate == null || ActivityState.CLOSED_COMPLETED.equals(astate)) {
				proc.complete();
				pstate = ProcessState.CLOSED_COMPLETED;
			} else if (ActivityState.CLOSED_TERMINATED.equals(astate)) {
				proc.terminate(false);
				pstate = ProcessState.CLOSED_TERMINATED;
			} else if (ActivityState.CLOSED_ABORTED.equals(astate)) {
				proc.abort(true);
				pstate = ProcessState.CLOSED_ABORTED;
			}

			//[gɃvZXʒmKvΒʒmB
			InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
			iwc.processStateChangedLocal(spid, pstate);
			
		} else {
			//[g̃GWɃvZXvsB
			InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
			String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);

			try {
				ProcessState pstate = null;
				if (astate == null || ActivityState.CLOSED_COMPLETED.equals(astate)) {
					pstate = ProcessState.CLOSED_COMPLETED;
				} else if (ActivityState.CLOSED_TERMINATED.equals(astate)) {
					pstate = ProcessState.CLOSED_TERMINATED;
				} else if (ActivityState.CLOSED_ABORTED.equals(astate)) {
					pstate = ProcessState.CLOSED_ABORTED;
				}

				//vZXv
				iwc.changeProcessState(session, spid, pstate);
			} finally {
				iwc.disconnect(session);
			}
		}
	}
}
