/* $Id: InterWorkflowConfig.java,v 1.10 2005/08/26 04:53:31 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.nautica.workflow.util.StringManager;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/**
 * GWԐڑp̐ݒǗłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
class InterWorkflowConfig
{
	/** ݒt@C */
	static private final String CONFIG = "interworkflow.xml";
	
	/** GWID */
	private String engineID;
	/** GWpX[h */
	private String enginePassword;
	/** o^Ă郊[gGW */
	private Map remoteEngines = new Hashtable();
	
	/**
	 * GWԐڑp̐ݒǗ𐶐B
	 *
	 * @throws XmlException ݒt@CɌ肪ꍇ
	 * @throws IOException ͏Ɏsꍇ
	 */
	public InterWorkflowConfig()
	throws XmlException, IOException
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		String path = home
		            + separator + "config"
		            + separator + CONFIG;
		File confFile = new File(path);
		InputStream in = new FileInputStream(confFile);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");

		EngineConfigDocument doc = EngineConfigDocument.Factory.parse(in, opts);
		in.close();
		
		load(doc);
	}

	/**
	 * ݒt@C[hB
	 *
	 * @param doc XMLhLg
	 * @throws XmlException ݒt@CɌ肪ꍇ
	 * @throws IOException ͏Ɏsꍇ
	 */
	private void load(EngineConfigDocument doc)
	throws XmlException, IOException
	{
		EngineConfigDocument.EngineConfig config = doc.getEngineConfig();
		EngineDocument.Engine local = config.getEngine();
		engineID = local.getId();
		enginePassword = local.getPassword();
		
		RemoteEnginesDocument.RemoteEngines remotes = config.getRemoteEngines();
		EngineDocument.Engine[] engines = remotes.getEngineArray();
		for (int i = 0; i < engines.length; i++) {
			String id = engines[i].getId();
			String pass = engines[i].getPassword();
			String url = engines[i].getUrl();
			if (id == null || id.trim().equals("")) {
				// GWIDݒłB
				String E0162 = StringManager.get("E0162");
				throw new XmlException(E0162);
			}
			
			EngineInfo info = new EngineInfo(id, pass, url);
			remoteEngines.put(id, info);
		}
	}
	
	/**
	 * engineIDԂB
	 *
	 * @return engineID̒l
	 */
	String getLocalEngineID()
	{
		return engineID;
	}

	/**
	 * enginePasswordԂB
	 *
	 * @return enginePassword̒l
	 */
	String getPassword()
	{
		return enginePassword;
	}

	/**
	 * GWIDɑΉ[gGWԂB
	 *
	 * @param eid GWID 
	 * @return GW
	 */
	EngineInfo getEngineInfo(String eid)
	{
		return (EngineInfo)remoteEngines.get(eid);
	}
	
	/**
	 * GW
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.10 $
	 * @since   Nautica Workflow 0.9
	 */
	class EngineInfo
	{
		/** GWID */
		private String engineID;
		/** GWpX[h */
		private String enginePassword;
		/** ڑURL */
		private String engineUrl;

		/**
		 * GW𐶐B
		 *
		 * @param id GWID
		 * @param pass GWpX[h
		 * @param url ڑURL
		 */
		public EngineInfo(String id, String pass, String url)
		{
			this.engineID = id;
			this.enginePassword = pass;
			this.engineUrl = url;
		}

		/**
		 * GWIDԂB
		 *
		 * @return GWID
		 */
		String getID()
		{
			return engineID;
		}

		/**
		 * GWpX[hԂB
		 *
		 * @return GWpX[h
		 */
		String getPassword()
		{
			if (enginePassword == null) return "";
			return enginePassword;
		}

		/**
		 * ڑURLԂB
		 *
		 * @return ڑURL
		 */
		String getURL()
		{
			if (engineUrl == null) return "";
			return engineUrl;
		}
	}
}
