/* $Id: InterWorkflowConnectorImpl.java,v 1.23 2005/08/26 04:53:33 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * GWԐڑ̂InterWorkflowConnectorNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.23 $
 * @since   Nautica Workflow 0.9
 */
public class InterWorkflowConnectorImpl implements InterWorkflowConnector
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** čO */
	static private Logger audit = LogManager.getAuditLogger();

	/** InterWorkflowConnectorImpl̃VOgCX^X */
	static private InterWorkflowConnectorImpl connector;
	
	/** OGWݒ */
	static private InterWorkflowConfig config;
	
	/**
	 * InterWorkflowConnectorImpl̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		config = new InterWorkflowConfig();
		connector = new InterWorkflowConnectorImpl();
		try {
			connector.init();
		} catch (Exception ex) {
			throw ex;
		}
	}

	/**
	 * InterWorkflowConnector̃CX^XԂB
	 *
	 * @return InterWorkflowConnector
	 */
	static InterWorkflowConnector getInstance()
	{
		return connector;
	}

	/**
	 * InterWorkflowConnector̃[gCX^XԂB
	 *
	 * @param engineName GW
	 * @return GWԐڑ[gC^tF[X
	 * @throws WorkflowException [Nt[ŗONꍇ
	 * @throws RemoteException ʐMŗONꍇ
	 * @throws NamingException OŗONꍇ
	 */
	static InterWorkflowConnectorRemote getRemoteInstance(String engineName)
	throws WorkflowException, RemoteException, NamingException
	{
		if (engineName == null || engineName.trim().equals("")) {
			// GWݒłB
			String E0212 = StringManager.get("E0212");
			throw new WorkflowException(E0212);
		}

		InterWorkflowConfig.EngineInfo info = config.getEngineInfo(engineName);
		if (info == null) {
			// GWɑΉGW񂪂܂B
			String E0220 = StringManager.get("E0220");
			throw new WorkflowException(E0220);
		}
		String url = info.getURL();
		
		Context context = getInitialContext(url);
		Object ref = context.lookup(engineName + "/InterWorkflowConnector");
		InterWorkflowConnectorRemote iwc
			= (InterWorkflowConnectorRemote)PortableRemoteObject
				.narrow(ref, InterWorkflowConnectorRemote.class);
		return iwc;
	}
	
	/**
	 * [g̃GWɐڑāAGWڑIDԂB
	 *
	 * @param remote GW̃[gC^tF[X
	 * @return GWڑID
	 * @throws WorkflowException [Nt[xŗONꍇ
	 * @throws RemoteException ʐMxŗONꍇ
	 */
	static String connectToRemoteEngine(InterWorkflowConnectorRemote remote)
	throws WorkflowException, RemoteException
	{
		String id = config.getLocalEngineID();
		String pass = config.getPassword();
		
		String remoteEID = remote.connect(id, pass);
		
		// čOo
		AuditDataRecord data = new AuditDataRecord(
		        new AuditPrefix("WMStartedConversation"),
		        new AuditSuffix(1, "4MIME"));
		data.setDataElement("SourceConverstaionID", id);
		data.setDataElement("TargetConversationID", remoteEID);
		audit.info(data);
		
		return remoteEID;
	}

	/**
	 * enginePasswordԂB
	 *
	 * @return enginePassword
	 */
	static String getLocalEnginePassword()
	{
		return config.getPassword();
	}
	
	/**
	 * InterWorkflowConnectorImpl𐶐B
	 */
	private InterWorkflowConnectorImpl()
	{
	}
	
	/**
	 * InterWorkflowConnectorImplB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
	}

	/**
	 * l[~OT[rXURLw肵ďReLXg擾B
	 *
	 * @param url URL
	 * @return ReLXg
	 * @throws NamingException l[~OT[rX֘A̗O
	 */
	static private Context getInitialContext(String url)
	throws NamingException
	{
		Properties prop = new Properties();
		prop.setProperty("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
		prop.setProperty("java.naming.provider.url", url);
		Context context = new InitialContext(prop);
		return context;
	}

	/**
	 * GWIDw肵āA[gGWANZXpIDԂB
	 *
	 * @param seid GWID
	 * @param password pX[h
	 * @return [g̃GWԂGWڑID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#connect(java.lang.String, java.lang.String)
	 */
	public String connect(String seid, String password)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = connect,"
			 + "source engine id = [" + seid + "],"
			 + "password = [**SECURITY**])";
	
		try {
			InterWorkflowConfig.EngineInfo info = config.getEngineInfo(seid);
			if (info == null) {
				// GWIDɑΉGW񂪂܂B
				String E0221 = StringManager.get("E0221");
				throw new WorkflowException(E0221);
			}

			//pX[h`FbNB
			String pass = info.getPassword();
			if (pass == null) {
				if (password != null) {
					// ڑppX[hv܂B
					String E0222 = StringManager.get("E0222");
					throw new WorkflowException(E0222);
				}
			} else {
				if (password == null) {
					// ڑppX[hv܂B
					String E0222 = StringManager.get("E0222");
					throw new WorkflowException(E0222);
				} else if (password.equals(pass) == false) {
					// ڑppX[hv܂B
					String E0222 = StringManager.get("E0222");
					throw new WorkflowException(E0222);
				}
			}
			
			//ZbV̍쐬
			WorkflowEngine engine = WorkflowEngine.getInstance();
			
			String eid = engine.connect(seid, password);
			
			// čOo
			AuditDataRecord data = new AuditDataRecord(
			        new AuditPrefix("WMStartedConversation"),
			        new AuditSuffix(1,"4MIME"));
			data.setDataElement("SourceConverstaionID", seid);
			data.setDataElement("TargetConversationID", eid);
			audit.info(data);
			
			return eid;
		} catch (WorkflowException ex) {
			String msg = ex.getMessage() + argInfo;
			eLog.error(msg, ex);
			throw ex;
		} catch (Exception ex) {
			// GWԐڑɎs܂B
			String E0207 = StringManager.get("E0207") + argInfo;
			eLog.error(E0207, ex);
			throw new WorkflowException(E0207, ex);
		}
	}

	/**
	 * [g̃GWƂ̐ڑؒfB
	 *
	 * @param eid GWID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#disconnect(java.lang.String)
	 */
	public void disconnect(String eid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = disconnect,"
			 + "engine connection id = [" + eid + "])";
	
		try {
			//ZbV̍쐬
			WorkflowEngine engine = WorkflowEngine.getInstance();

			engine.disconnect(eid);
			
			// čOo
			AuditDataRecord data = new AuditDataRecord(
			        new AuditPrefix("WMStoppedConversation"),
			        new AuditSuffix(1,"4MIME"));
			data.setDataElement("TargetConversationID", eid);
			audit.info(data);
			
		} catch (WorkflowException ex) {
			String msg = ex.getMessage() + argInfo;
			eLog.error(msg, ex);
			throw ex;
		} catch (Exception ex) {
			// GWԐڑ̐ؒfɎs܂B
			String E0208 = StringManager.get("E0208") + argInfo;
			eLog.error(E0208, ex);
			throw new WorkflowException(E0208, ex);
		}
	}

	/**
	 * vZXCX^XԂ̕ύXvB
	 * 쐬vZXJnꍇÃC^tF[XgpB
	 *
	 * @param eid GWID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#changeProcessState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.ProcessState)
	 */
	public void changeProcessState(String eid, String pid, ProcessState state)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = changeProcessState,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "],"
			 + "state = [" + state.toString() + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedRequestChangeProcessInstanceState"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement("SourceRequestedState", state);
	    data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			if (state == null) {
				// vZXԂݒ肳Ă܂B
				String E0218 = StringManager.get("E0218");
				throw new WorkflowException(E0218);
			}
	
			DataAccessManager.begin(false);
			
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
			
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(pid);

			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			WfProcessManager pm = pmf.getOwnerProcessManager(pid);
			WfProcess process = pm.getProcess(pid);
			process.changeState(state);
			
			DataAccessManager.commit();
			
			// čOo
			data = new AuditDataRecord(
			        new AuditPrefix("WMChangeProcessInstanceState"),
			        new AuditSuffix(1, "4MIME"));
			data.setDataElement("NewProcessState", state);
			data.setDataElement("TargetConversationID", remoteEngineID);
			audit.info(data);

		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXԂ̕ύXɎs܂B
			String E0156 = StringManager.get("E0156") + argInfo;
			eLog.error(E0156, ex);
			throw new WorkflowException(E0156, ex);
		} finally {
			// čOo
		    data = new AuditDataRecord(
		            new AuditPrefix("WMSentChangeProcessInstanceState"),
		            new AuditSuffix(1, "4MIME"));
		    data.setDataElement("TargetProcessInstanceID", pid);
		    data.setDataElement("TargetNodeID", System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE));
		    data.setDataElement("TargetState", state);
		    data.setDataElement("TargetConversationID", eid);
			audit.info(data);
		}
	}

	/**
	 * vZXCX^X̐vB
	 *
	 * @param eid [gGWڑID
	 * @param pdid vZX`ID
	 * @param flag ߂lԂKv邩ǂ\tO
	 * @param rootpid ṽvZXCX^XID
	 * @param aid ṽANeBreBCX^XID
	 * @param userid [UIDBɋL^pB
	 * @param roleid IDBɋL^pB
	 * @return ꂽvZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#createProcess(java.lang.String, java.lang.String, int, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String createProcess(String eid, String pdid, int flag,
			String rootpid, String aid, String userid, String roleid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = createProcess,"
			 + "engine connection id = [" + eid + "],"
			 + "pdid = [" + pdid + "],"
			 + "flag = [" + flag + "],"
			 + "rootpid = [" + rootpid + "],"
			 + "aid = [" + aid + "],"
			 + "userid = [" + userid + "],"
			 + "roleid = [" + roleid + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedRequestCreateProcessInstance"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
	    data.setDataElement("SourceActivityInstanceID", aid);
	    data.setDataElement("SourceUserID", userid);
	    data.setDataElement("SourceRoleID", roleid);
	    data.setDataElement("SourceProcessDefinitionID", pdid);
		data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			if (pdid == null || pdid.trim().equals("")) {
				// vZX`IDݒ肳Ă܂B
				String E0219 = StringManager.get("E0219");
				throw new WorkflowException(E0219);
			}

			if (flag != NEED_RESULT && flag != NOT_NEED_RESULT) {
				// ߂ltOLȒlł͂܂B
				String E0224 = StringManager.get("E0224");
				throw new WorkflowException(E0224);
			}

			checkRootProcessID(rootpid);
			checkActivityID(aid);

			if (userid == null || userid.trim().equals("")) {
				// [UIDݒłB
				String E0166 = StringManager.get("E0166");
				throw new WorkflowException(E0166);
			}

			if (roleid == null || roleid.trim().equals("")) {
				// [IDݒłB
				String E0213 = StringManager.get("E0213");
				throw new WorkflowException(E0213);
			}

			DataAccessManager.begin(false);
			
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);

			//vZX̐sB
			RequesterManager rqm = RequesterManager.getInstance();
			WfRequester requester = rqm.getRequesterBySession(eid);
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			WfProcessManager pm = pmf.getProcessManager(pdid);
			String name = "InterWorkflow process by " + remoteEngineID;
			WfProcess process = pm.createProcess(requester, name);
			String pid = process.getID();

			//vǗKvꍇAvo^B
			if (flag == NEED_RESULT) {
				WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
				SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
				SourceActivityBean sabean = new SourceActivityBean();
				sabean.setEngineID(remoteEngineID);
				sabean.setRootProcID(rootpid);
				sabean.setRootActID(aid);
				sabean.setProcessID(pid);
				saDAO.insert(sabean);
			}
			
			DataAccessManager.commit();
			
			// čOo
			data = new AuditDataRecord(
			        new AuditPrefix("WMCreatedProcessInstance"),
			        new AuditSuffix(1, "4MIME"));
			data.setDataElement("ProcessDefinitionID", pdid);
			data.setDataElement("TargetConversationID", eid);
			audit.info(data);

			return pid;
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZX̐Ɏs܂B
			String E0153 = StringManager.get("E0153") + argInfo;
			eLog.error(E0153, ex);
			throw new WorkflowException(E0153, ex);
		} finally {
			// čOo
		    data = new AuditDataRecord(
		            new AuditPrefix("WMSentCreatedProcessInstance"),
		            new AuditSuffix(1, "4MIME"));
		    data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
		    data.setDataElement("SourceActivityInstanceID", aid);
		    data.setDataElement("SourceUserID", userid);
		    data.setDataElement("SourceRoleID", roleid);
		    data.setDataElement("SourceProcessDefinitionID", pdid);
		    data.setDataElement("TargetConversationID", eid);
			audit.info(data);
		}
	}

	/**
	 * vZXCX^X̎擾vB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ̔zԂB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#getProcessAttributes(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public Attribute[] getProcessAttributes(String eid, String pid,
			String rootpid, String aid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = getProcessAttributes,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "],"
			 + "rootpid = [" + rootpid + "],"
			 + "aid = [" + aid + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedRequestGetProcessInstanceAttribute"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
	    data.setDataElement("SourceActivityInstanceID", aid);
	    data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			DataAccessManager.begin(false);
			
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
			
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(rootpid, aid, pid);

			//vZXϐ̎擾
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			WfProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			Attribute[] attrs = (Attribute[])process.getContext();
			
			DataAccessManager.commit();

			return attrs;
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXϐ̎擾Ɏs܂B
			String E0032 = StringManager.get("E0032") + argInfo;
			eLog.error(E0032, ex);
			throw new WorkflowException(E0032, ex);
		} finally {
			// čOo
		    data = new AuditDataRecord(
		            new AuditPrefix("WMSentGetProcessInstanceAttribute"),
		            new AuditSuffix(1, "4MIME"));
		    data.setDataElement("TargetProcessInstanceID", pid);
		    data.setDataElement("TargetNodeID", System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE));
		    data.setDataElement("TargetConversationID", eid);
			audit.info(data);
		}
	}

	/**
	 * vZXCX^XԂ̎擾vB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#getProcessState(java.lang.String, java.lang.String)
	 */
	public ProcessState getProcessState(String eid, String pid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = getProcessState,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "])";
	
		try {
			DataAccessManager.begin(false);
				
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
				
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(pid);
	
			//vZXԂ̎擾
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			WfProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal internal = (ProcessInternal)pm.getProcess(pid);
			Process proc = internal.getBean();
			ProcessState state = ProcessState.getState(proc.getProcessState());
				
			DataAccessManager.commit();
	
			return state;
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXԂ̎擾Ɏs܂B
			String E0154 = StringManager.get("E0154") + argInfo;
			eLog.error(E0154, ex);
			throw new WorkflowException(E0154, ex);
		}
	}

	/**
	 * vZXCX^X̕ύXʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param attrs 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#processAttributesChanged(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Attribute[])
	 */
	public void processAttributesChanged(String eid, String pid, Attribute[] attrs)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = processAttributesChanged,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "],"
			 + "attribute = [" + attrs + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedChangedProcessInstanceAttribute"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement(attrs);
	    data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			if (attrs == null) {
				// vZXϐݒłB
				String E0131 = StringManager.get("E0131");
				throw new InvalidProcessInstanceException(E0131);
			}

			DataAccessManager.begin(false);
				
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
				
			//evZXȂ̂ŁAZbṼ`FbN͍sȂB
			//A[g̃`FbNsB
			TargetProcessBean tpbean = checkTargetInfo(remoteEngineID, pid);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			WfProcessManager pm = pmf.getOwnerProcessManager(pid);
			WfProcess process = pm.getProcess(pid);
	
			for (int i = 0; i < attrs.length; i++) {
				//vZXϐ̍XV
				process.setContext(attrs[i]);
			}
				
			DataAccessManager.commit();

		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXϐ̍XVɎs܂B
			String E0031 = StringManager.get("E0031") + argInfo;
			eLog.error(E0031, ex);
			throw new WorkflowException(E0031, ex);
		}
	}

	/**
	 * vZXCX^XԂ̕ύXʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#processStateChanged(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.ProcessState)
	 */
	public void processStateChanged(String eid, String pid, ProcessState state)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = processStateChanged,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "],"
			 + "state = [" + state + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedChangedProcessInstanceState"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement("NewProcessState", state);
	    data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			if (state == null) {
				// vZXԂݒłB
				String E0214 = StringManager.get("E0214");
				throw new InvalidProcessInstanceException(E0214);
			}

			DataAccessManager.begin(false);

			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
	
			//evZXȂ̂ŁAZbṼ`FbN͍sȂB
			//A[g̃`FbNsB
			TargetProcessBean tpbean = checkTargetInfo(remoteEngineID, pid);
				
			String rootpid = tpbean.getRootProcID();
			String rootaid = tpbean.getRootActID();
	
			//Ԃ̕ύX
			//ԂCLOSEȂA[gɊ֌W̐؂藣ʒmB
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {

				ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
				WfProcessManager pm = pmf.getOwnerProcessManager(rootpid);
				WfProcess process = pm.getProcess(rootpid);
				WfActivity activity = process.getStep(rootaid);
				ActivityState astate = StateHelper.convert(state);
				activity.changeState(astate);
					
				relinquishProcessLocal(remoteEngineID, pid);
			}
				
			DataAccessManager.commit();

		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXԂ̕ύXɎs܂B
			String E0156 = StringManager.get("E0156") + argInfo;
			eLog.error(E0156, ex);
			throw new WorkflowException(E0156, ex);
		}
	}

	/**
	 * vZXCX^X̐ݒvB
	 *
	 * @param eid [gGWڑID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid vANeBreBCX^XID
	 * @param pid vZXCX^XID
	 * @param attrs 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#setProcessAttributes(java.lang.String, java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Attribute[])
	 */
	public void setProcessAttributes(String eid, String rootpid,
			String aid, String pid, Attribute[] attrs)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = setProcessAttributes,"
			 + "engine connection id = [" + eid + "],"
			 + "rootpid = [" + rootpid + "],"
			 + "aid = [" + aid + "],"
			 + "pid = [" + pid + "],"
			 + "attrs = [" + attrs + "])";
	
		// čOo
	    AuditDataRecord data = new AuditDataRecord(
	            new AuditPrefix("WMReceivedRequestChangeProcessInstanceAttribute"),
	            new AuditSuffix(1, "4MIME"));
	    data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
	    data.setDataElement("SourceActivityInstanceID", aid);
	    data.setDataElement(attrs);
	    data.setDataElement("TargetConversationID", eid);
		audit.info(data);

		try {
			if (attrs == null) {
				// vZXϐݒłB
				String E0131 = StringManager.get("E0131");
				throw new InvalidProcessInstanceException(E0131);
			}

			DataAccessManager.begin(false);
				
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
				
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(rootpid, aid, pid);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			process.setContext(attrs);
				
			DataAccessManager.commit();
				
			// čOo
			data = new AuditDataRecord(
			        new AuditPrefix("WMAssignedProcessInstanceAttribute"),
			        new AuditSuffix(1, "4MIME"));
			data.setDataElement(attrs);
			data.setDataElement("TargetConversationID", eid);
			audit.info(data);
	
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080") + argInfo;
			eLog.error(E0080, ex);
			throw new WorkflowException(E0080, ex);
		} finally {
			// čOo
		    data = new AuditDataRecord(
		            new AuditPrefix("WMSentChangeProcessInstanceAttribute"),
		            new AuditSuffix(1, "4MIME"));
		    data.setDataElement("TargetProcessInstanceID", pid);
		    data.setDataElement("TargetNodeID", System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE));
		    data.setDataElement(attrs);
		    data.setDataElement("TargetConversationID", eid);
			audit.info(data);
		}
	}

	/**
	 * gK[ƂȂANeBreBʒmB
	 * ́ANANeBreBƂ͕ʂȃANeBreBɂ
	 * vZX𐧌䂷ꍇ̒ʒmƂĎgpB
	 *
	 * @param eid [gGWڑID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid vANeBreBCX^XID
	 * @param pid vZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#triggerActivity(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public void triggerActivity(String eid, String rootpid,
			String aid, String pid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = triggerActivity,"
			 + "engine connection id = [" + eid + "],"
			 + "rootpid = [" + rootpid + "],"
			 + "aid = [" + aid + "],"
			 + "pid = [" + pid + "])";
	
		try {
			DataAccessManager.begin(false);
				
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
				
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(rootpid, aid, pid);
	
			DataAccessManager.commit();
	
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// ANeBreB̒ʒmɎs܂B
			String E0123 = StringManager.get("E0123") + argInfo;
			eLog.error(E0123, ex);
			throw new WorkflowException(E0123, ex);
		}
	}

	/**
	 * ̃GWvē쒆̃vZXCX^XIDꗗ
	 * 擾vB
	 *
	 * @param eid [gGWڑID
	 * @param filter ptB^[
	 * @return vZXCX^XIDꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#listProcesses(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public String[] listProcesses(String eid, Filter filter)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = listProcesses,"
			 + "engine connection id = [" + eid + "],"
			 + "filter = [" + filter + "])";

		try {
			DataAccessManager.begin(false);
			
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
			
			//OłKvB
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			Process[] procs = pmf.getProcesses(filter);
			
			DataAccessManager.commit();

			return null;
		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXꗗ̎擾Ɏs܂B
			String E0199 = StringManager.get("E0199") + argInfo;
			eLog.error(E0199, ex);
			throw new WorkflowException(E0199, ex);
		}
	}

	/**
	 * vZXCX^X̐̕ʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector#relinquishProcess(java.lang.String, java.lang.String)
	 */
	public void relinquishProcess(String eid, String pid)
	throws WorkflowException
	{
		String argInfo = "(WfMC API = relinquishProcess,"
			 + "engine connection id = [" + eid + "],"
			 + "pid = [" + pid + "])";

		try {
			DataAccessManager.begin(false);
				
			//GWڑp̃ZbVAۂ̃GWID擾B
			String remoteEngineID = validateEngineID(eid);
			
			//[g̃`FbN
			SourceActivityBean sabean = checkRemoteInfo(pid);
	
			//NANeBreB񂩂YvZX̍폜sB
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
			saDAO.delete(pid);
			
			DataAccessManager.commit();
	
 		} catch (WorkflowException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZX̐̕Ɏs܂B
			String E0209 = StringManager.get("E0209") + argInfo;
			eLog.error(E0209, ex);
			throw new WorkflowException(E0209, ex);
		}
	}

	/**
	 * vZXCX^X̕ύXʒmB
	 * ̃\bh́ATuvZXŎsB
	 *
	 * @param pid vZXCX^XID
	 * @param attrs 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void processAttributesChangedLocal(String pid, Attribute[] attrs)
	throws WorkflowException
	{
		try {
			//[g̃GWĂ΂ꂽvZXǂ`FbNB
			//̃GW̃vZXȂ̂ŁAL[̓vZXIDœ\B
			TargetProcessBean tpbean = checkTargetInfo(pid);
			
			//ǗĂN݂ꍇ
			if (tpbean != null) {
				String engineName = tpbean.getEngineID();
				InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
				String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
				
				// čOo
				AuditDataRecord data = new AuditDataRecord(
				        new AuditPrefix(pid, "WMSentChangedProcessInstanceAttribute"),
				        new AuditSuffix(1, "4MIME"));
				data.setDataElement("TargetProcessInstanceID", pid);
				data.setDataElement("TargetNodeID", System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE));
				data.setDataElement(attrs);
				data.setDataElement("TargetConversationID", eid);
				audit.info(data);
				
				//ϐύXꂽƂevZXɒʒmB
				iwc.processAttributesChanged(eid, pid, attrs);

				iwc.disconnect(eid);
				
				// čOo
				data = new AuditDataRecord(
				        new AuditPrefix(pid, "WMAssignedProcessInstanceAttribute"),
				        new AuditSuffix(1, "4MIME"));
				data.setDataElement(attrs);
				data.setDataElement("TargetConversationID", "eid");
				audit.info(data);
			}				
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̕ύXʒmɎs܂B
			String E0210 = StringManager.get("E0210");
			throw new WorkflowException(E0210, ex);
		}
	}

	/**
	 * vZXCX^XԂ̕ύXʒmB
	 * ̃\bh́ATuvZXŎsB
	 *
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void processStateChangedLocal(String pid, ProcessState state)
	throws WorkflowException
	{  
		try {
			//[g̃GWĂ΂ꂽvZXǂ`FbNB
			//̃GW̃vZXȂ̂ŁAL[̓vZXIDœ\B
			SourceActivityBean sabean = checkSourceInfo(pid);
			
			//ǗĂN݂ꍇ
			if (sabean != null) {
				String engineName = sabean.getEngineID();
				InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
				String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
				
				// čOo
				AuditDataRecord data = new AuditDataRecord(
				        new AuditPrefix("WMSentChangedProcessInstanceState"),
				        new AuditSuffix(1, "4MIME"));
				data.setDataElement("TargetProcessInstanceID", pid);
				data.setDataElement("NewProcessState", state);
				data.setDataElement("TargetConversationID", eid);
				audit.info(data);
				
				//ϐύXꂽƂevZXɒʒmB
				iwc.processStateChanged(eid, pid, state);

				iwc.disconnect(eid);
				
				// čOo
				data = new AuditDataRecord(
				        new AuditPrefix("WMChangedProcessInstanceState"),
				        new AuditSuffix(1, "4MIME"));
				data.setDataElement("NewProcessState", state);
				data.setDataElement("TargetConversationID", eid);	
				audit.info(data);					
			}			
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXԂ̕ύXʒmɎs܂B
			String E0211 = StringManager.get("E0211");
			throw new WorkflowException(E0211, ex);
		}
	}

	/**
	 * vZXCX^X̐̕ʒmB
	 * ̃\bh͐eŌĂ΂B
	 *
	 * @param engineName [gGWڑID
	 * @param pid vZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void relinquishProcessLocal(String engineName, String pid)
	throws WorkflowException
	{
		try {
			InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
			String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);

			//[g̃TuvZXɁA֌W̐؂藣ʒmB
			iwc.relinquishProcess(eid, pid);

			iwc.disconnect(eid);

			//ǗR[h폜B
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
			tpDAO.delete(engineName, pid);
 		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̐̕Ɏs܂B
			String E0209 = StringManager.get("E0209");
			throw new WorkflowException(E0209, ex);
		}
	}
	
	/**
	 * [obNƃG[Ȍo͂sB
	 *
	 * @param ex O
	 * @param argInfo 
	 */
	private void rollbackAndLogging(Exception ex, String argInfo)
	{
		try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
		String msg = ex.getMessage() + argInfo;
		eLog.error(msg, ex);
	}

	/**
	 * evZXID؂B
	 *
	 * @param rootpid evZXID
	 * @throws InvalidProcessInstanceException ȃvZXID̏ꍇ
	 */
	private void checkRootProcessID(String rootpid)
	throws InvalidProcessInstanceException
	{
		if (rootpid == null || rootpid.trim().equals("")) {
			// ڑGW̃vZXIDݒłB
			String E0215 = StringManager.get("E0215");
			throw new InvalidProcessInstanceException(E0215);
		}
	}

	/**
	 * ANeBreBID؂B
	 *
	 * @param aid ANeBreBID
	 * @throws InvalidActivityInstanceException ȃANeBreBID̏ꍇ
	 */
	private void checkActivityID(String aid)
	throws InvalidActivityInstanceException
	{
		if (aid == null || aid.trim().equals("")) {
			// ڑGW̃ANeBreBIDݒłB
			String E0216 = StringManager.get("E0216");
			throw new InvalidActivityInstanceException(E0216);
		}
	}
	
	/**
	 * GWڑID؂B
	 *
	 * @param eid GWڑID
	 * @return GWID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException Cӂ̃[Nt[O
	 */
	private String validateEngineID(String eid)
	throws InvalidSessionException, WorkflowException
	{
		if (eid == null || eid.trim().equals("")) {
			// GWڑIDݒłB
			String E0217 = StringManager.get("E0217");
			throw new InvalidSessionException(E0217);
		}

		SessionManagerFactory factory = SessionManagerFactory.getInstance();
		SessionManager manager = factory.getSessionManager();
		manager.validateSession(eid);

		//GWڑIDɑΉ[U擾B
		String uid = null;
		try {
			User user = manager.getSessionUser(eid);
			uid = user.getID();
		} catch (Exception ex) {
			// ȃ[UIDłB
			String E0225 = StringManager.get("E0225");
			throw new WorkflowException(E0225, ex);
		}

		//o^ĂGWǂ`FbNB
		InterWorkflowConfig.EngineInfo info = config.getEngineInfo(uid);
		if (info == null) {
			// GWIDɑΉGW񂪂܂B
			String E0221 = StringManager.get("E0221");
			throw new WorkflowException(E0221);
		}
		String remoteEngineID = info.getID();
		
		return remoteEngineID;
	}
	
	/**
	 * vZX[g쐬ꂽ̂ȂAÑANeBreBԂB
	 *
	 * @param pid vZXID
	 * @return ÑANeBreB
	 * @throws Exception Cӂ̗O
	 */
	private SourceActivityBean checkSourceInfo(String pid) throws Exception
	{
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
		SourceActivityBean sabean = saDAO.findByPrimaryKey(pid);
		return sabean;
	}

	/**
	 * NvZX`FbNB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @return NvZX
	 * @throws WorkflowException Cӂ̃[Nt[O
	 * @throws Exception Cӂ̗O
	 */
	private TargetProcessBean checkTargetInfo(String eid, String pid)
	throws WorkflowException, Exception
	{
		if (eid == null || eid.trim().equals("")) {
			// GWIDݒłB
			String E0162 = StringManager.get("E0162");
			throw new WorkflowException(E0162);
		}

		if (pid == null || pid.trim().equals("")) {
			// vZXIDݒłB
			String E0189 = StringManager.get("E0189");
			throw new WorkflowException(E0189);
		}
		
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
		TargetProcessBean tpbean = tpDAO.findByPrimaryKey(eid, pid);

		//ǗĂ郏[Nt[ڑȂ
		if (tpbean == null) {
			// ̂悤ȃvZX݂͑܂B
			String E0226 = StringManager.get("E0226");
			throw new WorkflowException(E0226);
		}

		String teid = tpbean.getEngineID();

		if (teid == null || teid.equals(eid) == false) {
			// GWIDv܂B
			String E0223 = StringManager.get("E0223");
			throw new WorkflowException(E0223);
		}

		return tpbean;
	}

	/**
	 * NvZX`FbNB
	 *
	 * @param pid vZXCX^XID
	 * @return NvZX
	 * @throws WorkflowException Cӂ̃[Nt[O
	 * @throws Exception Cӂ̗O
	 */
	private TargetProcessBean checkTargetInfo(String pid)
	throws WorkflowException, Exception
	{
		if (pid == null || pid.trim().equals("")) {
			// vZXIDݒłB
			String E0189 = StringManager.get("E0189");
			throw new WorkflowException(E0189);
		}
		
		//[g̃GWĂ΂ꂽǂ`FbNB
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
		TargetProcessBean tpbean = tpDAO.findByProcessID(pid);

		return tpbean;
	}

	/**
	 * NANeBreB`FbNB
	 *
	 * @param pid vZXCX^XID
	 * @return NANeBreB
	 * @throws WorkflowException Cӂ̃[Nt[O
	 * @throws Exception Cӂ̗O
	 */
	private SourceActivityBean checkRemoteInfo(String pid)
	throws WorkflowException, Exception
	{
		if (pid == null || pid.trim().equals("")) {
			// vZXIDݒłB
			String E0189 = StringManager.get("E0189");
			throw new WorkflowException(E0189);
		}

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
		SourceActivityBean sabean = saDAO.findByPrimaryKey(pid);

		//ǗĂ郏[Nt[ڑȂ
		if (sabean == null) {
			// ̂悤ȃvZX݂͑܂B
			String E0226 = StringManager.get("E0226");
			throw new WorkflowException(E0226);
		}
		return sabean;
	}

	/**
	 * NANeBreB`FbNB
	 *
	 * @param rootpid ṽvZXCX^XID
	 * @param rootaid vANeBreBCX^XID
	 * @param pid vZXCX^XID
	 * @return NANeBreB
	 * @throws WorkflowException Cӂ̃[Nt[O
	 * @throws Exception Cӂ̗O
	 */
	private SourceActivityBean checkRemoteInfo(String rootpid, String rootaid, String pid)
	throws WorkflowException, Exception
	{
		SourceActivityBean sabean = checkRemoteInfo(pid);

		String rpid = sabean.getRootProcID();
		String raid = sabean.getRootActID();

		if (rootpid == null || rpid.equals(rootpid) == false) {
			// ڑGW̃vZXIDݒłB
			String E0215 = StringManager.get("E0215");
			throw new WorkflowException(E0215);
		}

		if (rootaid == null || raid.equals(rootaid) == false) {
			// ڑGW̃ANeBreBIDݒłB
			String E0216 = StringManager.get("E0216");
			throw new WorkflowException(E0216);
		}
		
		return sabean;
	}
}
