/* $Id: InteractiveActivityBehavior.java,v 1.13 2005/08/26 04:53:28 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

/**
 * Θb^ANeBreB̏ԂƂ̓`NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.13 $
 * @since   Nautica Workflow 0.9
 */
public class InteractiveActivityBehavior
extends AbstractActivityBehavior
{

	/**
	 * Θb^ANeBreB̏ԂƂ̓𐶐B
	 */
	public InteractiveActivityBehavior()
	{
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#abort(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void abort(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();

		//֘Aƍڂ̍폜
		WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
		wiDAO.deleteByProcessIDANDActivityID(pid, aid);
		
		//YANeBreB𒆒fB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
	}

	/**
	 * ŗL̊JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#start(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void start(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		String pdid = pbean.getProcDefinitionID();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();
		String performerID = ad.getPerformerID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();

		//vZX`̐擾B
		DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
		DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
		String defID = defbean.getProcessDefinitionID();
		
		ParticipantDefinition partd = getParticipantDefinition(defID, performerID);		
		if (partd == null) {
			//s҂ȂB`~X̉\B
			act.terminate();
			String msg = StringManager.get("F0002");
			eLog.fatal(msg);
			throw new WorkflowException(msg);
		}
		
		WorkItemBean wbean = new WorkItemBean();
		wbean.setID(UniqueKeyGenerator.generate(WorkItemBean.ID_PREFIX));
		wbean.setProcessID(pid);
		wbean.setActivityID(aid);
		wbean.setParticipantName(partd.getName());
		wbean.setParticipantType(partd.getType());
		WorkItemDAO workDAO = daoFactory.getWorkItemDAO();
		workDAO.insert(wbean);
		
		//YANeBreBJnB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#terminate(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void terminate(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		String pid = pbean.getID();
		ActivityBean abean = act.getBean();
		String aid = abean.getActivityID();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();

		//֘Aƍڂ̍폜
		WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
		wiDAO.deleteByProcessIDANDActivityID(pid, aid);
		List acts = new ArrayList();
		
		VariableDAO varDAO = daoFactory.getVariableDAO();
		List vars = varDAO.findByProcessIDAsList(pid);
		List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
		
		Iterator it = trs.iterator();
		while (it.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)it.next();
			ActivityDefinition dest = tr.getDestination();
			
			//JڐANeBreB̐
			ActivityBean ab = createActivity(pd, dest, pbean, bid);
			acts.add(ab);
		}
		
		if (acts.size() == 0) {
			//Jڐ悪ȂB`~X̉\B
			suspend(pd, ad, proc, act);
			String msg = StringManager.get("F0001");
			eLog.fatal(msg);
			return;
		}

		//YANeBreB𒆎~B
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);

		//JڐANeBreBbZ[WL[ɓo^B
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityBean ab = (ActivityBean)ait.next();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			String abid = ab.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, abid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);
		}
	}
}
