/* $Id: LogManager.java,v 1.6 2005/08/26 04:53:28 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * Log4J𗘗pbZ[WǗ@\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class LogManager
{
	/** GWO */
	static private final String ENGINE_LOGGER = "Engine";
	/** čO */
	static private final String AUDIT_LOGGER = "EventAudit";
	/** ZLeBO */
	static private final String SECURITY_LOGGER = "Security";

	/** ς݃tO */
	static private boolean initialized = false;
	
	/**
	 * LogManageȑsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws WorkflowException
	{
		if (initialized) {
			throw new WorkflowException("Logging already initialized.");
		}
		String path = getConfigPath();
		try {
			PropertyConfigurator.configure(path);
		} catch (Exception ex) {
			throw new WorkflowException("Logging configuration failed.", ex);
		}
		initialized = true;
	}
	
	/**
	 * ݒt@C̃pXԂB
	 *
	 * @return pX
	 * @throws WorkflowException 擾ɃG[Nꍇ
	 */
	static private String getConfigPath()
	throws WorkflowException
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String conf = System.getProperty(WorkflowEngineConstants.NAUTICA_LOGGING_CONFIG);
		String separator = System.getProperty("file.separator");
		String path = home
		                   + separator + "config"
						   + separator + conf;
		File confFile = new File(path);
	
		if (! confFile.exists()) {
			throw new WorkflowException(path + " is not found.");
		}
		if (! confFile.isFile()) {
			throw new WorkflowException(path + " is not file.");
		}
		return path;
	}
	
	/**
	 * GWÕK[ԂB
	 *
	 * @return GWÕK[
	 */
	static public Logger getEngineLogger()
	{
		return Logger.getLogger(ENGINE_LOGGER);
	}
	
	/**
	 * čÕK[ԂB
	 *
	 * @return čÕK[
	 */
	static public Logger getAuditLogger()
	{
		return Logger.getLogger(AUDIT_LOGGER);
	}
	
	/**
	 * ZLeBÕK[ԂB
	 *
	 * @return ZLeBÕK[
	 */
	static public Logger getSercurityLogger()
	{
		return Logger.getLogger(SECURITY_LOGGER);
	}
}
