/* $Id: MessageBroker.java,v 1.11 2005/08/26 04:53:46 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ActiveMQ𗘗pbZ[WǗ@\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
class MessageBroker
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** MessageBroker̃VOgCX^X */
	static private MessageBroker broker;
	
	/** MQڑt@Ng[ */
	private ActiveMQConnectionFactory factory;
	
	/** bZ[WL[Ǘ}bv */
	private Map queues;
	
	/**
	 * MessageBrokeȑsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws WorkflowException
	{
		if (broker != null) {
			// Message queue already initialized.
			String msg = StringManager.get("E0054");
			eLog.error(msg);
			throw new WorkflowException(msg);
		}
		String[] args = new String[1];
		String path = getConfigPath();
		
		try {
			broker = new MessageBroker(path);
		} catch (Exception ex) {
			// Message queue configuration failed.
			String msg = StringManager.get("E0055");
			eLog.error(msg, ex);
			throw new WorkflowException(msg, ex);
		}
	}
	
	/**
	 * ݒt@C̃pX擾B
	 *
	 * @return pX
	 * @throws WorkflowException 擾ɗONꍇ
	 */
	static private String getConfigPath()
	throws WorkflowException
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String conf = System.getProperty(WorkflowEngineConstants.NAUTICA_MQ_CONFIG);
		String separator = System.getProperty("file.separator");
		String path = home
		                   + separator + "config"
						   + separator + conf;
		File confFile = new File(path);
	
		if (! confFile.exists()) {
			String msg = StringManager.get("E0057")
			    + "(ConfigPath=" + path + ")";
			eLog.error(msg);
			throw new WorkflowException(msg);
		}
		if (! confFile.isFile()) {
			String msg = StringManager.get("E0058")
    		    + "(ConfigPath=" + path + ")";
			eLog.error(msg);
			throw new WorkflowException(msg);
		}
		try {
			return confFile.toURL().toString();
		} catch (Exception ex) {
			String msg = StringManager.get("E0059")
			    + "(ConfigPath=" + path + ")";;
			eLog.error(msg, ex);
			throw new WorkflowException(msg, ex);
		}
	}

	/**
	 * MessageBroker̃CX^XԂB
	 *
	 * @return MessageBroker
	 */
	static MessageBroker getInstance()
	{
		return broker;
	}
	
	/**
	 * MessageBroker𐶐B
	 *
	 * @param path pX
	 */
	private MessageBroker(String path)
	{
		factory = new ActiveMQConnectionFactory("vm://localhost");
		factory.setBrokerXmlConfig(path);
		queues = new Hashtable();
	}
	
	/**
	 * bZ[WL[𐶐B
	 *
	 * @param queueName L[
	 * @param adapter A_v^
	 * @throws WorkflowException bZ[WL[ɗONꍇ
	 */
	void generateQueue(String queueName, WorkflowMessageAdapter adapter)
	throws WorkflowException
	{
		if (queues.containsKey(queueName)) {
			// ɓÕL|
			String msg = StringManager.get("E0056");
			eLog.error(msg);
			throw new WorkflowException(msg);
		}
		WorkflowMQ queue = new WorkflowMQ(factory, queueName, adapter);
		queues.put(queueName, queue);
		queue.start();
	}
	
	/**
	 * Ǘ̃L[Vbg_EAT[rX~B
	 */
	void shutdown()
	{
		Iterator it = queues.values().iterator();
		
		while (it.hasNext()) {
			WorkflowMQ queue = (WorkflowMQ)it.next();
			queue.shutdown();
		}
	}
	
	/**
	 * bZ[WL[ԂB
	 *
	 * @param queueName L[
	 * @return bZ[WL[
	 */
	public WorkflowMQ getWorkflowMQ(String queueName)
	{
		return (WorkflowMQ)queues.get(queueName);
	}
}
