/* $Id: MessageTransporter.java,v 1.5 2005/08/26 04:53:15 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;

/**
 * w肳ꂽL[ɑ΂郁bZ[Wz@\
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class MessageTransporter
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** L[ */
	private String queueName;
	
	/**
	 * w肳ꂽL[ɑ΂郁bZ[Wz@\𐶐B
	 *
	 * @param queueName L[
	 */
	MessageTransporter(String queueName)
	{
		this.queueName = queueName;
	}
	
	/**
	 * bZ[WL[ɃbZ[W𑗂B
	 *
	 * @param msg bZ[W
	 * @throws MessagingException MɗOꍇ
	 */
	public void sendMessage(WorkflowMessage msg)
	throws MessagingException
	{
		MessageBroker broker = MessageBroker.getInstance();
		WorkflowMQ mq = broker.getWorkflowMQ(queueName);
		mq.send(msg);
	}
}
