/* $Id: ProcessInternal.java,v 1.28 2005/08/26 04:53:44 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.VariableFilterConverter;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.omg.AlreadyRunningException;
import jp.co.argo21.nautica.workflow.omg.AlreadySuspendedException;
import jp.co.argo21.nautica.workflow.omg.CannotChangeRequesterException;
import jp.co.argo21.nautica.workflow.omg.CannotResumeException;
import jp.co.argo21.nautica.workflow.omg.CannotStartException;
import jp.co.argo21.nautica.workflow.omg.CannotStopException;
import jp.co.argo21.nautica.workflow.omg.CannotSuspendException;
import jp.co.argo21.nautica.workflow.omg.HistoryNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.InvalidDataException;
import jp.co.argo21.nautica.workflow.omg.InvalidStateException;
import jp.co.argo21.nautica.workflow.omg.NotRunningException;
import jp.co.argo21.nautica.workflow.omg.NotSuspendedException;
import jp.co.argo21.nautica.workflow.omg.ResultNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.UpdateNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.FormalParameter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * GWŎgpvZXCX^XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.28 $
 * @since   Nautica Workflow 0.9
 */
class ProcessInternal implements WfProcess
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** vZX */
	private Process process;
	
	/** p[^ */
	private FormalParameter[] params;
	
	/** NGX^ */
	private WfRequester requester;

	/**
	 * pvZX𐶐B
	 *
	 * @param proc vZX
	 * @param params p[^
	 */
	public ProcessInternal(Process proc, FormalParameter[] params)
	{
		this.process = proc;
		this.params = params;
	}

	/**
	 * vZXv҂ԂB
	 *
	 * @return vZXv
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getRequester()
	 */
	public WfRequester getRequester() throws WorkflowException
	{
		return requester;
	}

	/**
	 * vZX́AWfProcessMgrɊ֘AtB
	 * WfProcess鎞_Ŋ֘AtsAύX͂łȂB
	 *
	 * @return vZX}l[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getManager()
	 */
	public WfProcessManager getManager() throws WorkflowException
	{
		ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
		WfProcessManager pm = pmf.getOwnerProcessManager(process.getID());
		return pm;
	}

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getID()
	 */
	public String getID() throws WorkflowException
	{
		return process.getID();
	}

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getName()
	 */
	public String getName() throws WorkflowException
	{
		return process.getName();
	}

	/**
	 * ڍ׏ԂB
	 *
	 * @return ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getDescription()
	 */
	public String getDescription() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ݂̏ԂԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getState()
	 */
	public WfState getState() throws WorkflowException
	{
		return ProcessState.getState(process.getProcessState());
	}

	/**
	 * ݂̏ԂJډ\ȏԂ̈ꗗԂB
	 *
	 * @return Jډ\ȏԂ̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getTransitableStates()
	 */
	public WfState[] getTransitableStates() throws WorkflowException
	{
		return ProcessState.getTransitableStates(process.getProcessState());
	}

	/**
	 * ŌɏԂJڂԂԂB
	 *
	 * @return ŏIԕύX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getLastStateTime()
	 */
	public String getLastStateTime() throws WorkflowException
	{
		return process.getUpdateDate().toString();
	}

	/**
	 * sIuWFNgɂ鑮ꗗԂB
	 *
	 * @return ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getContext()
	 */
	public WfNameValue[] getContext() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean[] beans = variableDAO.findByProcessID(process.getID());
			
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̎擾Ɏs܂B
			String E0032 = StringManager.get("E0032");
			throw new WorkflowException(E0032, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ԂB
	 *
	 * @param name 
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getContext()
	 */
	public WfNameValue getContext(String name) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean beans = variableDAO.findByName(process.getID(), name);
			
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̎擾Ɏs܂B
			String E0032 = StringManager.get("E0032");
			throw new WorkflowException(E0032, ex);
		}
	}

	/**
	 * WfProcessɂĐ錋ʂԂB
	 * vZX܂ł͌ʂ͒`ȂB
	 * ʂ̎擾܂擾łȂꍇ́AOB
	 *
	 * @return 
	 * @throws ResultNotAvailableException ʂ擾łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getResult()
	 */
	public WfNameValue[] getResult() throws ResultNotAvailableException,
			WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ύX̐ԂB
	 *
	 * @return ύX̐
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getHistoryCount()
	 */
	public int getHistoryCount() throws HistoryNotAvailableException,
			WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * CfNXw肵āA擾B
	 *
	 * @param index CfNX
	 * @return ύX
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getHistory(int)
	 */
	public WfEvent getHistory(int index) throws HistoryNotAvailableException,
			WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ̎sIuWFNgɊւύX擾B
	 *
	 * @return ύX̐
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getAllHistories()
	 */
	public WfEvent[] getAllHistories() throws HistoryNotAvailableException,
			WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * Ŏw肳ꂽԂANeBreBԂB
	 *
	 * @param state 
	 * @return ANeBreB
	 * @throws InvalidStateException sȏ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getActivitiesInState(java.lang.String)
	 */
	public WfActivity[] getActivitiesInState(String state)
			throws InvalidStateException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * _̑SXebvԂB
	 *
	 * @return SXebv
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getAllSteps()
	 */
	public WfActivity[] getAllSteps() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * XebvIDŎw肳ꂽANeBreBԂB
	 *
	 * @param aid ANeBreBID
	 * @return ANeBreB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws WorkflowException
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getStep(java.lang.String)
	 */
	public WfActivity getStep(String aid) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();
			
			ActivityBean bean = actDAO.findByPrimaryKey(process.getID(), aid);
			ActivityInternal act = null;
			if (bean != null) {
				act = new ActivityInternal(bean);
			}
			return act;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB̎擾Ɏs܂B
			String E0124 = StringManager.get("E0124") + "(" + aid + ")";
			throw new WorkflowException(E0124, ex);
		}
	}

	/**
	 * 0ȏWfActiviyvZXɊ֘AtB
	 * Xebv́A_ŃvZXopenȏԂłANeBreB\̂ƂB
	 * ł́AXebv̌ԂB
	 *
	 * @return Xebv̌
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#getStepCount()
	 */
	public int getStepCount() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * Ŏw肳ꂽANeBreBÃvZX̃XebvɏĂ邩ǂԂB
	 *
	 * @param act ANeBreB
	 * @return Ăꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#isMemberOfStep(jp.co.argo21.nautica.workflow.omg.WfActivity)
	 */
	public boolean isMemberOfStep(WfActivity act) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ̂ݒ肷B
	 *
	 * @param name 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setName(java.lang.String)
	 */
	public void setName(String name) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO processDAO = daoFactory.getProcessDAO();
			
			processDAO.updateName((ProcessBean)process, name);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̐ݒɎs܂B
			String E0125 = StringManager.get("E0125");
			throw new WorkflowException(E0125, ex);
		}
	}

	/**
	 * vZXv҂vZXɊ֘AtB
	 * vZXꂽ_ŁÅ֘AtsB
	 * vZX́AWfRequester̃C^tF[XʂāAԂ̕ύXʒmB
	 *
	 * @param requester vZXv
	 * @throws CannotChangeRequesterException vZXv҂XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#setRequester(jp.co.argo21.nautica.workflow.omg.WfRequester)
	 */
	public void setRequester(WfRequester requester)
			throws CannotChangeRequesterException, WorkflowException
	{
		this.requester = requester;
	}

	/**
	 * ڍ׏ݒ肷B
	 *
	 * @param desc ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setDescription(java.lang.String)
	 */
	public void setDescription(String desc) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * sIuWFNgɂ鑮ꗗݒ肷B
	 *
	 * @param context ꗗ
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setContext(jp.co.argo21.nautica.workflow.omg.WfNameValue[])
	 */
	public void setContext(WfNameValue[] context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		try {
			long now = System.currentTimeMillis();
			Timestamp ts = DataAccessManager.getAccessTime();
			
			setContext(context, ts);

		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ݒ肷B
	 *
	 * @param context 
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setContext(jp.co.argo21.nautica.workflow.omg.WfNameValue[])
	 */
	public void setContext(WfNameValue context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		try {
			long now = System.currentTimeMillis();
			Timestamp ts = DataAccessManager.getAccessTime();
			
			setContext(context, ts);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * w肳ꂽԂɑJڂ݂B
	 *
	 * @param state 
	 * @throws InvalidStateException ȏԂ̏ꍇ
	 * @throws TransitionNotAllowedException w肳ꂽԂɑJڂłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#changeState(jp.co.argo21.nautica.workflow.omg.WfState)
	 */
	public void changeState(WfState state)
	throws InvalidStateException, TransitionNotAllowedException, WorkflowException
	{
		if (state instanceof ProcessState == false) {
			// vZXԂł͂܂B
			String E0126 = StringManager.get("E0126");
			throw new InvalidStateException(E0126);
		}		

		if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
			// ȃvZXԂw肳܂B
			String E0127 = StringManager.get("E0127");
			throw new TransitionNotAllowedException(E0127);
		} else if (ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
			suspend();
		} else if (ProcessState.OPEN_RUNNING.equals(state)) {
			if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(getState())) {
				start();
			} else {
				resume();
			}
		} else if (ProcessState.CLOSED_COMPLETED.equals(state)) {
			complete();
		} else if (ProcessState.CLOSED_TERMINATED.equals(state)) {
			terminate();
		} else if (ProcessState.CLOSED_ABORTED.equals(state)) {
			abort();
		}

		//GWԐڑ𗘗pĂꍇ
		String pid = process.getID();
		String useInterWorkflow = System.getProperty(WorkflowEngineConstants.NAUTICA_INTER_WORKFLOW);
		if (useInterWorkflow != null && useInterWorkflow.equals("enable")) {
			InterWorkflowConnectorImpl iwc =
				(InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
			//pĂꍇ͕Kvɉă[g̃GWɒʒm
			iwc.processStateChangedLocal(pid, (ProcessState)state);
		}
	}

	/**
	 * WfProcess̎sJn邽߂ɎgpB
	 * vZX̏Ԃ́Aopen.not_runningopen.runningɕωB
	 *
	 * @throws CannotStartException JnłȂꍇ
	 * @throws AlreadyRunningException łɊJnĂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcess#start()
	 */
	public void start()
	throws CannotStartException, AlreadyRunningException, WorkflowException
	{
		try {
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				// vZX͂łɏIĂ܂B
				String E0128 = StringManager.get("E0128");
				throw new NotRunningException(E0128);
			} else if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state) == false) {
				// vZX͂łɊJnĂ܂B
				String E0129 = StringManager.get("E0129");
				throw new AlreadyRunningException(E0129);
			}

			ProcessBean pbean = getBean();
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			procDAO.updateState(pbean, ProcessState.OPEN_RUNNING, ts);

			//ΉvZX`̎擾
			String pdid = process.getProcDefinitionID();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			ProcessDefinition pd = rep.getProcessDefinition(pdid);
			
			//JnANeBreB`̒T
			ActivityDefinition ad = findStartActivity(pd);

			//JnANeBreB̓o^
			ActivityBean abean = createActivity(pd, ad, pbean);
			
			//bZ[WL[ɓo^
			String pid = abean.getProcessID();
			String aid = abean.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, aid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);

		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̊JnɎs܂B
		    String E0132 = StringManager.get("E0132");
			throw new WorkflowException(E0132, ex);
		}
	}

	/**
	 * ۗ̎sIuWFNg̍ĊJvB
	 * v󂯓ꂽꍇAԂ́Aopen.not_running.suspendedA
	 * open.runningɐݒ肳B
	 *
	 * @throws CannotResumeException ĊJłȂꍇ 
	 * @throws NotRunningException słȂꍇ
	 * @throws NotSuspendedException ۗĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#resume()
	 */
	public void resume()
	throws CannotResumeException, NotRunningException,
		NotSuspendedException, WorkflowException
	{
		try {
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				// vZX͂łɏIĂ܂B
				String E0128 = StringManager.get("E0128");
				throw new NotRunningException(E0128);
			} else if (ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state) == false) {
				// vZX͕ۗĂ܂B
				String E0138 = StringManager.get("E0138");
				throw new NotSuspendedException(E0138);
			}

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();

			procDAO.updateState(getBean(), ProcessState.OPEN_RUNNING, ts);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̍ĊJɎs܂B
			String E0133 = StringManager.get("E0133");
			throw new WorkflowException(E0133, ex);
		}
	}

	/**
	 * sIuWFNgۗ̕vB
	 * v󂯓ꂽꍇAԂ́Aopen.not_running.suspendedɐݒ肳B
	 *
	 * @throws CannotSuspendException ۗłȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws AlreadySuspendedException łɕۗĂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#suspend()
	 */
	public void suspend()
	throws CannotSuspendException, NotRunningException,
		AlreadySuspendedException, WorkflowException
	{
		try {
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				// vZX͂łɏIĂ܂B
				String E0128 = StringManager.get("E0128");
				throw new NotRunningException(E0128);
			} else if (ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
				// vZX͂łɕۗĂ܂B
				String E0130 = StringManager.get("E0130");
				throw new AlreadySuspendedException(E0130);
			}

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();

			procDAO.updateState(getBean(), ProcessState.OPEN_NOT_RUNNING_SUSPENDED, ts);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXۗ̕Ɏs܂B
			String E0134 = StringManager.get("E0134");
			throw new WorkflowException(E0134, ex);
		}
	}

	/**
	 * vZX̊v邽߂ɁAAvP[VɂĎgpB
	 *
	 * @throws CannotStopException łȂꍇ
	 * @throws NotRunningException vZXsłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void complete()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			if (closedAlready) {
				//łɂق̃ANeBreBɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				procDAO.updateDate(getBean(), ts);
			} else {
				procDAO.updateState(getBean(), ProcessState.CLOSED_COMPLETED, ts);
			}

			String pid = process.getID();
			ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
			ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
			
			//҂킹ĂeANeBreBꍇAvoB
			if (pwbean != null && closedAlready == false) {
				String rpid = pwbean.getProcID();
				String raid = pwbean.getActID();
				//bZ[WL[Ɋvo^
				WorkflowEngine engine = WorkflowEngine.getInstance();
				WorkflowMessage earmsg = new EndActivityRequestMessage(rpid, raid);
				SystemMessageTransporter mt = new SystemMessageTransporter(EndActivityRequestWatcher.NAME);
				mt.sendMessage(earmsg);
			} else {
				//vZXAN҂ɒʒmKvAOo͂ɗ߂B
				// vZX܂B
				String I0047 = StringManager.get("I0047") + "(" + pid + ")";
				eLog.info(I0047);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̊Ɏs܂B
			String E0135 = StringManager.get("E0135");
			throw new WorkflowException(E0135, ex);
		}
	}

	/**
	 * s̎sIuWFNg̒~vB
	 * v󂯓ꂽꍇAԂclosed.terminatedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#terminate()
	 */
	public void terminate()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		terminate(true);
	}

	/**
	 * ۗꂽsIuWFNg̒fvB
	 * v󂯓ꂽꍇAԂclosed.abortedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#abort()
	 */
	public void abort()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		abort(true);
	}

	/**
	 * tB^[œ肳ꂽvZXϐԂB
	 *
	 * @param filter tB^[
	 * @return vZXϐ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	WfNameValue[] getContext(Filter filter) throws WorkflowException
	{
		try {
			String sqlPart = new VariableFilterConverter().convertToSQL(filter);
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean[] beans = variableDAO.findBySQLPart(process.getID(), sqlPart);
			
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̎擾Ɏs܂B
			String E0032 = StringManager.get("E0032");
			throw new WorkflowException(E0032, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ꗗݒ肷B
	 *
	 * @param context ꗗ
	 * @param ts ^CX^v
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void setContext(WfNameValue[] context, Timestamp ts)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		if (context == null) {
			// vZXϐݒłB
			String E0131 = StringManager.get("E0131");
			throw new InvalidDataException(E0131);
		}

		try {
			String pid = process.getID();
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();

			for (int i = 0; i < context.length; i++) {
				if (context[i] instanceof Attribute == false) {
					// vZXϐƂĔFłȂli[Ă܂B
					String E0139 = StringManager.get("E0139");
					throw new InvalidDataException(E0139);
				}
				Attribute attr = (Attribute)context[i];
				VariableBean bean = new VariableBean();
				bean.setName(attr.getName());
				bean.setType(attr.getType());
				bean.setValue(attr.getValue());
				VariableBean check = variableDAO.findByPrimaryKey(
						bean.getProcessID(), bean.getID());
				if (check == null) {
					bean.setProcessID(pid);
					bean.setUpdateDate(ts);
					bean.setID(UniqueKeyGenerator.generate(VariableBean.ID_PREFIX));
					variableDAO.insert(bean, null);
				} else {
					variableDAO.update(check, bean.getValue(), null, ts);
				}
			}

			//GWԐڑ𗘗pĂꍇ
			String useInterWorkflow = System.getProperty(WorkflowEngineConstants.NAUTICA_INTER_WORKFLOW);
			if (useInterWorkflow != null && useInterWorkflow.equals("enable")) {
				InterWorkflowConnectorImpl iwc =
					(InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
				//pĂꍇ͕Kvɉă[g̃GWɒʒm
				iwc.processAttributesChangedLocal(pid, (Attribute[])context);
			}
			
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ݒ肷B
	 *
	 * @param context 
	 * @param ts ^CX^v
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void setContext(WfNameValue context, Timestamp ts)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		if (context == null) {
			// vZXϐݒłB
			String E0131 = StringManager.get("E0131");
			throw new InvalidDataException(E0131);
		}

		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();

			if (context instanceof Attribute == false) {
				// vZXϐƂĔFłȂli[Ă܂B
				String E0139 = StringManager.get("E0139");
				throw new InvalidDataException(E0139);
			}
			Attribute attr = (Attribute)context;
			VariableBean bean = new VariableBean();
			bean.setProcessID(process.getID());
			bean.setName(attr.getName());
			bean.setType(attr.getType());
			bean.setValue(attr.getValue());
			VariableBean check = variableDAO.findByName(
					bean.getProcessID(), bean.getName());
			if (check == null) {
				bean.setUpdateDate(ts);
				bean.setID(UniqueKeyGenerator.generate(VariableBean.ID_PREFIX));
				variableDAO.insert(bean, null);
			} else {
				variableDAO.update(check, bean.getValue(), null, ts);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * tB^[œ肳ꂽANeBreBԂB
	 *
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws InvalidFilterException ȃtB^[ݒ肳ꂽꍇ
	 */
	Activity[] getActivities(Filter filter)
	throws InvalidFilterException
	{
		try {
			
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();

			ActivityBean[] beans = actDAO.findByFilter(process.getID(), filter);
			return beans;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB̎擾Ɏs܂B
			String E0124 = StringManager.get("E0124");
			throw new InvalidFilterException(E0124, ex);
		}
	}

	/**
	 * ێĂvZXԂB
	 *
	 * @return vZX
	 */
	ProcessBean getBean()
	{
		return (ProcessBean)process;
	}

	/**
	 * s̎sIuWFNg̒~vB
	 * v󂯓ꂽꍇAԂclosed.terminatedɐݒ肳B
	 *
	 * @param checkChild ANeBreB`bN邩ǂ
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void terminate(boolean checkChild)
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}

			String pid = process.getID();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			if (closedAlready) {
				//łɂق̃ANeBreBɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				procDAO.updateDate(getBean(), ts);
			} else {
				procDAO.updateState(getBean(), ProcessState.CLOSED_TERMINATED, ts);

				if (checkChild) {
					ActivityDAO actDAO = daoFactory.getActivityDAO();
					ActivityBean[] acts = actDAO.findOpeningActivityByProcessID(pid);

					//Ǘ̃ANeBreBabortB
					for (int i = 0; i < acts.length; i++) {
						String aid = acts[i].getActivityID();
						ActivityInternal act = (ActivityInternal)getStep(aid);
						act.abort();
					}
				}
			}
		
			ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
			ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
			
			//҂킹ĂeANeBreBꍇAvoB
			if (pwbean != null && closedAlready == false) {
				String rpid = pwbean.getProcID();
				String raid = pwbean.getActID();
				//bZ[WL[Ɋvo^
				WorkflowEngine engine = WorkflowEngine.getInstance();
				WorkflowMessage earmsg = new EndActivityRequestMessage(rpid, raid, ProcessState.CLOSED_TERMINATED);
				SystemMessageTransporter mt = new SystemMessageTransporter(EndActivityRequestWatcher.NAME);
				mt.sendMessage(earmsg);
			} else {
				//vZX~AN҂ɒʒmKvAOo͂ɗ߂B
				// vZX~(TERMINATED)܂B
				String I0048 = StringManager.get("I0048") + "(" + pid + ")";
				eLog.info(I0048);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̒~Ɏs܂B
			String E0136 = StringManager.get("E0136");
			throw new WorkflowException(E0136, ex);
		}
	}

	/**
	 * ۗꂽsIuWFNg̒fvB
	 * v󂯓ꂽꍇAԂclosed.abortedɐݒ肳B
	 *
	 * @param checkChild ANeBreB`bN邩ǂ
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void abort(boolean checkChild)
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ProcessState state = (ProcessState)getState();
			
			if (ProcessState.CLOSED_COMPLETED.equals(state)
					|| ProcessState.CLOSED_TERMINATED.equals(state)
					|| ProcessState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}

			String pid = process.getID();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			if (closedAlready) {
				//łɂق̃ANeBreBɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				procDAO.updateDate(getBean(), ts);
			} else {
				procDAO.updateState(getBean(), ProcessState.CLOSED_ABORTED, ts);

				if (checkChild) {
					ActivityDAO actDAO = daoFactory.getActivityDAO();
					ActivityBean[] acts = actDAO.findOpeningActivityByProcessID(pid);

					//Ǘ̃ANeBreBabortB
					for (int i = 0; i < acts.length; i++) {
						String aid = acts[i].getActivityID();
						ActivityInternal act = (ActivityInternal)getStep(aid);
						act.abort();
					}
				}
			}
			
			ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
			ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
			
			//҂킹ĂeANeBreBꍇAvoB
			if (pwbean != null && closedAlready == false) {
				String rpid = pwbean.getProcID();
				String raid = pwbean.getActID();
				//bZ[WL[Ɋvo^
				WorkflowEngine engine = WorkflowEngine.getInstance();
				WorkflowMessage earmsg = new EndActivityRequestMessage(rpid, raid, ProcessState.CLOSED_ABORTED);
				SystemMessageTransporter mt = new SystemMessageTransporter(EndActivityRequestWatcher.NAME);
				mt.sendMessage(earmsg);
			} else if (closedAlready) {
				//łɃvZXN[YĂ̂ŉȂB
			} else {
				//vZX~AN҂ɒʒmKvAOo͂ɗ߂B
				// vZX~(ABORTED)܂B
				String I0049 = StringManager.get("I0049") + "(" + pid + ")";
				eLog.info(I0049);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̒~Ɏs܂B
			String E0137 = StringManager.get("E0137");
			throw new WorkflowException(E0137, ex);
		}
	}

	/**
	 * JnANeBreB`B
	 *
	 * @param pd vZX`ID
	 * @return JnANeBreB`
	 * @throws Exception Cӂ̗ONꍇ
	 */
	private ActivityDefinition findStartActivity(ProcessDefinition pd)
	throws Exception
	{
		List acts = pd.getActivities();
		Iterator it = acts.iterator();
		
		ActivityDefinition ad = null;
		while (it.hasNext()) {
			ActivityDefinition def = (ActivityDefinition)it.next();
			if (def.getType().equals(ActivityDefinition.START)) {
				ad = def;
				break;
			}
		}
		
		if (ad == null) {
			// vZX`ɊJnANeBreB܂B
			String E0140 = StringManager.get("E0140");
			throw new WorkflowException(E0140);
		}
		
		return ad;
	}

	/**
	 * vZXɈŎw肳ꂽANeBreB𐶐B
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param pbean vZX
	 * @return ANeBreB
	 * @throws Exception Cӂ̗ONꍇ
	 */
	private ActivityBean createActivity(
			ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean)
	throws Exception
	{
		//JnANeBreB̓o^
		Timestamp ts = DataAccessManager.getAccessTime();
		int du = pd.getDurationUnit();
		int limit = ad.getLimit();
		long durationLimit = ts.getTime() + DurationHelper.calculateDuration(du, limit);
		Timestamp limitTs = new Timestamp(durationLimit);
		
		ActivityBean abean = new ActivityBean();
		abean.setActivityDefinitionID(ad.getID());
		abean.setActivityID(UniqueKeyGenerator.generate(ActivityBean.ID_PREFIX));
		abean.setActivityState(ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
		abean.setActorID(ParticipantImpl.SYSTEM_ID);
		abean.setDurationLimit(limitTs);
		abean.setProcessID(pbean.getID());
		abean.setStartDate(ts);
		abean.setStarterID(pbean.getStarterID());
		abean.setUpdateDate(ts);
		
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		actDAO.insert(abean);
		
		return abean;
	}
}
