/* $Id: ProcessManager.java,v 1.20 2005/08/26 04:53:11 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.omg.InvalidRequesterException;
import jp.co.argo21.nautica.workflow.omg.NotEnabledException;
import jp.co.argo21.nautica.workflow.omg.RequesterRequiredException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.FormalParameter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

/**
 * ЂƂ̃vZX`ɑvZXCX^X̐
 * ǗsB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.20 $
 * @since   Nautica Workflow 0.9
 */
class ProcessManager implements WfProcessManager
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	private String definitionID;
	private PackageDefinition packageDefifinition;
	private ProcessDefinition processDefinition;
	
	/**
	 * vZX}l[W𐶐B
	 */
	public ProcessManager(String pdid) throws InvalidProcessDefinitionException
	{
		this.definitionID = pdid;
		try {
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			packageDefifinition = rep.getPackageDefinition(pdid);
			processDefinition = rep.getProcessDefinition(pdid);
			
			init();
		} catch (Exception ex) {
			// vZX}l[W̐Ɏs܂B
			String E0149 = StringManager.get("E0149") + "(ProcessDefinitionID = " + pdid + ")";
			throw new InvalidProcessDefinitionException(E0149, ex);
		}
	}
	
	private void init()
	{
	}

	/**
	 * ǗĂvZX̌ԂB
	 *
	 * @return vZX̌
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getProcessCount()
	 */
	public int getProcessCount() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			return procDAO.findCountByPDID(definitionID);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̎擾Ɏs܂B
			String E0150 = StringManager.get("E0150");
			throw new WorkflowException(E0150, ex);
		}
	}

	/**
	 * IDŎw肳ꂽvZXԂB
	 *
	 * @param pid vZXID
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getProcess(java.lang.String)
	 */
	public WfProcess getProcess(String pid) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			ProcessBean bean = procDAO.findByPDIDandPID(definitionID, pid);
			FormalParameter[] params = (FormalParameter[])getResultSignature();
			WfProcess proc = new ProcessInternal(bean, params);
			//NGX^ǂ邩
			return proc;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̎擾Ɏs܂B
			String E0151 = StringManager.get("E0151") + "(ProcessID = " + pid + ")" ;
			throw new WorkflowException(E0151, ex);
		}
	}

	/**
	 * Ǘׂ̂ẴvZXԂB
	 *
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getAllProcesses()
	 */
	public WfProcess[] getAllProcesses() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			ProcessBean[] beans = procDAO.findByPDID(definitionID);
			ProcessInternal[] procs = new ProcessInternal[beans.length];
			
			for (int i = 0; i < beans.length; i++) {
				FormalParameter[] params = (FormalParameter[])getResultSignature();
				procs[i] = new ProcessInternal(beans[i], params);
				//NGX^ǂ邩
			}
			return procs;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// Ǘ̑SvZX̎擾Ɏs܂B
			String E0159 = StringManager.get("E0159");
			throw new WorkflowException(E0159, ex);
		}
	}

	/**
	 * Ŏw肳ꂽvZXAǗɂ邩ǂԂB
	 *
	 * @param member vZXID
	 * @return Ǘɂꍇ́ATrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#isMemberOfProcess(java.lang.String)
	 */
	public boolean isMemberOfProcess(String member) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
			= DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			Process proc = procDAO.findByPDIDandPID(definitionID, member);
			return (proc != null);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̔Ɏs܂B
			String E0152 = StringManager.get("E0152");
			throw new WorkflowException(E0152, ex);
		}
	}

	/**
	 * JeS[ԂB
	 *
	 * @return JeS
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getCategory()
	 */
	public String getCategory() throws WorkflowException
	{
		return packageDefifinition.getName();
	}

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getName()
	 */
	public String getName() throws WorkflowException
	{
		return processDefinition.getName();
	}

	/**
	 * o[WԂB
	 *
	 * @return o[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getVersion()
	 */
	public String getVersion() throws WorkflowException
	{
		return packageDefifinition.getVersion();
	}

	/**
	 * ڍ׏ԂB
	 *
	 * @return ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getDescription()
	 */
	public String getDescription() throws WorkflowException
	{
		return processDefinition.getDescription();
	}

	/**
	 * ԂԂBVK̃vZX̉ۂԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getState()
	 */
	public WfState getState() throws WorkflowException
	{
		try {
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			return rep.getProcessDefinitionState(definitionID);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXԂ̎擾Ɏs܂B
			String E0154 = StringManager.get("E0154");
			throw new WorkflowException(E0154, ex);
		}
	}

	/**
	 * Ԃݒ肷B
	 *
	 * @param state 
	 * @throws TransitionNotAllowedException ̏ԂɑJڂłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#setState(jp.co.argo21.nautica.workflow.omg.WfState)
	 */
	public void setState(WfState state) throws TransitionNotAllowedException,
			WorkflowException
	{
		try {
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			rep.setProcessDefinitionState(definitionID,
				(ProcessDefinitionState)state);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXԂ̐ݒɎs܂B
			String E0155 = StringManager.get("E0155");
			throw new WorkflowException(E0155, ex);
		}
	}

	/**
	 * CX^X̃ReLXg̐ݒ@`郁^ԂB
	 * 炩ԂlAttribute^ƂA
	 * IDAvZXIDAXVɂĂ͏ĂȂ̂ƂB
	 * ̍ڂ̏́Ã\bh𗘗pŐӔC𕉂̂ƂB
	 *
	 * @return ReLXgVOj`
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getContextSignature()
	 */
	public WfNameValue[] getContextSignature() throws WorkflowException
	{
		List varDefs = packageDefifinition.getVariables();
		List vars = new ArrayList();
		Iterator it = varDefs.iterator();
		while (it.hasNext()) {
			VariableDefinition varDef = (VariableDefinition)it.next();
			VariableBean bean = new VariableBean();
			bean.setVariableDefinitionID(varDef.getID());
			bean.setName(varDef.getName());
			bean.setType(varDef.getType());
			bean.setValue(varDef.getInitialValue());
			vars.add(bean);
		}
		return (VariableBean[])vars.toArray(new VariableBean[vars.size()]);
	}

	/**
	 * CX^XʂԂ@w肷郁^ԂB
	 * 炩ԂlFormalParameter^ƂA
	 * lɂĂ͏ĂȂ̂ƂB
	 * ̍ڂ̏́Ã\bh𗘗pŐӔC𕉂̂ƂB
	 *
	 * @return vZXϐ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#getResultSignature()
	 */
	public WfNameValue[] getResultSignature() throws WorkflowException
	{
		List paramDefs = processDefinition.getParameters();
		List params = new ArrayList();
		Iterator it = paramDefs.iterator();
		while (it.hasNext()) {
			ParameterDefinition paramDef = (ParameterDefinition)it.next();
			FormalParameterBean bean = new FormalParameterBean();
			bean.setID(paramDef.getID());
			bean.setName(paramDef.getName());
			bean.setType(paramDef.getType());
			bean.setMode(paramDef.getMode());
			bean.setDescription(paramDef.getDescription());
			params.add(bean);
		}
		return (FormalParameterBean[])params.toArray(new FormalParameterBean[params.size()]);
	}

	/**
	 * vZX̃CX^X𐶐ANGX^ɌB
	 * vZXƁAnot_running.not_started̏Ԃɐݒ肳B
	 *
	 * @param requester vZXNGX^
	 * @param name lʉ\ȃvZX
	 * @return ꂽvZX
	 * @throws NotEnabledException vZXłȂꍇ
	 * @throws InvalidRequesterException NGX^Ȃꍇ
	 * @throws RequesterRequiredException NGX^w肳ĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfProcessManager#createProcess(jp.co.argo21.nautica.workflow.omg.WfRequester, java.lang.String)
	 */
	public WfProcess createProcess(WfRequester requester, String name)
			throws NotEnabledException, InvalidRequesterException,
			RequesterRequiredException, WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ProcessDAO processDAO = daoFactory.getProcessDAO();
			VariableDAO variableDAO = daoFactory.getVariableDAO();

			long now = System.currentTimeMillis();
			
			ProcessBean processBean = insertProcess(processDAO, requester, name, now);

			VariableBean[] vars = (VariableBean[])getContextSignature();
			for (int i = 0; i < vars.length; i++) {
				VariableBean variableBean = vars[i];
				insertVariable(variableDAO, processBean, variableBean, now);
			}
			
			FormalParameter[] params = (FormalParameter[])getResultSignature();
			WfProcess proc = new ProcessInternal(processBean, params);
			proc.setRequester(requester);
			return proc;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̐Ɏs܂B
			String E0153 = StringManager.get("E0153");
			throw new WorkflowException(E0153, ex);
		}		
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param filter ptB^[
	 * @param state VvZXCX^X
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	void changeProcessesState(Filter filter, ProcessState state)
	throws InvalidFilterException, InvalidStateException,
		TransitionNotAllowedException
	{
		try {
			Process[] procs = getProcesses(filter);
			
			for (int i = 0; i < procs.length; i++) {
				String pid = procs[i].getID();
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				process.changeState(state);
			}
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (InvalidStateException ex) {
			throw ex;
		} catch (TransitionNotAllowedException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXԂ̕ύXɎs܂B
			String E0156 = StringManager.get("E0156");
			throw new TransitionNotAllowedException(E0156, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param state VANeBreBCX^X
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	void changeActivitiesState(String adid, Filter filter, ActivityState state)
	throws InvalidActivityNameException, InvalidFilterException,
		InvalidStateException, TransitionNotAllowedException
	{
		try {
			Activity[] acts = getActivities(adid, filter);
			
			for (int i = 0; i < acts.length; i++) {
				String pid = acts[i].getProcessID();
				String aid = acts[i].getActivityID();
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				WfActivity activity = process.getStep(aid);
				if (activity == null) {
					// YANeBreB݂܂B
					String msg = StringManager.get("E0069");
					throw new InvalidActivityInstanceException(msg);
				}
				activity.changeState(state);
			}
		} catch (InvalidActivityNameException ex) {
			throw ex;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (InvalidStateException ex) {
			throw ex;
		} catch (TransitionNotAllowedException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBԂ̕ύXɎs܂B
			String E0157 = StringManager.get("E0157");
			throw new TransitionNotAllowedException(E0157, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁A~sB
	 *
	 * @param filter ptB^[
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	void terminateProcesses(Filter filter)
	throws InvalidProcessDefinitionException, InvalidFilterException
	{
		try {
			Process[] procs = getProcesses(filter);
			
			for (int i = 0; i < procs.length; i++) {
				String pid = procs[i].getID();
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				process.terminate();
			}
		} catch (InvalidProcessDefinitionException ex) {
			throw ex;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̒~Ɏs܂B
			String E0136 = StringManager.get("E0136");
			throw new InvalidProcessDefinitionException(E0136, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁Å蓖ĂsB
	 *
	 * @param attr 
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	void assignProcessesAttribute(Filter filter, Attribute attr)
	throws InvalidFilterException, InvalidAttributeException
	{
		try {
			Process[] procs = getProcesses(filter);
			
			for (int i = 0; i < procs.length; i++) {
				String pid = procs[i].getID();
				VariableBean bean = new VariableBean();
				bean.setName(attr.getName());
				bean.setType(attr.getType());
				bean.setValue(attr.getValue());
				bean.setProcessID(pid);
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				process.setContext(bean);
			}
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (InvalidAttributeException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new InvalidAttributeException(E0080, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁A
	 * ̊蓖ĂsB
	 *
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	void assignActivitiesAttribute(String adid, Filter filter, Attribute attr)
	throws InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException
	{
		try {
			Activity[] acts = getActivities(adid, filter);
			
			for (int i = 0; i < acts.length; i++) {
				String pid = acts[i].getProcessID();
				String aid = acts[i].getActivityID();
				VariableBean bean = new VariableBean();
				bean.setName(attr.getName());
				bean.setType(attr.getType());
				bean.setValue(attr.getValue());
				bean.setProcessID(pid);
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				WfActivity activity = process.getStep(aid);
				if (activity == null) {
					// YANeBreB݂܂B
					String msg = StringManager.get("E0069");
					throw new InvalidActivityInstanceException(msg);
				}
				activity.setContext(bean);
			}
		} catch (InvalidActivityNameException ex) {
			throw ex;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (InvalidAttributeException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBw̃vZXϐ̐ݒɎs܂B
			String E0158 = StringManager.get("E0158");
			throw new InvalidAttributeException(E0158, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AfsB
	 *
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	void abortProcesses(Filter filter)
	throws InvalidFilterException
	{
		try {
			Process[] procs = getProcesses(filter);
			
			for (int i = 0; i < procs.length; i++) {
				String pid = procs[i].getID();
				ProcessInternal process = (ProcessInternal)getProcess(pid);
				process.abort();
			}
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̒~Ɏs܂B
			String E0137 = StringManager.get("E0137");
			throw new InvalidFilterException(E0137, ex);
		}
	}

	/**
	 * tB^[œ肳vZXԂB
	 *
	 * @param filter tB^[
	 * @return vZX
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	Process[] getProcesses(Filter filter)
	throws InvalidFilterException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			ProcessBean[] beans = procDAO.findByFilter(definitionID, filter);
			return beans;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̎擾Ɏs܂B
			String E0151 = StringManager.get("E0151");
			throw new InvalidFilterException(E0151, ex);
		}
	}

	/**
	 * tB^[œ肳ANeBreBԂB
	 *
	 * @param adid ANeBreB`ID
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	Activity[] getActivities(String adid, Filter filter)
	throws InvalidFilterException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();

			ActivityBean[] beans = actDAO.findByFilter(definitionID, adid, filter);
			return beans;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB̎擾Ɏs܂B
			String E0124 = StringManager.get("E0124");
			throw new InvalidFilterException(E0124, ex);
		}
	}
	
	/**
	 * VKvZX}B
	 *
	 * @param processDAO vZXDAO
	 * @param requester NGX^
	 * @param name vZX
	 * @param now 쐬
	 * @return vZX
	 * @throws Exception Cӂ̗O
	 */
	private ProcessBean insertProcess(ProcessDAO processDAO, WfRequester requester,
		String name, long now)
	throws Exception
	{
		Timestamp ts = DataAccessManager.getAccessTime();
		int du = processDefinition.getDurationUnit();
		int limit = processDefinition.getLimit();
		long durationLimit = now + DurationHelper.calculateDuration(du, limit);
		Timestamp limitTs = new Timestamp(durationLimit);
		String procName = name;
		if (procName == null) procName = "";
		
		ProcessBean processBean = new ProcessBean();
		processBean.setID(UniqueKeyGenerator.generate(ProcessBean.ID_PREFIX));
		processBean.setName(name);
		processBean.setPackageID(packageDefifinition.getID());
		processBean.setProcDefinitionID(definitionID);
		processBean.setProcessState(ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
		processBean.setStartDate(ts);
		processBean.setStarterID(requester.getReqesterResource().getID());
		processBean.setDurationLimit(limitTs);
		processBean.setUpdateDate(ts);

		processDAO.insert(processBean);
		
		return processBean;
	}
	
	/**
	 * VKvZXϐ}B
	 *
	 * @param variableDAO vZXϐDAO
	 * @param processBean vZX
	 * @param variableBean vZXϐ
	 * @param now 쐬
	 * @throws Exception Cӂ̗O
	 */
	private void insertVariable(VariableDAO variableDAO,
		ProcessBean processBean, VariableBean variableBean, long now)
	throws Exception
	{
		Timestamp ts = DataAccessManager.getAccessTime();

		variableBean.setID(UniqueKeyGenerator.generate(VariableBean.ID_PREFIX));
		variableBean.setProcessID(processBean.getID());
		variableBean.setUpdateDate(ts);

		variableDAO.insert(variableBean, null);
	}
}
