/* $Id: ProcessManagerFactory.java,v 1.18 2005/08/26 04:53:20 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.Process;

import org.apache.log4j.Logger;

/**
 * vZX}l[W̃t@NgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.18 $
 * @since   Nautica Workflow 0.9
 */
class ProcessManagerFactory
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ProcessManagerFactorỹVOg */
	static private ProcessManagerFactory singleton;

	/** vZXǗpnbVe[u */
	private Map processManagers = new Hashtable();
	
	/**
	 * ProcessManagerFactory̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		try {
			singleton = new ProcessManagerFactory();
			singleton.init();
		} catch (Exception ex) {
			// vZX}l[W̏Ɏs܂B
			String E0112 = StringManager.get("E0112");
			eLog.error(E0112);
			throw ex;
		}
	}

	/**
	 * ProcessManagerFactorỹCX^XԂB
	 *
	 * @return ProcessManagerFactory
	 */
	static ProcessManagerFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * ProcessManagerFactory𐶐B
	 */
	private ProcessManagerFactory()
	{
	}
	
	/**
	 * ProcessManagerFactoryB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
	}

	/**
	 * vZX}l[WԂB
	 *
	 * @return vZX}l[W
	 */
	public synchronized ProcessManager getProcessManager(String pdid)
	throws InvalidProcessDefinitionException
	{
		ProcessManager pm = (ProcessManager)processManagers.get(pdid);
		if (pm == null) {
			synchronized (processManagers) {
				pm = new ProcessManager(pdid);
				processManagers.put(pdid, pm);
			}
		}
		return pm;
	}

	/**
	 * w肳ꂽvZXǗvZX}l[WԂB
	 *
	 * @param pid
	 * @return vZX}l[W
	 * @throws InvalidProcessInstanceException
	 */
	public synchronized ProcessManager getOwnerProcessManager(String pid)
	throws InvalidProcessInstanceException
	{
		try {
			ProcessManager pm = null;
			Iterator it = processManagers.keySet().iterator();
			while (it.hasNext()) {
				pm = (ProcessManager)processManagers.get(it.next());
				if (pm.isMemberOfProcess(pid)) {
					return pm;
				}
			}
			
			pm = createOwnerProcessManager(pid);
			
			return pm;
		} catch (InvalidProcessInstanceException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX}l[W̎擾Ɏs܂B
			String E0163 = StringManager.get("E0163") + "(ProcessID = "+ pid + ")";
			throw new InvalidProcessInstanceException(E0163, ex);
		}
	}

	/**
	 * tB^[œ肳vZXԂB
	 *
	 * @param filter tB^[
	 * @return vZX
	 * @throws InvalidFilterException ȃtB^[̏ꍇ
	 */
	Process[] getProcesses(Filter filter)
	throws InvalidFilterException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			ProcessBean[] beans = procDAO.findByFilter(filter);
			return beans;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX̎擾Ɏs܂B
			String E0151 = StringManager.get("E0151");
			throw new InvalidFilterException(E0151, ex);
		}
	}

	/**
	 * tB^[œ肳ANeBreBԂB
	 *
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws InvalidFilterException ȃtB^[̏ꍇ
	 */
	Activity[] getActivities(Filter filter)
	throws InvalidFilterException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();

			ActivityBean[] beans = actDAO.findByFilter(filter);
			return beans;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB̎擾Ɏs܂B
			String E0124 = StringManager.get("E0124");
			throw new InvalidFilterException(E0124, ex);
		}
	}

	/**
	 * vZXID珊L҂ƂȂvZX}l[WAB
	 *
	 * @param pid vZXID
	 * @return vZX}l[W
	 * @throws InvalidProcessInstanceException vZX݂Ȃꍇ
	 */
	private ProcessManager createOwnerProcessManager(String pid)
	throws InvalidProcessInstanceException
	{
		try {
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ProcessDAO procDAO = daoFactory.getProcessDAO();

			ProcessBean bean = procDAO.findByPrimaryKey(pid);
			
			if (bean == null) {
				// vZX݂܂B
				String E0164 = StringManager.get("E0164") + "(ProcessID = " + pid + ")";
				throw new InvalidProcessInstanceException(E0164);
			}

			ProcessManager pm = new ProcessManager(bean.getProcDefinitionID());
			
			if (pm == null) {
				// vZX}l[W𐶐ł܂łB
				String E0165 = StringManager.get("E0165") + "(ProcessID = " + pid + ")";
				throw new InvalidProcessInstanceException(E0165);
			}
			synchronized (processManagers) {
				processManagers.put(bean.getProcDefinitionID(), pm);
			}
			return pm;
		} catch (InvalidProcessInstanceException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZX}l[W̐Ɏs܂B
			String E0149 = StringManager.get("E0149") + "(ProcessID = " + pid + ")";
			throw new InvalidProcessInstanceException(E0149, ex);
		}
	}
}
