/* $Id: RequesterManager.java,v 1.15 2005/08/26 04:53:22 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

import org.apache.log4j.Logger;

/**
 * vZXv(vZX̎s⌋ʎ擾sǗ)ǗNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class RequesterManager
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ProcessManagerFactorỹVOg */
	static private RequesterManager singleton;

	/** NGX^pnbVe[u */
	private Map requesters = new Hashtable();
	
	/**
	 * RequesterManager̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		try {
			singleton = new RequesterManager();
			singleton.init();
		} catch (Exception ex) {
			// NGX^}l[W̏Ɏs܂B
			String E0111 = StringManager.get("E0111");
			eLog.error(E0111);
			throw ex;
		}
	}

	/**
	 * RequesterManager̃CX^XԂB
	 *
	 * @return RequesterManager
	 */
	static RequesterManager getInstance()
	{
		return singleton;
	}
	
	/**
	 * RequesterManager𐶐B
	 */
	private RequesterManager()
	{
	}
	
	/**
	 * RequesterManagerB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
	}

	/**
	 * ZbVN[UɑΉvZX
	 * NGX^ԂB
	 *
	 * @param session ZbVID
	 * @return vZXNGX^
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public WfRequester getRequesterBySession(String session)
	throws InvalidSessionException
	{
		try {
			SessionManagerFactory smf = SessionManagerFactory.getInstance();
			SessionManager sm = smf.getSessionManager();
			User user = sm.getSessionUser(session);
			Participant part = ParticipantHelper.narrow(user);
			WfResource rsc = new ResourceInternal(part);
			return new GeneralRequester(rsc);
		} catch (Exception ex) {
			// NGX^̎擾Ɏs܂B
			String E0146 = StringManager.get("E0146") + "(SessionID = " + session + ")";
			throw new InvalidSessionException(E0146, ex);
		}
	}

	/**
	 * ZbVN[UɑΉvZX
	 * NGX^ԂB
	 *
	 * @param uid
	 * @return vZXNGX^
	 * @throws InvalidSessionException w肳ꂽ[UID̏ꍇ
	 */
	public WfRequester getRequesterByUserID(String uid)
	throws InvalidSessionException
	{
		try {
			ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
			UserManager um = rmf.getUserManager();
			User user = um.getUser(uid);
			Participant part = ParticipantHelper.narrow(user);
			WfResource rsc = new ResourceInternal(part);
			return new GeneralRequester(rsc);
		} catch (Exception ex) {
			// NGX^̎擾Ɏs܂B
			String E0146 = StringManager.get("E0146") + "(UserID = " + uid + ")";
			throw new InvalidSessionException(E0146, ex);
		}
	}
}
