/* $Id: ResourceInternal.java,v 1.12 2005/08/26 04:53:18 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.omg.NotAssignedException;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;

/**
 * GWł̃\[X\IuWFNgB
 * ́Aꕔ̋@\̂ݗpB
 * OMGWfResourceC^tF[XƂ̐̂߂ɒ񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class ResourceInternal implements WfResource
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** [Nt[Q */
	private Participant participant;

	/**
	 * GWł̃\[X𐶐B
	 *
	 * @param part [Nt[Q
	 */
	public ResourceInternal(Participant part)
	{
		this.participant = part;
	}

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#getID()
	 */
	public String getID() throws WorkflowException
	{
		return participant.getID();
	}

	/**
	 * ̂Ԃ
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#getName()
	 */
	public String getName() throws WorkflowException
	{
		return participant.getName();
	}

	/**
	 * \[XɊ֘AtꂽATCǧԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#getWorkItemCount()
	 */
	public int getWorkItemCount() throws WorkflowException
	{
		try {
			String name = participant.getID();
			int type = participant.getType();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();

			return workitemDAO.findCountByParticipant(name, type);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڐ̎擾Ɏs܂B
			String E0114 = StringManager.get("E0114");
			throw new WorkflowException(E0114, ex);
		}
	}

	/**
	 * IDŎw肳ꂽATCgԂB
	 *
	 * @param wid ID
	 * @return ATCg
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#getWorkItem(java.lang.String)
	 */
	public WfAssignment getWorkItem(String wid) throws WorkflowException
	{
		try {
			String name = participant.getID();
			int type = participant.getType();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();

			WorkItemBean bean = workitemDAO.findByPrimaryKey(wid);
			if (bean == null) {
				// ƍڂ݂܂B
				String E0115 = StringManager.get("E0115") + "(WorkItemID = " + wid + ")";
				throw new WorkflowException(E0115);
			}
			return new WorkItemInternal(bean);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̎擾Ɏs܂B
			String E0116 = StringManager.get("E0116") + "(WorkItemID = " + wid + ")";
			throw new WorkflowException(E0116, ex);
		}
	}

	/**
	 * \[XɊ֘AtꂽׂẴATCgԂB
	 *
	 * @return ATCg̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#getAllWorkItem()
	 */
	public WfAssignment[] getAllWorkItem() throws WorkflowException
	{
		try {
			String name = participant.getID();
			int type = participant.getType();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();

			WorkItemBean[] beans = workitemDAO.findByParticipant(name, type);
			WorkItemInternal[] workitems = new WorkItemInternal[beans.length];
			for (int i = 0; i < beans.length; i++) {
				workitems[i] = new WorkItemInternal(beans[i]);
			}
			return workitems;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// Sƍڂ̎擾Ɏs܂
			String E0117 = StringManager.get("E0117");
			throw new WorkflowException(E0117, ex);
		}
	}

	/**
	 * Ŏw肳ꂽATCgƁA֘AǂԂB
	 *
	 * @param ass ATCg
	 * @return ֘Aꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#isMemberOfWorkItems(jp.co.argo21.nautica.workflow.omg.WfAssignment)
	 */
	public boolean isMemberOfWorkItems(WfAssignment ass)
			throws WorkflowException
	{
		try {
			if (ass == null || ass instanceof WorkItem == false) {
				// ƍڂݒłB
				String E0118 = StringManager.get("E0118");
				throw new WorkflowException(E0118);
			}
			WfResource rsc = ass.getAssignee();
			if (rsc == null || rsc instanceof Participant == false) {
				// [Nt[Q҂ݒłB
				String E0119 = StringManager.get("E0119");
				throw new WorkflowException(E0119);
			}
			Participant part = (Participant)rsc;
			if (part.getType() == participant.getType()
					&& part.getID().equals(participant.getID())) {
				return true;
			} else {
				return false;
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̔Ɏs܂B
			String E0120 = StringManager.get("E0120");
			throw new WorkflowException(E0120, ex);
		}
	}

	/**
	 * Ɏw肵ATCgɂƂāA
	 * \[XsvɂȂƂʒm郊Xi[C^tF[XB
	 * ƂāA\[XɊ֘AtĂȂATCgƁA
	 * \[X闝RƂB
	 * ̃C^tF[X́AATCg폜ꂽꍇA
	 * ATCg̃\[X֍Ċ蓖Ăꂽꍇ
	 * IɌĂяo邱Ƃz肵ĂB
	 *
	 * @param ass ATCg
	 * @param info J闝R
	 * @throws NotAssignedException ATCg֘AĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfResource#release(jp.co.argo21.nautica.workflow.omg.WfAssignment, java.lang.String)
	 */
	public void release(WfAssignment ass, String info)
			throws NotAssignedException, WorkflowException
	{
		try {
			if (isMemberOfWorkItems(ass)) {
				WorkItemInternal workitem = (WorkItemInternal)ass;
				WorkItem bean = workitem.getWorkItem();

				WorkflowDAOFactory daoFactory
					= DataAccessManager.getDAOFactory();
				WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();

				workitemDAO.updateParticipant(bean.getID(), participant, null);
			} else {
				// ֘Aƍڂł͂܂B
				String E0121 = StringManager.get("E0121");
				throw new WorkflowException(E0121);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̉Ɏs܂B
			String E0122 = StringManager.get("E0122");
			throw new WorkflowException(E0122, ex);
		}
	}

	/**
	 * ێĂ郏[Nt[Q҂ԂB
	 *
	 * @return [Nt[Q
	 */
	Participant getParticipant()
	{
		return participant;
	}
}
