/* $Id: ResourceManagerFactory.java,v 1.6 2005/08/26 04:53:49 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * {[Nt[VXe^pՂgC^tF[XłB
 * ResourceManagerFactorýAeǗƂ肾߂̃t@Ng[NXłB
 * Cӂ̃\[XǗVXe𗘗p邽߂ɁÃNX𗘗pċ̎
 * 擾Ȃ΂ȂȂB
 * Ή郆[UǗAgDǗAǗꂼʎ̂ƂB
 * ͏Nautica.userManagerANautica.organizationManagerA
 * Nautica.roleManager̊evpeBŎw肳ꂽNXgpB
 * {[Nt[VXe^pՂł́AQl񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ResourceManagerFactory
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** ZLeBO */
	static private Logger sLog = LogManager.getSercurityLogger();
	
	/** ResourceManagerFactorỹVOg */
	static private ResourceManagerFactory singleton;

	/** [UǗ */
	private UserManager userManager;

	/** gDǗ */
	private OrganizationManager orgManager;

	/** Ǘ */
	private RoleManager roleManager;
	
	/**
	 * ResourceManagerFactory̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception {

		singleton = new ResourceManagerFactory();
		try {
			singleton.init();
		} catch (Exception ex) {
			eLog.error(StringManager.get("E1005"));
			throw ex;
		}
	}

	/**
	 * ResourceManagerFactorỹCX^XԂB
	 *
	 * @return ResourceManagerFactory
	 */
	static ResourceManagerFactory getInstance() {
		return singleton;
	}
	
	/**
	 * ResourceManagerFactory𐶐B
	 */
	private ResourceManagerFactory()
	{
	}
	
	/**
	 * ResourceManagerFactoryB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		String umcn = System.getProperty(WorkflowEngineConstants.NAUTICA_USER_MANAGER);
		if (umcn == null || umcn.trim().equals("")) {
			String E1002 = StringManager.get("E1002");
			sLog.error(E1002);
			throw new WorkflowException(E1002);
		}
		userManager = (UserManager)Class.forName(umcn).newInstance();
		String I1002 = StringManager.get("I1002");
		eLog.info(I1002);

		String omcn = System.getProperty(WorkflowEngineConstants.NAUTICA_ORG_MANAGER);
		if (omcn == null || omcn.trim().equals("")) {
			String E1003 = StringManager.get("E1003");
			sLog.error(E1003);
			throw new WorkflowException(E1003);
		}
		orgManager = (OrganizationManager)Class.forName(omcn).newInstance();
		String I1003 = StringManager.get("I1003");
		eLog.info(I1003);

		String rmcn = System.getProperty(WorkflowEngineConstants.NAUTICA_ROLE_MANAGER);
		if (rmcn == null || rmcn.trim().equals("")) {
			String E1004 = StringManager.get("E1004");
			sLog.error(E1004);
			throw new WorkflowException(E1004);
		}
		roleManager = (RoleManager)Class.forName(rmcn).newInstance();
		String I1004 = StringManager.get("I1004");
		eLog.info(I1004);
	}
	
	/**
	 * [UǗԂB
	 *
	 * @return [UǗ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	public UserManager getUserManager(String session)
	throws WorkflowSecurityException
	{
		return userManager;
	}

	/**
	 * gDǗԂB
	 *
	 * @return gDǗ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	public OrganizationManager getOrganizationManager(String session)
	throws WorkflowSecurityException
	{
		return orgManager;
	}

	/**
	 * ǗԂB
	 *
	 * @return Ǘ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	public RoleManager getRoleManager(String session)
	throws WorkflowSecurityException
	{
		return roleManager;
	}
	
	/**
	 * [UǗԂBX[p[oCU[pB
	 *
	 * @return [UǗ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	UserManager getUserManager()
	throws WorkflowSecurityException
	{
		return userManager;
	}

	/**
	 * gDǗԂBX[p[oCU[pB
	 *
	 * @return gDǗ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	OrganizationManager getOrganizationManager()
	throws WorkflowSecurityException
	{
		return orgManager;
	}

	/**
	 * ǗԂBX[p[oCU[pB
	 *
	 * @return Ǘ
	 * @throws WorkflowSecurityException ZLeBO
	 */
	RoleManager getRoleManager()
	throws WorkflowSecurityException
	{
		return roleManager;
	}
}
