/* $Id: SessionManagerFactory.java,v 1.7 2005/08/26 04:53:36 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ZbVǗ𐶐t@Ng[NXłB
 * Cӂ̃ZbVǗVXe𗘗p邽߂ɁA
 * ̃NX𗘗păZbV}l[W̋̎擾Ȃ΂ȂȂB
 * GWŎgpZbV}l[ẂA
 * vpeBNautica.sessionManagerɎw肳ꂽNXgpB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class SessionManagerFactory
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** ZLeBO */
	static private Logger sLog = LogManager.getSercurityLogger();
	
	/** SessionManagerFactorỹVOg */
	static private SessionManagerFactory singleton;

	/** ZbVǗ */
	private SessionManager sessionManager;
	
	/**
	 * SessionManagerFactory̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		singleton = new SessionManagerFactory();
		try {
			singleton.init();
		} catch (Exception ex) {
			eLog.error(StringManager.get("E1006"));
			throw ex;
		}
	}

	/**
	 * SessionManagerFactorỹCX^XԂB
	 *
	 * @return SessionManagerFactory
	 */
	static SessionManagerFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * SessionManagerFactory𐶐B
	 */
	private SessionManagerFactory()
	{
	}
	
	/**
	 * SessionManagerFactoryB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		String value = System.getProperty(WorkflowEngineConstants.NAUTICA_SESSION_MANAGER);
		if (value == null || value.trim().equals("")) {
			String E1001 = StringManager.get("E1001");
			sLog.error(E1001);
			throw new WorkflowException(E1001);
		}
		sessionManager = (SessionManager)Class.forName(value).newInstance();
		String I1001 = StringManager.get("I1001");
		eLog.info(I1001);
	}

	/**
	 * ZbV}l[WԂB
	 *
	 * @return ZbV}l[W
	 */
	public SessionManager getSessionManager()
	{
		return sessionManager;
	}
}
