/* $Id: StartActivityRequestWatcher.java,v 1.12 2005/08/26 04:53:37 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ANeBreBJnvL[ĎB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
class StartActivityRequestWatcher extends WorkflowMessageAdapter
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** bZ[WL[ */
	static public final String NAME = "START_ACTIVITY_REQUEST";
	
	/**
	 * ANeBreBJnvL[Ď𐶐B
	 */
	StartActivityRequestWatcher()
	{
	}

	/**
	 * ANeBreBJnvB
	 *
	 * @param message ANeBreBJnv
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
	 */
	public void onMessage(WorkflowMessage message)
	{
		if (message instanceof StartActivityRequestMessage == false) {
			//Oɏo͂Ė
			// sȃbZ[W`łB
			String E0099 = StringManager.get("E0099");
			eLog.error(E0099);
			return;
		}
		StartActivityRequestMessage msg = (StartActivityRequestMessage)message;
		String pid = msg.getProcessID();
		String aid = msg.getActivityID();

		ActivityInternal act = null;
		try {
			DataAccessManager.begin(false);
			
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			act = (ActivityInternal)proc.getStep(aid);
			
			act.start();

		} catch (Exception ex) {
			try {
				String E0102 = StringManager.get("E0102");
				eLog.error(E0102, ex);

				//ANeBreBُI݂B
				act.terminate(false);
			} catch (Exception ex2) {
				String F0102 = StringManager.get("F0102");
				eLog.fatal(F0102, ex);
			}
		} finally {
			try { DataAccessManager.commit(); } catch (Exception ex3) { /* Ignore */ }
		}
	}
}
