/* $Id: StartProcessRequestWatcher.java,v 1.14 2005/08/26 04:53:40 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * vZXJnvL[ĎB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
class StartProcessRequestWatcher extends WorkflowMessageAdapter
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	/** bZ[WL[ */
	static public final String NAME = "START_PROCESS_REQUEST";
	
	/**
	 * vZXJnvL[Ď𐶐B
	 */
	StartProcessRequestWatcher()
	{
	}

	/**
	 * vZXJnvB
	 *
	 * @param message vZXJnv
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
	 */
	public void onMessage(WorkflowMessage message)
	{
		if (message instanceof StartProcessRequestMessage == false) {
			//Oɏo͂Ė
			// sȃbZ[W`łB
			String E0099 = StringManager.get("E0099");
			eLog.error(E0099);
			return;
		}
		StartProcessRequestMessage msg = (StartProcessRequestMessage)message;
		String eid = msg.getEngineID();
		String pid = msg.getProcessID();

		try {
			DataAccessManager.begin(false);
			
			if (eid == null || eid.trim().equals("")) {
				ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
				ProcessManager pm = pmf.getOwnerProcessManager(pid);
				ProcessInternal process = (ProcessInternal)pm.getProcess(pid);

				synchronized (this) {
					process.start();
				}
			} else {
				//[g̃GWɃvZXJnvsB
				InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
				String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);

				synchronized (this) {
					//vZXJnv
					iwc.changeProcessState(session, pid, ProcessState.OPEN_RUNNING);
				}
				
				iwc.disconnect(session);
				
			}
		} catch (Exception ex) {
			try {
				String E0100 = StringManager.get("E0100");
				eLog.error(E0100, ex);

				//Ԃ񖳗AvZXُI݂B
				abortProcess(eid, pid);
			} catch (Exception ex2) {
				String F0101 = StringManager.get("F0101");
				eLog.fatal(F0101, ex);
			}
		} finally {
			try { DataAccessManager.commit(); } catch (Exception ex3) { /* Ignore */ }
		}
	}
	
	/**
	 * [J܂̓[g̃vZXُIsB
	 *
	 * @param eid GWID
	 * @param pid vZXID
	 * @throws Exception ̔Cӂ̗O
	 */
	private void abortProcess(String eid, String pid)
	throws Exception
	{
		if (eid == null || eid.trim().equals("")) {
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			
			proc.abort(true);

			//[gɃvZXʒmKvΒʒmB
			InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
			iwc.processStateChangedLocal(pid, ProcessState.CLOSED_ABORTED);
		} else {
			//[g̃GWɃvZXvsB
			InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
			String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);

			try {
				//vZXv
				iwc.changeProcessState(session, pid, ProcessState.CLOSED_ABORTED);
			} finally {
				iwc.disconnect(session);
			}
		}
	}
}
