/* $Id: SubprocessActivityBehavior.java,v 1.23 2005/08/26 04:53:09 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * TuvZXsANeBreB̏ԂƂ̓`NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.23 $
 * @since   Nautica Workflow 0.9
 */
public class SubprocessActivityBehavior
extends AbstractActivityBehavior
{
	/**
	 * TuvZXsANeBreB̏ԂƂ̓𐶐B
	 */
	public SubprocessActivityBehavior()
	{
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#abort(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void abort(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		String scope = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);
		if (scope == null) scope = "";
		scope = scope.trim();
		String engineName = ad.getEngineName();
		if (engineName == null
				|| engineName.trim().equals("")
				|| engineName.trim().equals(scope)) {
			terminateOrAbortOnLocalEngine(pd, ad, proc, act, ProcessState.CLOSED_ABORTED);
		} else {
			terminateOrAbortOnRemoteEngine(pd, ad, proc, act, ProcessState.CLOSED_ABORTED);
		}
		
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();

		//YANeBreB𒆒fB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
	}

	/**
	 * ŗL̊JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#start(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void start(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		try {
			String scope = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);
			if (scope == null) scope = "";
			scope = scope.trim();
			String engineName = ad.getEngineName();
			if (engineName == null
					|| engineName.trim().equals("")
					|| engineName.trim().equals(scope)) {
				startOnLocalEngine(pd, ad, proc, act);
			} else {
				startOnRemoteEngine(pd, ad, proc, act);
			}
		} catch (Exception ex) {
			// TuvZXANeBreB̊JnɎs܂B
			String E0160 = StringManager.get("E0160");
			eLog.fatal(E0160, ex);
			act.terminate();
		}
		
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#terminate(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void terminate(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		String pid = pbean.getID();
		ActivityBean abean = act.getBean();
		String aid = abean.getActivityID();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();

		if (checkChild) {
			String scope = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);
			if (scope == null) scope = "";
			scope = scope.trim();
			String engineName = ad.getEngineName();
			if (engineName == null
					|| engineName.trim().equals("")
					|| engineName.trim().equals(scope)) {
				terminateOrAbortOnLocalEngine(pd, ad, proc, act, ProcessState.CLOSED_TERMINATED);
			} else {
				terminateOrAbortOnRemoteEngine(pd, ad, proc, act, ProcessState.CLOSED_TERMINATED);
			}
		}
		
		VariableDAO varDAO = daoFactory.getVariableDAO();
		List vars = varDAO.findByProcessIDAsList(pid);
		List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
		
		Iterator it = trs.iterator();
		List acts = new ArrayList();
		while (it.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)it.next();
			ActivityDefinition dest = tr.getDestination();
			
			//JڐANeBreB̐
			ActivityBean ab = createActivity(pd, dest, pbean, bid);
			acts.add(ab);
		}
		
		if (acts.size() == 0) {
			//Jڐ悪ȂB`~X̉\B
			suspend(pd, ad, proc, act);
			String msg = StringManager.get("F0001");
			eLog.fatal(msg);
			return;
		}
		
		//YANeBreB𒆎~B
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);

		//JڐANeBreBbZ[WL[ɓo^B
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityBean ab = (ActivityBean)ait.next();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			String abid = ab.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, abid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);
		}
	}

	/**
	 * [JGW̃vZX̊JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	private void startOnLocalEngine(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();
		String spdid = ad.getSubprocessID();
		List sparams = ad.getSubprocessParameters();
		int exec = ad.getExecution();

		//YANeBreBJnB
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);

		//TuvZX`̐擾B
		String pdid = pbean.getProcDefinitionID();
		DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
		DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
		String path = defbean.getPath();
		DefinitionBean subdefbean = defDAO.findByPathAndID(path, spdid);
		String subdefname = subdefbean.getProcessDefinitionID();

		ProcessInternal sprocess = null;
		//TuvZX𐶐B
		Participant system = ParticipantImpl.getSystemParticipant();
		RequesterManager rqm = RequesterManager.getInstance();
		WfRequester requester = rqm.getRequesterByUserID(system.getID());
		ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
		ProcessManager pm = pmf.getProcessManager(subdefname);
		sprocess = (ProcessInternal)pm.createProcess(requester, system.getName());
		ProcessBean spb = sprocess.getBean();
		String spid =spb.getID();

		//p[^̍쐬
		Iterator spit = sparams.iterator();
		for (int i = 0; spit.hasNext(); i++) {
			String varID = (String)spit.next();
			VariableDAO varDAO = daoFactory.getVariableDAO();
			VariableBean svbean = varDAO.findByDefinitionID(pid, varID);
			VariableBean dvbean = varDAO.findByDefinitionID(spid, varID);
			String val = svbean.getValue();
			varDAO.update(dvbean, val, aid, DataAccessManager.getAccessTime());
		}

		if (exec == ActivityDefinition.SYNCHR) {
			//̏ꍇA҂e[uɓo^s
			ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
			
			ProcessWaitActivityBean pwbean = new ProcessWaitActivityBean();
			pwbean.setProcID(pid);
			pwbean.setActID(aid);
			pwbean.setSubprocID(spid);
			pwDAO.insert(pwbean);
		}

		//vZXJnv
		WorkflowMessage msg = new StartProcessRequestMessage(spb.getID());
		WorkflowEngine engine = WorkflowEngine.getInstance();
		SystemMessageTransporter mt = new SystemMessageTransporter(StartProcessRequestWatcher.NAME);
		mt.sendMessage(msg);

		if (exec == ActivityDefinition.ASYNCHR) {
			//񓯊̎Aʂ҂Ȃ̂ŃANeBreB
			//̏ꍇ͉Ԃŝ܂܂ɂ
			act.complete();
		}
	}

	/**
	 * [gGW̃vZX̊JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	private void startOnRemoteEngine(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		String engineName = ad.getEngineName();
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();
		String spdid = ad.getSubprocessID();
		List sparams = ad.getSubprocessParameters();
		int exec = ad.getExecution();

		//YANeBreBJnB
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);

		//TuvZX`̐擾B
		String pdid = pbean.getProcDefinitionID();
		DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
		DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
		String path = defbean.getPath();
		DefinitionBean subdefbean = defDAO.findByPathAndID(path, spdid);
		String subdefname = subdefbean.getProcessDefinitionID();

		//[g̃GWɃvZXvsB
		InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
		String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);

		int flag = InterWorkflowConnector.NOT_NEED_RESULT;
		if (exec == ActivityDefinition.SYNCHR) {
			flag = InterWorkflowConnector.NEED_RESULT;
		}
		String userid = ParticipantImpl.SYSTEM_ID;
		String roleid = SystemRoleImpl.REMOTE_ENGINE_ROLE_ID;
		String spid = iwc.createProcess(eid, subdefname, flag, pid, aid, userid, roleid);

		//p[^̍쐬Ɛݒ
		Attribute[] attrs = new Attribute[sparams.size()];
		Iterator spit = sparams.iterator();
		for (int i = 0; spit.hasNext(); i++) {
			String varID = (String)spit.next();
			VariableDAO varDAO = daoFactory.getVariableDAO();
			VariableBean vbean = varDAO.findByDefinitionID(pid, varID);
			attrs[i] = vbean;
		}
		iwc.setProcessAttributes(eid, pid, aid, spid, attrs);

		if (flag == InterWorkflowConnector.NEED_RESULT) {
			//̏ꍇA҂e[uɓo^s
			TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
			
			TargetProcessBean tpbean = new TargetProcessBean();
			tpbean.setEngineID(engineName);
			tpbean.setRootProcID(pid);
			tpbean.setRootActID(aid);
			tpbean.setProcessID(spid);
			tpDAO.insert(tpbean);
		}

		iwc.disconnect(eid);

		//vZXJnv
		WorkflowMessage msg = new StartProcessRequestMessage(engineName, spid);
		WorkflowEngine engine = WorkflowEngine.getInstance();
		SystemMessageTransporter mt = new SystemMessageTransporter(StartProcessRequestWatcher.NAME);
		mt.sendMessage(msg);
		
		if (flag == InterWorkflowConnector.NOT_NEED_RESULT) {
			//񓯊̎Aʂ҂Ȃ̂ŃANeBreB
			//̏ꍇ͉Ԃŝ܂܂ɂ
			act.complete();
		}
	}

	/**
	 * [JGW̃vZX̒~܂͒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @param state vZX
	 * @throws Exception Cӂ̗O
	 */
	private void terminateOrAbortOnLocalEngine(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, ProcessState state)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
		ProcessWaitActivityBean pwabean = pwDAO.findByProcIDANDActID(pid, aid);
		
		if (pwabean != null) {
			//bZ[WL[ɃvZXvo^
			String spid = pwabean.getSubprocID();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			WorkflowMessage eprmsg = new EndProcessRequestMessage(spid, ActivityState.CLOSED_ABORTED);
			SystemMessageTransporter mt = new SystemMessageTransporter(EndProcessRequestWatcher.NAME);
			mt.sendMessage(eprmsg);
		}
	}

	/**
	 * [gGW̃vZX̒~܂͒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @param state vZX
	 * @throws Exception Cӂ̗O
	 */
	private void terminateOrAbortOnRemoteEngine(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, ProcessState state)
	throws Exception
	{
		String engineName = ad.getEngineName();
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
		TargetProcessBean tpbean = tpDAO.findByRootID(pid, aid);
		
		if (tpbean != null) {
			//bZ[WL[ɃvZXvo^
			String spid = tpbean.getProcessID();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			ActivityState astate = StateHelper.convert(state);
			WorkflowMessage eprmsg = new EndProcessRequestMessage(engineName, spid, astate);
			SystemMessageTransporter mt = new SystemMessageTransporter(EndProcessRequestWatcher.NAME);
			mt.sendMessage(eprmsg);

		}
	}
}
