/* $Id: SystemChecker.java,v 1.7 2005/08/26 04:53:27 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * ÑVXe`FbNsB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
class SystemChecker
{
	/** ݒt@C */
	static private final String PROP_NAME = "nautica.properties";
	
	/**
	 * VXeNpXƍ\`FbNB
	 *
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static void checkBootPath()
	throws WorkflowException
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		
		checkHome(home);
		checkDir(home, "lib", "Library path");
		checkDir(home, "config", "Configuration path");
		checkDir(home, "repository", "Repository path");
		checkDir(home, "logs", "Logging path");
		checkDir(home, "temp", "Temporary path");
		checkConfig(home);
		checkProperties();
	}

	/**
	 * Ǘ҃L[`FbNB
	 *
	 * @param adminkey Ǘ҃L[
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static void checkAdmin(String adminkey)
	throws WorkflowException
	{
		//adminkey̔
		String admin = System.getProperty(WorkflowEngineConstants.NAUTICA_ADMIN);
		if (adminkey == null) {
			throw new WorkflowException("Administrator key is not set.");
		}
		if (adminkey.equals(admin) == false) {
			throw new WorkflowException("Administrator key is not valid.");
		}
	}

	/**
	 * {vpeB`FbNB
	 *
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static void checkProperties()
	throws WorkflowException
	{
		checkProperty(WorkflowEngineConstants.NAUTICA_ADMIN);
		checkProperty("java.home");
	}

	/**
	 * [Nt[GWz[`FbNB
	 *
	 * @param home [Nt[GWz[
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static private void checkHome(String home)
	throws WorkflowException
	{
		if (home == null || home.trim().equals("")) {
			throw new WorkflowException(WorkflowEngineConstants.NAUTICA_HOME
					+ " is not set.");
		}
		File dir = new File(home);
		if (! dir.exists()) {
			throw new WorkflowException(WorkflowEngineConstants.NAUTICA_HOME
					+ " is invalid path.: " + home);
		}
		if (! dir.isDirectory()) {
			throw new WorkflowException(WorkflowEngineConstants.NAUTICA_HOME
					+ " is not directory.: " + home);
		}
	}

	/**
	 * TufBNg`FbNB
	 *
	 * @param home [Nt[GWz[
	 * @param name fBNg
	 * @param label x
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static private void checkDir(String home, String name, String label)
	throws WorkflowException
	{
		String separator = System.getProperty("file.separator");
		String dirPath = home + separator + name;

		File dir = new File(dirPath);
		if (! dir.exists()) {
			throw new WorkflowException(label + " is not found.");
		}
		if (! dir.isDirectory()) {
			throw new WorkflowException(label + " is not directory.");
		}
	}

	/**
	 * ݒt@C`FbNB
	 *
	 * @param home [Nt[GWz[
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static private void checkConfig(String home)
	throws WorkflowException
	{
		String separator = System.getProperty("file.separator");
		String confDirPath = home + separator + "config";
		String propFilePath = confDirPath + separator + PROP_NAME;
		File propFile = new File(propFilePath);
		if (! propFile.exists()) {
			throw new WorkflowException(PROP_NAME + " is not found.");
		}
		if (! propFile.isFile()) {
			throw new WorkflowException(PROP_NAME + " is not file.");
		}
		try {
			InputStream is = new FileInputStream(propFile);
			Properties prop = new Properties();
			prop.load(is);
			is.close();
			Properties sysprop = System.getProperties();
			sysprop.putAll(prop);
		} catch (IOException ex) {
			throw new WorkflowException(PROP_NAME + " cannot loaded.", ex);
		}
	}

	/**
	 * vpeBl`FbNB
	 *
	 * @param name vpeB
	 * @throws WorkflowException `FbNᔽꍇ
	 */
	static private void checkProperty(String name)
	throws WorkflowException
	{
		String value = System.getProperty(name);
		if (value == null || value.trim().equals("")) {
			throw new WorkflowException(value + "property is not set.");
		}
	}
}
