/* $Id: SystemMessageTransporter.java,v 1.4 2005/08/26 04:53:43 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;

import org.apache.log4j.Logger;

/**
 * GWp̃bZ[WzIuWFNgB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class SystemMessageTransporter
{
	/** Xbh[JȒxbZ[Wi[Ǘ */
	static private final ThreadLocal manager = new ThreadLocal();

	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** L[ */
	private String queueName;
	
	/**
	 * XbhœꂽbZ[W܂Ƃ߂ĔzB
	 *
	 * @throws MessagingException MɗOꍇ
	 */
	static synchronized void execute()
	throws MessagingException
	{
		Map holders = (Map)manager.get();
		if (holders == null) return;

		MessageBroker broker = MessageBroker.getInstance();

		Set keys = holders.keySet();
		Iterator keyit = keys.iterator();
		
		while (keyit.hasNext()) {
			String key = (String)keyit.next();
			WorkflowMQ mq = broker.getWorkflowMQ(key);
			List holder = (List)holders.get(key);
			Iterator it = holder.iterator();
			while (it.hasNext()) {
				WorkflowMessage msg = (WorkflowMessage)it.next();
				mq.send(msg);
			}
			holder.clear();
		}
	}
	
	/**
	 * w肳ꂽL[ɑ΂郁bZ[Wz@\𐶐B
	 *
	 * @param queueName L[
	 */
	SystemMessageTransporter(String queueName)
	{
		this.queueName = queueName;
		Map holders = (Map)manager.get();
		if (holders == null) {
			holders = new Hashtable();
			manager.set(holders);
		}
		if (holders.containsKey(queueName) == false) {
			List holder = new ArrayList();
			holders.put(queueName, holder);
		}
	}
	
	/**
	 * bZ[WL[ɃbZ[W𑗂B
	 * ۂɂ͂܂MꂸAL[Ɋi[B
	 *
	 * @param msg bZ[W
	 * @throws MessagingException MɗOꍇ
	 */
	synchronized void sendMessage(WorkflowMessage msg)
	throws MessagingException
	{
		Map holders = (Map)manager.get();
		List holder = (List)holders.get(queueName);
		holder.add(msg);
	}
}
