/* $Id: SystemRoleImpl.java,v 1.6 2005/08/26 04:53:11 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SystemRole;

/**
 * VXeNXłB
 * ̌݊̂߂ɗpӂĂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class SystemRoleImpl implements SystemRole
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** [gGWID */
	public static final String REMOTE_ENGINE_ROLE_ID = "REMOTE_ENGINE";
	/** c[G[WFgID */
	public static final String TOOL_AGENT_ROLE_ID    = "TOOL_AGENT";

	/** [gGW */
	public static final String REMOTE_ENGINE_ROLE_NAME = "REMOTE ENGINE";
	/** c[G[WFg */
	public static final String TOOL_AGENT_ROLE_NAME    = "TOOL AGENT";

	/** [gGW */
	public static final SystemRole REMOTE_ENGINE_ROLE =
		new SystemRoleImpl(REMOTE_ENGINE_ROLE_ID, REMOTE_ENGINE_ROLE_NAME);

	/** c[G[WFg */
	public static final SystemRole TOOL_AGENT_ROLE =
		new SystemRoleImpl(TOOL_AGENT_ROLE_ID, TOOL_AGENT_ROLE_NAME);

	/** ID */
	private String id;
	/**  */
	private String name;
	/**  */
	private Map attrs = new Hashtable();
	
	/**
	 * VXe𐶐B
	 *
	 * @param id ID
	 * @param name 
	 */
	private SystemRoleImpl(String id, String name)
	{
		this.id = id;
		this.name = name;
	}

	/**
	 * ێ邷ׂĂ̌ԂB
	 *
	 * @return ̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Role#getAllAttributeNames()
	 */
	public String[] getAllAttributeNames() throws WorkflowException
	{
		Set keys = attrs.keySet();
		return (String[])keys.toArray(new String[keys.size()]);
	}

	/**
	 * ێ錠ԂB
	 *
	 * @param name 
	 * @return l
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Role#getAttribute(java.lang.String)
	 */
	public String getAttribute(String name) throws WorkflowException
	{
		return (String)attrs.get(name);
	}

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Role#getID()
	 */
	public String getID() throws WorkflowException
	{
		return id;
	}

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Role#getName()
	 */
	public String getName() throws WorkflowException
	{
		return name;
	}

	/**
	 * QҌ^ԂB
	 * 
	 * @return	QҌ^
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getType() throws WorkflowException
	{
		return SYSTEM;
	}

	/**
	 * ݒ肷B
	 *
	 * @param name 
	 * @param value l
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Role#setAttribute(java.lang.String, java.lang.String)
	 */
	public void setAttribute(String name, String value)
			throws WorkflowException
	{
		//NOP
	}
}
