/* $Id: ToolAgentManager.java,v 1.9 2005/08/26 04:53:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.nautica.workflow.ta.config.Agent;
import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.ToolAgentsDocument;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidApplicationException;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/**
 * o^Ăc[G[WFgǗB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class ToolAgentManager
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ToolAgentManager̃VOg */
	static private ToolAgentManager singleton;

	/** ݒt@C */
	static private final String CONFIG = "toolagent.xml";
	
	/** AvP[V */
	private Map applications = new Hashtable();
	
	
	/**
	 * ToolAgentManager̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		singleton = new ToolAgentManager();
		try {
			singleton.init();
		} catch (Exception ex) {
			eLog.error(StringManager.get("E1005"));
			throw ex;
		}
	}

	/**
	 * ToolAgentManager̃CX^XԂB
	 *
	 * @return ToolAgentManager
	 */
	static ToolAgentManager getInstance()
	{
		return singleton;
	}
	
	/**
	 * ToolAgentManager𐶐B
	 */
	private ToolAgentManager()
	{
	}
	
	/**
	 * ResourceManagerFactoryB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		String path = home
		            + separator + "config"
		            + separator + CONFIG;
		File confFile = new File(path);
		InputStream in = new FileInputStream(confFile);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");

		ToolAgentsDocument doc = ToolAgentsDocument.Factory.parse(in, opts);
		in.close();
		
		load(doc);
	}
	
	/**
	 * w肳ꂽ_AvP[VɑΉc[G[WFgԂB
	 *
	 * @param appName _AvP[V
	 * @return c[G[WFg
	 * @throws InvalidApplicationException _AvP[VȂꍇ
	 */
	ToolAgent getToolAgent(String appName)
	throws InvalidApplicationException
	{
		if (appName == null) {
			// _AvP[Vݒ肳Ă܂B
			String E0147 = StringManager.get("E0147");
			eLog.fatal(E0147);
			throw new InvalidApplicationException(E0147);
		}
		ToolAgentFactory factory = (ToolAgentFactory)applications.get(appName);
		if (factory == null) {
			// Ήc[G[WFg̃t@Ng擾ł܂B
			String E0148 = StringManager.get("E0148") + "(ApplicationName = " + appName + ")";
			eLog.fatal(E0148);
			throw new InvalidApplicationException(E0148);
		}
		return factory.getToolAgent();
	}

	/**
	 * c[G[WFg`hLg[hB
	 * 
	 * @param doc XPDLhLg
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	private void load(ToolAgentsDocument doc)
	throws Exception
	{
		ToolAgentsDocument.ToolAgents config = doc.getToolAgents();
		
		Agent[] agents = config.getAgentArray();
		for (int i = 0; i < agents.length; i++) {
			String cn = agents[i].getClassname();
			int retry = 1;
			if (agents[i].isSetRetry()) retry = agents[i].getRetry().intValue();
			ToolAgentFactory factory = (ToolAgentFactory)Class.forName(cn).newInstance();
			factory.setRetryCount(retry);
			
			App[] apps = agents[i].getAppArray();
			for (int j = 0; j < apps.length; j++) {
				applications.put(apps[j].getName(), factory);
			}
		}
	}
}
