/* $Id: WorkItemContainer.java,v 1.23 2005/08/26 04:53:17 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.WorkItemFilterConverter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * ƍڃv[ɂč쐬AZbVɑΉ[Up
 * ꎞIƍڃRei
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.23 $
 * @since   Nautica Workflow 0.9
 */
public class WorkItemContainer
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ftHg̗Lԁi1T) */
	static private long DEFAULT_VALID_TERM = 604800000L;

	/** Rei̗L */
	private long validTerm = DEFAULT_VALID_TERM;
	/** [Nt[Q */
	private Participant userResource;
	/** gD\[X */
	private List orgResources;
	/** \[X */
	private List roleResources;
	/** 쐬 */
	private long createTimeMillis;
	/** ؂ꂩǂ */
	private boolean isExpired;
	
	/**
	 * ZbVp̃Rei𐶐B
	 *
	 * @param user [U
	 * @param orgs gD
	 * @param roles 
	 */
	WorkItemContainer(Participant user, List orgs, List roles)
	{
		this(user, orgs, roles, DEFAULT_VALID_TERM);
	}
	
	/**
	 * ZbVp̃Rei𐶐B
	 *
	 * @param user [U
	 * @param orgs gD
	 * @param roles 
	 * @param validTerm L 
	 */
	WorkItemContainer(Participant user, List orgs, List roles, long validTerm)
	{
		this.userResource = user;
		this.orgResources = orgs;
		this.roleResources = roles;
		this.createTimeMillis = System.currentTimeMillis();
		this.validTerm = validTerm;
	}
	
	/**
	 * ReiǂԂB
	 *
	 * @return Ȃtrue
	 */
	boolean isExpired()
	{
		long now = System.currentTimeMillis();
		if (now - createTimeMillis > validTerm) {
			isExpired = true;
		}
		return isExpired;
	}
	
	/**
	 * Rei𖳌ɂB
	 */
	void expire()
	{
		isExpired = true;
	}

	/**
	 * ƍڈꗗ̎擾sB
	 *
	 * @param filter ptB^[
	 * @return ƍڈꗗ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	WorkItem[] getWorkItems(Filter filter)
	throws InvalidFilterException
	{
		try {
			WorkItemPool pool = WorkItemPool.getInstance();
			
			WorkItemFilterConverter conv = new WorkItemFilterConverter();
			String filterPart = conv.convertToSQL(filter);
			String participantPart = getParticipantSQLPart();
			StringBuffer sqlPart = new StringBuffer();
			boolean filterExist = (! filterPart.equals(""));
			boolean hasAttrFilter = conv.hasAttributeFilter();

			sqlPart.append(" where ").append(participantPart);
			if (filterExist) {
				if (hasAttrFilter) {
					sqlPart.append(" and ").append(filterPart)
					.append(" and (w.PROC_ID = v.PROC_ID)");
				} else {
					sqlPart.append(" and ").append(filterPart);
				}
			}

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();

			WorkItem[] items = workItemDAO.findBySQLPart(sqlPart.toString(), hasAttrFilter);
			
			return items;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڈꗗ̎擾Ɏs܂B
			String E0174 = StringManager.get("E0174");
			throw new InvalidFilterException(E0174, ex);
		}
	}

	/**
	 * ƍڂ̎擾sB
	 * APIĂяoŁAYƍڂZbVɂăbNB
	 *
	 * @param wid ƍID
	 * @return ƍ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 */
	WorkItem getWorkItem(String wid) throws InvalidWorkItemException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);

			return workItem;
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̎擾Ɏs܂B
			String E0116 = StringManager.get("E0116");
			throw new InvalidWorkItemException(E0116, ex);
		}
	}

	/**
	 * ƍڂ̊sB
	 * APIĂяoŁAYƍڂZbVɂăAbNB
	 *
	 * @param wid ƍID
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 */
	void completeWorkItem(String wid) throws InvalidWorkItemException
	{
		try {
			long now = System.currentTimeMillis();
			Timestamp ts = new Timestamp(now);
			
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			//sԂǂ𔻒
			checkUsing(wid);
			
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();

			//ANeBreB̊
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			activity.changeState(ActivityState.CLOSED_COMPLETED);
			
			//svɂȂƍڂ폜
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
			try {
				workItemDAO.delete(wid);
			} catch (DAOException ex) {
				//NOP
			}
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̊Ɏs܂B
			String E0175 = StringManager.get("E0175");
			throw new InvalidWorkItemException(E0175, ex);
		}
	}

	/**
	 * ݂̍ƍڂJډ\ȏԂ̈ꗗԂB
	 * ԂȂꍇ́A̔zԂB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 * API͊gꂽԂ߂̂̂łA
	 * ʏcompletesuspendԂB
	 *
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڏԈꗗ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	WorkItemState[] getWorkItemStates(String wid, Filter filter)
	throws InvalidWorkItemException, InvalidFilterException
	{
		WorkItemState state = null;
		try {
			//StateFilter݂̂ΏۂƂB
			if (filter != null) {
				if (filter instanceof StateFilter) {
					WfState st = ((StateFilter)filter).getState();
					if (st instanceof WorkItemState) {
						state = (WorkItemState)st;
					} else {
						// ƍڏԂł͂܂B
						String E0183 = StringManager.get("E0183");
						throw new InvalidFilterException(E0183);
					}
				} else {
					// ԃtB^[ȊO͎gpł܂B
					String E0184 = StringManager.get("E0184");
					throw new InvalidFilterException(E0184);
				}
			}

			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();
			
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			Activity act = activity.getBean();
			ActivityState astate = ActivityState.getState(act.getActivityState());
			WorkItemState wstate = StateHelper.convert(astate);

			WorkItemState[] ret = null;
			if (filter == null || state == null) {
				ret = WorkItemState.getTransitableStates(wstate.toInt());
			} else {
				//tB^O
				if (StateHelper.containsTransitable(wstate, state)) {
					ret = new WorkItemState[1];
					ret[0] = state;
				} else {
					ret = new WorkItemState[0];
				}
			}
			return ret;
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڏԂ̎擾Ɏs܂B
			String E0176 = StringManager.get("E0176");
			throw new InvalidWorkItemException(E0176, ex);
		}
	}
	
	/**
	 * ƍڏԂ̕ύXsB
	 * A{[Nt[VXe^pՂł́ANCAg
	 * ύX\ȏԂCLOSED_COMPLETED݂̂łB
	 *
	 * @param wid ƍID
	 * @param state ƍڏ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	void changeWorkItemState(String session, String wid, WorkItemState state)
	throws InvalidSessionException, InvalidWorkItemException, InvalidStateException,
		TransitionNotAllowedException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			
			ActivityState astate = StateHelper.convert(state);
			long now = System.currentTimeMillis();
			Timestamp ts = new Timestamp(now);
			
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();

			//ANeBreB̏ԕύX
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			activity.changeState(astate);
			
			//ԂꍇAsvɂȂƍڂ폜
			if (state.equals(WorkItemState.CLOSED_COMPLETED)
				|| state.equals(WorkItemState.CLOSED_ABORTED)
				|| state.equals(WorkItemState.CLOSED_TERMINATED)) {
				WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
				WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
				try {
					workItemDAO.delete(wid);
				} catch (DAOException ex) {
					//NOP
				}
			}
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidStateException ex) {
			throw ex;
		} catch (TransitionNotAllowedException ex) {
			throw ex;
		} catch (jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException ex) {
			throw new TransitionNotAllowedException(ex.getMessage(), ex);
		} catch (jp.co.argo21.nautica.workflow.omg.InvalidStateException ex) {
			throw new InvalidStateException(ex.getMessage(), ex);
		} catch (Exception ex) {
			// ƍڏԂ̕ύXɎs܂B
			String E0177 = StringManager.get("E0177");
			throw new InvalidWorkItemException(E0177, ex);
		}
	}
	
	/**
	 * ƍڂ̍Ċ蓖ĂsB
	 *
	 * @param wid ƍID
	 * @param sourceUser 蓖đÕ[U
	 * @param targetUser 蓖Č̃[U
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidSourceUserException 蓖đO[ULłȂꍇ
	 * @throws InvalidTargetUserException 蓖Đ惆[ULłȂꍇ
	 */
	void reassignWorkItem(String wid, Participant sourceUser, Participant targetUser)
	throws InvalidWorkItemException, InvalidSourceUserException, InvalidTargetUserException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			//sԂǂ𔻒
			checkUsing(wid);
			
			//[U̗L̃`FbN
			ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
			String tpid = targetUser.getID();
			int ptype = targetUser.getType();
			if (ptype == Participant.HUMAN) {
				UserManager um = rmf.getUserManager();
				User tuser = um.getUser(tpid);
				if (tuser == null) {
					// [U݂܂B
					String E0185 = StringManager.get("E0185");
					throw new InvalidTargetUserException(E0185);
				}
			} else if (ptype == Participant.ORGANIZATIONAL_UNIT) {
				OrganizationManager om = rmf.getOrganizationManager();
				Organization torg = om.getOrganization(tpid);
				if (torg == null) {
					// gD݂܂B
					String E0227 = StringManager.get("E0227");
					throw new InvalidTargetUserException(E0227);
				}
			} else if (ptype == Participant.ROLE) {
				RoleManager rm = rmf.getRoleManager();
				Role trole = rm.getRole(tpid);
				if (trole == null) {
					// [݂܂B
					String E0228 = StringManager.get("E0228");
					throw new InvalidTargetUserException(E0228);
				}
			} else {
				String E0229 = StringManager.get("E0229");
				throw new InvalidTargetUserException(E0229);
			}
			
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();

			workItemDAO.updateParticipant(wid, sourceUser, targetUser);
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidTargetUserException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڂ̊蓖ĂɎs܂B
			String E0178 = StringManager.get("E0178");
			throw new InvalidWorkItemException(E0178, ex);
		}
	}
	
	/**
	 * ƍڑꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڑꗗ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	Attribute[] getWorkItemAttributes(String session, String wid, Filter filter)
	throws InvalidSessionException, InvalidWorkItemException, InvalidFilterException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			//sԂǂ𔻒
			checkUsing(wid);
			
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();
			
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			Attribute[] ret = (Attribute[])activity.getContext(filter);
			return ret;
		} catch (InvalidSessionException ex) {
			throw ex;
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidFilterException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڑ̎擾Ɏs܂B
			String E0179 = StringManager.get("E0179");
			throw new InvalidWorkItemException(E0179, ex);
		}
	}
	
	/**
	 * ƍڑ̎擾sB
	 *
	 * @param wid ƍID
	 * @param name 
	 * @return 
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	Attribute getWorkItemAttributeValue(String wid, String name)
	throws InvalidWorkItemException, InvalidAttributeException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			//sԂǂ𔻒
			checkUsing(wid);
			
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();
			
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			Attribute attr = (Attribute)activity.getContext(name);
			
			return attr;
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidAttributeException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڑ̎擾Ɏs܂B
			String E0179 = StringManager.get("E0179");
			throw new InvalidWorkItemException(E0179, ex);
		}
	}

	/**
	 * ƍڑ̊蓖ĂsB
	 *
	 * @param wid ƍID
	 * @param attr 
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 */
	void assignWorkItemAttribute(String session, String wid, Attribute attr)
	throws InvalidSessionException, InvalidWorkItemException, InvalidAttributeException,
		AttributeAssignmentFailedException
	{
		try {
			//ƍڂɑ΂ANZX̌
			WorkItem workItem = checkWorkItem(wid);
			//sԂǂ𔻒
			checkUsing(wid);

			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();

			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
			ActivityInternal activity = (ActivityInternal)process.getStep(aid);
			activity.setContext(attr);
		} catch (InvalidSessionException ex) {
			throw ex;
		} catch (InvalidWorkItemException ex) {
			throw ex;
		} catch (InvalidAttributeException ex) {
			throw ex;
		} catch (AttributeAssignmentFailedException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڑ̊蓖ĂɎs܂B
			String E0180 = StringManager.get("E0180");
			throw new InvalidWorkItemException(E0180, ex);
		}
	}
	
	/**
	 * [Nt[Q҂ɑΉSQL𐶐B
	 *
	 * @return SQL
	 * @throws WorkflowException Cӂ̗O
	 */
	private String getParticipantSQLPart() throws WorkflowException
	{
		StringBuffer sb = new StringBuffer();
		sb.append("((w.PARTICIPANT_TYPE = ").append(Participant.HUMAN)
			.append(" and w.PARTICIPANT_NAME = '").append(userResource.getID()).append("')");

		if (orgResources != null && orgResources.size() > 0) {
			sb.append("or (w.PARTICIPANT_TYPE = ").append(Participant.ORGANIZATIONAL_UNIT);
			Iterator it = orgResources.iterator();
			Participant p = (Participant)it.next();
			sb.append(" and (w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
			while (it.hasNext()) {
				p = (Participant)it.next();
				sb.append("or w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
			}
			sb.append("))");
		}

		if (roleResources != null && roleResources.size() > 0) {
			sb.append("or (w.PARTICIPANT_TYPE = ").append(Participant.ROLE);
			Iterator it = roleResources.iterator();
			Participant p = (Participant)it.next();
			sb.append(" and (w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
			while (it.hasNext()) {
				p = (Participant)it.next();
				sb.append("or w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
			}
			sb.append("))");
		}
		sb.append(")");
		
		return sb.toString();
	}

	/**
	 * Ήƍڂ̃`FbNsAԂB
	 *
	 * @param wid ƍID
	 * @return@ƍ
	 * @throws Exception Cӂ̗O
	 */
	private WorkItem checkWorkItem(String wid)
	throws Exception
	{
		String participantPart = getParticipantSQLPart();

		StringBuffer sqlPart
			= new StringBuffer().append(" where w.WORK_ID = '")
				.append(wid).append("' and ").append(participantPart);

		WorkflowDAOFactory daoFactory
			= DataAccessManager.getDAOFactory();
		WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();

		WorkItem[] items = workItemDAO.findBySQLPart(sqlPart.toString(), false);
		
		if (items.length != 1) {
			// ƍڂł܂B
			String E0181 = StringManager.get("E0181");
			throw new InvalidWorkItemException(E0181);
		}
		return items[0];
	}
	
	/**
	 * ƍڂp\ȏԂǂ𔻒肷B
	 *
	 * @param wid ƍID
	 * @throws InvalidWorkItemException p\łȂꍇ
	 * @throws InvalidFilterException tB^[Ɍ肪ꍇ
	 */
	private void checkUsing(String wid)
	throws InvalidWorkItemException, InvalidFilterException
	{
		StateFilter filter = new StateFilter(WorkItemState.OPEN_NOT_RUNNING_SUSPENDED);
		WorkItemState[] states = getWorkItemStates(wid, filter);

		//sԂǂ𔻒肷B
		if (states.length == 0) {
			// ƍڂ͎sԂł͂܂B
			String E0182 = StringManager.get("E0182");
			throw new InvalidWorkItemException(E0182);
		}
	}
}
