/* $Id: WorkItemInternal.java,v 1.14 2005/08/26 04:53:21 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.omg.InvalidResourceException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;

/**
 * GWŊǗƍڃIuWFNg킷B
 * ͖gpŁAOMGC^tF[XƂ̐̂߂ɒ񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
public class WorkItemInternal implements WfAssignment
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ƍ */
	private WorkItem workItem;
	
	/**
	 * GWŊǗƍڃIuWFNg𐶐B
	 *
	 * @param item ƍ
	 */
	public WorkItemInternal(WorkItem item)
	{
		this.workItem = item;
	}

	/**
	 * \[X蓖ĂANeBreBԂB
	 *
	 * @return WfActivity
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignment#getActivity()
	 */
	public WfActivity getActivity() throws WorkflowException
	{
		try {
			String pid = workItem.getProcessID();
			String aid = workItem.getActivityID();
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			ActivityDAO activityDAO = daoFactory.getActivityDAO();
		
			ActivityBean bean = activityDAO.findByPrimaryKey(pid, aid);
			WfActivity act = new ActivityInternal(bean);
			return act;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB̎擾Ɏs܂B
			String E0124 = StringManager.get("E0124");
			throw new WorkflowException(E0124, ex);
		}
	}

	/**
	 * 蓖Ăꂽ\[XԂB
	 *
	 * @return WfResource
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignment#getAssignee()
	 */
	public WfResource getAssignee() throws WorkflowException
	{
		try {
			Participant part = null;
			int ptype = workItem.getParticipantType();
			String pname =workItem.getParticipantName();
			ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
			if (ptype == Participant.HUMAN) {
				UserManager um = rmf.getUserManager();
				User user = um.getUser(pname);
				part = ParticipantHelper.narrow(user);
			} else if (ptype == Participant.ORGANIZATIONAL_UNIT) {
				OrganizationManager om = rmf.getOrganizationManager();
				Organization org = om.getOrganization(pname);
				part = ParticipantHelper.narrow(org);
			} else if (ptype == Participant.ROLE) {
				RoleManager rm = rmf.getRoleManager();
				Role role = rm.getRole(pname);
				part = ParticipantHelper.narrow(role);
			} else {
				// [UƂĕsK؂ȃ[Nt[Q҂łB
				String E0143 = StringManager.get("E0143");
				throw new WorkflowException(E0143);
			}
			if (part == null) {
				// [Nt[Q҂݂܂B
				String E0145 = StringManager.get("E0145");
				throw new WorkflowException(E0145);
			}
			WfResource ret = new ResourceInternal(part);
			return ret;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// [Nt[Q҂̎擾Ɏs܂B
			String E0141 = StringManager.get("E0141");
			throw new WorkflowException(E0141, ex);
		}
	}

	/**
	 * w肳ꂽ\[Xݒ肷B
	 *
	 * @param value WfResource
	 * @throws InvalidResourceException ȃ\[X̏ꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignment#setAssignee(jp.co.argo21.nautica.workflow.omg.WfResource)
	 */
	public void setAssignee(WfResource value)
	throws InvalidResourceException, WorkflowException
	{
		try {
			if (value == null || value instanceof ResourceInternal == false) {
				// K؂ȃ\[Xł͂܂B
				String E0144 = StringManager.get("E0144");
				throw new InvalidResourceException(E0144);
			}
			ResourceInternal rsc = (ResourceInternal)value;
			Participant part = rsc.getParticipant();
			if (part == null) {
				// [Nt[Q҂݂܂B
				String E0145 = StringManager.get("E0145");
				throw new InvalidResourceException(E0145);
			}
			int sparttype = workItem.getParticipantType();
			String spartid = workItem.getParticipantName();
			Participant src = new ParticipantImpl(spartid, "", sparttype);
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
			workItemDAO.updateParticipant(workItem.getID(), src, part);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// [Nt[Q҂̐ݒɎs܂B
			String E0142 = StringManager.get("E0142");
			throw new WorkflowException(E0142, ex);
		}
	}
	
	/**
	 * ێĂƍڂԂB
	 *
	 * @return ƍ
	 */
	WorkItem getWorkItem()
	{
		return workItem;
	}
}
