/* $Id: WorkItemPool.java,v 1.13 2005/08/26 04:53:13 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

import org.apache.log4j.Logger;

/**
 * ƍڃv[B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.13 $
 * @since   Nautica Workflow 0.9
 */
public class WorkItemPool
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** WorkItemPool̃VOg */
	static private WorkItemPool singleton;

	/** ƍڃReipnbVe[u */
	private Map containers = new Hashtable();
	
	/**
	 * WorkItemPool̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		try {
			singleton = new WorkItemPool();
			singleton.init();
		} catch (Exception ex) {
			// ƍڃv[̏Ɏs܂B
			String E0113 = StringManager.get("E0113");
			eLog.error(E0113);
			throw ex;
		}
	}

	/**
	 * WorkItemPool̃CX^XԂB
	 *
	 * @return WorkItemPool
	 */
	static WorkItemPool getInstance()
	{
		return singleton;
	}
	
	/**
	 * WorkItemPool𐶐B
	 */
	private WorkItemPool()
	{
	}
	
	/**
	 * WorkItemPoolB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
	}

	/**
	 * ƍڃReiԂB
	 *
	 * @return ƍڃRei
	 */
	WorkItemContainer getWorkItemContainer(String session)
	throws InvalidSessionException
	{
		try {
			SessionManagerFactory smf = SessionManagerFactory.getInstance();
			SessionManager sm = smf.getSessionManager();
			User user = sm.getSessionUser(session);
			String uid = user.getID();

			WorkItemContainer container = (WorkItemContainer)containers.get(uid);

			//̃ReiȂ΍쐬B
			if (container == null || container.isExpired()) {
				Participant userResource;
				List orgResources = new ArrayList();
				List roleResources = new ArrayList();

				userResource = ParticipantHelper.narrow(user);

				ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
				
				//[UgD\[X擾
				OrganizationManager om = rmf.getOrganizationManager(session);
				Organization[] orgs = om.getOrganizationByUser(user);
				for (int i = 0; i < orgs.length; i++) {
					orgResources.add(ParticipantHelper.narrow(orgs[i]));
				}

				//[UĂ錠\[X擾
				RoleManager rm = rmf.getRoleManager(session);
				Role[] userRoles = rm.getAttachedRoles(user);
				for (int i = 0; i < userRoles.length; i++) {
					roleResources.add(ParticipantHelper.narrow(userRoles[i]));
				}

				//ǗɃ[Up̃Reiǉ
				container = new WorkItemContainer(userResource, orgResources, roleResources);
				containers.put(uid, container);
			}
			return container;
		} catch (InvalidSessionException ex) {
			throw ex;
		} catch (Exception ex) {
			// ƍڃRei̎擾Ɏs܂B
			String E0161 = StringManager.get("E0161");
			throw new InvalidSessionException(E0161, ex);
		}
	}
}
