/* $Id: WorkflowAdminHandlerImpl.java,v 1.18 2005/08/26 04:53:15 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;

/**
 * [Nt[Ǘnh́A[Nt[ɑ΂
 * ǗNCAgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.18 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowAdminHandlerImpl implements WorkflowAdminHandler
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** čO */
	static private Logger audit = LogManager.getAuditLogger();

	/**
	 * WorkflowAdminHandlerImpl𐶐B
	 */
	WorkflowAdminHandlerImpl()
	{
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param state VvZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#changeProcessesState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.ProcessState)
	 */
	public void changeProcessesState(String session,
		String pdid, Filter filter, ProcessState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidStateException,
		TransitionNotAllowedException
	{
		String argInfo = "(NAUTICA API = changeProcessesState,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "filter = [" + filter + "],"
			 + "state = [" + state + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			
			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String msg = StringManager.get("E0060");
				throw new InvalidFilterException(msg);
			}
		
			if (state == null) {
				// vZX̏Ԃݒ肳Ă܂B
				String msg = StringManager.get("E0063");
				throw new InvalidStateException(msg);
			} else if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
				// vZX̏Ԃ𖢊Jnɂ邱Ƃ͂ł܂B
				String msg = StringManager.get("E0064");
				throw new InvalidStateException(msg);
			} else if (ProcessState.CLOSED_COMPLETED.equals(state)) {
				// vZX̏ԂIɐI邱Ƃ͂ł܂B
				String msg = StringManager.get("E0065");
				throw new InvalidStateException(msg);
			}

			DataAccessManager.begin(false);
				
			validateSession(session);
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.changeProcessesState(filter, state);
				
			DataAccessManager.commit();
			
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMChangedProcessInstanceState", session),
		            new AuditSuffix());
		    data.setDataElement("NewProcessState", state);
		    audit.info(data);
	
		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidStateException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (TransitionNotAllowedException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXԂ̕ύXɎs܂B
			String E0156 = StringManager.get("E0156") + argInfo;
			eLog.error(E0156, ex);
			throw new TransitionNotAllowedException(E0156, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param state VANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#changeActivitiesState(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.ActivityState)
	 */
	public void changeActivitiesState(String session,
		String pdid, String adid, Filter filter, ActivityState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidStateException, TransitionNotAllowedException
	{
		String argInfo = "(NAUTICA API = changeActivitiesState,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "adid = [" + adid + "],"
			 + "filter = [" + filter + "],"
			 + "state = [" + state + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			checkActivityDefinitionID(adid);

			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String msg = StringManager.get("E0060");
				throw new InvalidFilterException(msg);
			}
		
			if (state == null) {
				// ANeBreB̏Ԃݒ肳Ă܂B
				String msg = StringManager.get("E0066");
				throw new InvalidStateException(msg);
			} else if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
				// ANeBreB̏Ԃ𖢊Jnɂ邱Ƃ͂ł܂B
				String msg = StringManager.get("E0067");
				throw new InvalidStateException(msg);
			} else if (ActivityState.CLOSED_COMPLETED.equals(state)) {
				// ANeBreB̏ԂIɐI邱Ƃ͂ł܂B
				String msg = StringManager.get("E0068");
				throw new InvalidStateException(msg);
			}
		
			DataAccessManager.begin(false);
				
			validateSession(session);

			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.changeActivitiesState(adid, filter, state);
			
			DataAccessManager.commit();
			
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMChangedActivityInstanceState", session),
		            new AuditSuffix());
		    data.setDataElement("NewActivityState", state);
		    audit.info(data);
	
		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidActivityNameException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidStateException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (TransitionNotAllowedException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// ANeBreBԂ̕ύXɎs܂B
			String E0157 = StringManager.get("E0157") + argInfo;
			eLog.error(E0157, ex);
			throw new TransitionNotAllowedException(E0157, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁A~sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#terminateProcesses(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void terminateProcesses(String session,
		String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException
	{
		String argInfo = "(NAUTICA API = terminateProcesses,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "filter = [" + filter + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			
			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String msg = StringManager.get("E0060");
				throw new InvalidFilterException(msg);
			}
			
			DataAccessManager.begin(false);
				
			validateSession(session);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.terminateProcesses(filter);
				
			DataAccessManager.commit();
			
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMTerminatedProcessInstance", session),
		            new AuditSuffix());
		    data.setDataElement("NewProcessState", ProcessState.CLOSED_TERMINATED);
		    audit.info(data);
	
		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZX̒~Ɏs܂B
			String E0136 = StringManager.get("E0136") + argInfo;
			eLog.error(E0136, ex);
			throw new InvalidFilterException(E0136, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁Å蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#assignProcessesAttribute(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignProcessesAttribute(String session,
		String pdid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidAttributeException
	{
		String argInfo = "(NAUTICA API = assignProcessesAttribute,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "filter = [" + filter + "],"
			 + "attr = [" + attr + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			
			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String E0060 = StringManager.get("E0060");
				throw new InvalidFilterException(E0060);
			}
		
			if (attr == null) {
				// vZXϐݒłB
				String E0131 = StringManager.get("E0131");
				throw new InvalidAttributeException(E0131);
			}
			
			DataAccessManager.begin(false);
				
			validateSession(session);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.assignProcessesAttribute(filter, attr);
				
			DataAccessManager.commit();
				
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMAssignedProcessInstanceAttributes", session),
		            new AuditSuffix());
		    data.setDataElement("AttributeName", attr.getName());
		    data.setDataElement("AttributeType", attr.getType());
		    data.setDataElement("NewAttributeValue", attr.getValue());
		    audit.info(data);

		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidAttributeException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080") + argInfo;
			eLog.error(E0080, ex);
			throw new InvalidFilterException(E0080, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁A
	 * ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#assignActivitiesAttribute(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignActivitiesAttribute(String session,
		String pdid, String adid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException
	{
		String argInfo = "(NAUTICA API = assignActivitiesAttribute,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "adid = [" + adid + "],"
			 + "filter = [" + filter + "],"
			 + "attr = [" + attr + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			checkActivityDefinitionID(adid);
		
			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String msg = StringManager.get("E0060");
				throw new InvalidFilterException(msg);
			}
		
			if (attr == null) {
				// vZXϐݒłB
				String E0131 = StringManager.get("E0131");
				throw new InvalidAttributeException(E0131);
			}
		
			DataAccessManager.begin(false);
				
			validateSession(session);

			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.assignActivitiesAttribute(adid, filter, attr);
				
			DataAccessManager.commit();
				
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMAssignedActivityInstanceAttributes", session),
		            new AuditSuffix());
		    data.setDataElement("AttributeName", attr.getName());
		    data.setDataElement("AttributeType", attr.getType());
		    data.setDataElement("NewAttributeValue", attr.getValue());
		    audit.info(data);

		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidActivityNameException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidAttributeException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// ANeBreBw̃vZXϐ̐ݒɎs܂B
			String E0158 = StringManager.get("E0158") + argInfo;
			eLog.error(E0158, ex);
			throw new InvalidAttributeException(E0158, ex);
		}
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AfsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#abortProcesses(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void abortProcesses(String session,
		String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException
	{
		String argInfo = "(NAUTICA API = abortProcesses,"
			 + "session = [" + session + "],"
			 + "pdid = [" + pdid + "],"
			 + "filter = [" + filter + "])";
	
		try {
			checkProcessDefinitionID(pdid);
			
			if (filter == null)
			{
				// tB^[ݒ肳Ă܂B̌Ăяoɂ́AȂƂԃtB^[KvłB
				String msg = StringManager.get("E0060");
				throw new InvalidFilterException(msg);
			}
			
			DataAccessManager.begin(false);
				
			validateSession(session);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getProcessManager(pdid);
			pm.abortProcesses(filter);
				
			DataAccessManager.commit();
				
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix("", "WMAbortedProcessInstance", session),
		            new AuditSuffix());
		    data.setDataElement("NewProcessState", ProcessState.CLOSED_ABORTED);
		    audit.info(data);

		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessDefinitionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidFilterException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			// vZX̒~Ɏs܂B
			String E0137 = StringManager.get("E0137") + argInfo;
			eLog.error(E0137, ex);
			throw new InvalidFilterException(E0137, ex);
		}
	}

	/**
	 * w肳ꂽvZXCX^X̒fsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler#abortProcess(java.lang.String, java.lang.String)
	 */
	public void abortProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException
	{
		String argInfo = "(NAUTICA API = abortProcesses,"
			 + "session = [" + session + "],"
			 + "pid = [" + pid + "])";
	
		try {
			if (pid == null || pid.trim().equals("")) {
				// vZXIDݒłB
				String E0189 = StringManager.get("E0189");
				throw new InvalidProcessInstanceException(E0189);
			}
		
			DataAccessManager.begin(false);
				
			validateSession(session);
	
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			
			proc.abort();
				
			DataAccessManager.commit();
				
			// čOo
		    AuditDataRecord data = new AuditDataRecord(
		            new AuditPrefix(pid, "WMAbortedProcessInstance", session),
		            new AuditSuffix());
		    data.setDataElement("NewProcessState", ProcessState.CLOSED_ABORTED);			    
		    audit.info(data);

		} catch (InvalidSessionException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (InvalidProcessInstanceException ex) {
			rollbackAndLogging(ex, argInfo);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// vZX̒~Ɏs܂B
			String E0137 = StringManager.get("E0137") + argInfo;
			eLog.error(E0137, ex);
			throw new InvalidProcessInstanceException(E0137, ex);
		}
	}
	
	/**
	 * [obNƃG[Ȍo͂sB
	 *
	 * @param ex O
	 * @param argInfo 
	 */
	private void rollbackAndLogging(Exception ex, String argInfo)
	{
		try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
		String msg = ex.getMessage() + argInfo;
		eLog.error(msg, ex);
	}
	
	/**
	 * vZX`ID؂B
	 *
	 * @param pdid vZX`ID
	 * @throws InvalidProcessDefinitionException ȃvZX`ID̏ꍇ
	 */
	private void checkProcessDefinitionID(String pdid)
	throws InvalidProcessDefinitionException
	{
		if (pdid == null || pdid.trim().equals("")) {
			// vZX`IdݒłB
			String E0188 = StringManager.get("E0188");
			throw new InvalidProcessDefinitionException(E0188);
		}
	}
	
	/**
	 * ANeBreB`ID؂B
	 *
	 * @param adid ANeBreB`ID
	 * @throws InvalidActivityNameException ȃANeBreB`ID̏ꍇ
	 */
	private void checkActivityDefinitionID(String adid)
	throws InvalidActivityNameException
	{
		if (adid == null || adid.trim().equals("")) {
			// ANeBreB`IDݒłB
			String E0190 = StringManager.get("E0190");
			throw new InvalidActivityNameException(E0190);
		}
	}

	/**
	 * ZbV؂B
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	private void validateSession(String session)
	throws InvalidSessionException
	{
		if (session == null || session.trim().equals("")) {
			// ZbVIDݒłB
			String E0170 = StringManager.get("E0170");
			throw new InvalidSessionException(E0170);
		}

		SessionManagerFactory factory = SessionManagerFactory.getInstance();
		SessionManager manager = factory.getSessionManager();
		manager.validateSession(session);
		
		//ǗҌ̌
		User user = manager.getSessionUser(session);
		if (user == null) {
			// sȗp҂łB
			String msg = StringManager.get("E0061");
			throw new InvalidSessionException(msg);
		} else {
			try {
				String uid = user.getID();
				SystemChecker.checkAdmin(uid);
			} catch (Exception ex) {
				// ǗҌ܂B
				String msg = StringManager.get("E0062");
				throw new InvalidSessionException(msg);
			}
		}
	}
}
