/* $Id: WorkflowEngine.java,v 1.24 2005/08/26 04:53:37 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.IOException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorPO;
import jp.co.argo21.nautica.workflow.rmi.ServiceNames;
import jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerPO;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;

/**
 * [Nt[GWNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.24 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowEngine
implements WorkflowServiceManager
{
	/** bNt@C */
	static private final String LOCKFILE = "nautica.lck";
	
	/** WorkflowEnginẽVOgCX^X */
	static private WorkflowEngine engine;

	/** GWO */
	static private Logger eLog;
		
	/** `|Wg */
	private DefinitionRepositoryImpl definitionRepository;

	/** [Nt[GWnh */
	private WorkflowEngineHandlerImpl workflowEngineHandler;

	/** [Nt[Ǘnh */
	private WorkflowAdminHandlerImpl workflowAdminHandler;

	/** ƍڃnh */
	private WorkItemHandlerImpl workItemHandler;

	/**
	 * NsB
	 *
	 * @param adminkey ǗpL[
	 * @throws Exception Cӂ̗O
	 */
	static public void boot(String adminkey) throws Exception
	{
		SystemChecker.checkBootPath();
		SystemChecker.checkAdmin(adminkey);
		
		//ɋNς݂ǂmFB
		if (! createLockfile()) {
			throw new WorkflowException(StringManager.get("E0001"));
		}

		engine = new WorkflowEngine();
		engine.lock();
	}

	/**
	 * Vbg_EsB
	 *
	 * @param session ZbVID
	 * @param adminkey ǗpL[
	 * @throws Exception Cӂ̗O
	 */
	static public void shutdown(String session, String adminkey)
	throws InvalidSessionException, WorkflowException
	{
		if (engine == null) {
			eLog.warn(StringManager.get("W0001"));
			return;
		}

		engine.validateSession(session);
		
		shutdown(adminkey);
	}

	/**
	 * WorkflowEnginẽCX^XԂB
	 *
	 * @return WorkflowEngine
	 */
	static public WorkflowEngine getInstance()
	{
		return engine;
	}

	/**
	 * Vbg_EsB
	 *
	 * @param adminkey ǗpL[
	 * @throws Exception Cӂ̗O
	 */
	static void shutdown(String adminkey)
	throws WorkflowException
	{
		SystemChecker.checkAdmin(adminkey);
		engine.unlock();
	}

	/**
	 * bNt@C𐶐B
	 *
	 * @return bNt@C̐ɐꍇtrue
	 */
	static private boolean createLockfile()
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		String path = home + separator + "temp" + separator + LOCKFILE;

		try {
			File lockFile = new File(path);
			boolean isSuccess = lockFile.createNewFile();
			if (isSuccess) {
				lockFile.deleteOnExit();
			}
			return isSuccess;
		} catch (IOException ex) {
			return false;
		}
	}

	/**
	 * bNt@C݂ꍇAɍ폜B
	 */
	static private void forceDeleteLockfile()
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		String path = home + separator + "temp" + separator + LOCKFILE;

		File lockFile = new File(path);
		if (lockFile.exists()) {
			lockFile.delete();
		}
	}
	
	/**
	 * WorkflowEngine𐶐B
	 */
	private WorkflowEngine()
	{
	}

	/**
	 * [Nt[GWւ̐ڑF؂sA
	 * ZbVID擾B
	 *
	 * @param user [UID
	 * @param pass pX[h
	 * @return ZbVID
	 * @throws ConnectionFailedException ڑF؂Ɏsꍇ
	 */
	public String connect(String user, String pass)
	throws ConnectionFailedException
	{
		String argInfo = "(WfMC API = connect,"
			 + "user = [" + user + "],"
			 + "password = [**SECURITY**])";
	
		try {
			if (user == null || user.trim().equals("")) {
				// [UIDݒłB
				String E0166 = StringManager.get("E0166");
				throw new ConnectionFailedException(E0166);
			}

			if (pass == null) {
				// pX[hݒłB
				String E0167 = StringManager.get("E0167");
				throw new ConnectionFailedException(E0167);
			}
		
			DataAccessManager.begin(false);
				
			SessionManagerFactory factory = SessionManagerFactory.getInstance();
			SessionManager manager = factory.getSessionManager();
			String session = manager.createSession(user, pass);
	
			DataAccessManager.commit();
	
			return session;
		} catch (ConnectionFailedException ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			String msg = ex.getMessage() + argInfo;
			eLog.error(msg, ex);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// [Nt[GWւ̔F؂Ɏs܂B
			String E0172 = StringManager.get("E0172") + argInfo;
			eLog.error(E0172, ex);
			throw new ConnectionFailedException(E0172, ex);
		}		
	}

	/**
	 * [Nt[GWƂ̐ؒfsB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public void disconnect(String session)
	throws InvalidSessionException
	{
		String argInfo = "(WfMC API = disconnect,"
			 + "session = [" + session + "])";
	
		try {
			DataAccessManager.begin(false);
			
			SessionManagerFactory factory = SessionManagerFactory.getInstance();
			SessionManager manager = factory.getSessionManager();
			manager.invalidateSession(session);
			
			DataAccessManager.commit();

		} catch (InvalidSessionException ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			String msg = ex.getMessage() + argInfo;
			eLog.error(msg, ex);
			throw ex;
		} catch (Exception ex) {
			try { DataAccessManager.rollback(); } catch (Exception ex2) { /* Ignore */ }
			// [Nt[GW̐ؒfɎs܂B
			String E0173 = StringManager.get("E0173") + argInfo;
			eLog.error(E0173, ex);
			throw new InvalidSessionException(E0173, ex);
		}
	}

	/**
	 * `|WgԂB
	 *
	 * @param session ZbVID
	 * @return `|Wg
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public DefinitionRepository getDefinitionRepository(String session)
	throws InvalidSessionException
	{
		validateSession(session);

		return definitionRepository;
	}

	/**
	 * [Nt[GWnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[GWnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public WorkflowEngineHandler getWorkflowEngineHandler(String session)
	throws InvalidSessionException
	{
		validateSession(session);

		return workflowEngineHandler;
	}

	/**
	 * [Nt[ǗnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[Ǘnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public WorkflowAdminHandler getWorkflowAdminHandler(String session)
	throws InvalidSessionException
	{
		validateSession(session);

		return workflowAdminHandler;
	}

	/**
	 * ƍڃnhԂB
	 *
	 * @param session ZbVID
	 * @return ƍڃnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public WorkItemHandler getWorkItemHandler(String session)
	throws InvalidSessionException
	{
		validateSession(session);

		return workItemHandler;
	}

	/**
	 * w肳ꂽOŁAbZ[WL[쐬B
	 *
	 * @param session ZbVID
	 * @param queueName L[
	 * @param adapter bZ[WMp̃A_v^
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException L[ɂꍇȂǂ͗OƂȂB
	 */
	public void generateQueue(String session, String queueName,
			WorkflowMessageAdapter adapter)
	throws InvalidSessionException, WorkflowException
	{
		validateSession(session);
		
		if (queueName == null || queueName.trim().equals("")) {
			// bZ[WL[ݒłB
			String E0168 = StringManager.get("E0168");
			throw new WorkflowException(E0168);
		}

		if (adapter == null) {
			// bZ[WMA_v^ݒłB
			String E0169 = StringManager.get("E0169");
			throw new WorkflowException(E0169);
		}

		MessageBroker broker = MessageBroker.getInstance();
		broker.generateQueue(queueName, adapter);
	}

	/**
	 * bZ[W]ԂB
	 *
	 * @param session ZbVID
	 * @param queueName L[
	 * @return bZ[W]
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws MessagingException L[݂Ȃꍇ
	 */
	public MessageTransporter getMessageTransporter(String session, String queueName)
	throws InvalidSessionException, MessagingException
	{
		validateSession(session);
		
		if (queueName == null || queueName.trim().equals("")) {
			// bZ[WL[ݒłB
			String E0168 = StringManager.get("E0168");
			throw new MessagingException(E0168);
		}

		//L[̑݃`FbN
		MessageBroker broker = MessageBroker.getInstance();
		WorkflowMQ mq = broker.getWorkflowMQ(queueName);
		if (mq == null) {
			// bZ[WL[݂܂B
			String E0171 = StringManager.get("E0171") + "(Queue = " + queueName + ")";
			throw new MessagingException(E0171);
		}

		return new MessageTransporter(queueName);
	}

	/**
	 * `|WgԂB
	 * X[p[oCU[pB
	 *
	 * @return `|Wg
	 */
	DefinitionRepositoryImpl getDefinitionRepository()
	{
		return definitionRepository;
	}

	/**
	 * [Nt[GWnhԂB
	 * X[p[oCU[pB
	 *
	 * @return [Nt[GWnh
	 */
	WorkflowEngineHandlerImpl getWorkflowEngineHandler()
	{
		return workflowEngineHandler;
	}

	/**
	 * [Nt[ǗnhԂB
	 * X[p[oCU[pB
	 *
	 * @return [Nt[Ǘnh
	 */
	WorkflowAdminHandlerImpl getWorkflowAdminHandler()
	{
		return workflowAdminHandler;
	}

	/**
	 * ƍڃnhԂB
	 * X[p[oCU[pB
	 *
	 * @return ƍڃnh
	 */
	WorkItemHandlerImpl getWorkItemHandler()
	{
		return workItemHandler;
	}

	/**
	 * bZ[WL[ɃbZ[W𑗂B
	 * X[p[oCU[pB
	 *
	 * @param queueName L[
	 * @throws MessagingException L[݂Ȃꍇ
	 */
	MessageTransporter getMessageTransporter(String queueName)
	throws MessagingException
	{
		//L[̑݃`FbN
		MessageBroker broker = MessageBroker.getInstance();
		WorkflowMQ mq = broker.getWorkflowMQ(queueName);
		if (mq == null) {
			// bZ[WL[݂܂B
			String E0171 = StringManager.get("E0171") + "(Queue = " + queueName + ")";
			throw new MessagingException(E0171);
		}

		return new MessageTransporter(queueName);
	}

	/**
	 * bNs
	 *
	 * @throws InterruptedException Xbh荞܂ꂽꍇ
	 * @throws Exception Cӂ̗O
	 */
	private synchronized void lock()
	throws InterruptedException, Exception
	{
		try {
			init();
			eLog.info(StringManager.get("I0002"));

		} catch (Exception ex) {
			forceDeleteLockfile();
			String E0002 = StringManager.get("E0002");
			eLog.error(E0002, ex);
			throw ex;
		}

		//bootÎŁA j^[đҋ@
		wait();

		System.exit(0);
	}
	
	/**
	 * ҋ@XbhɒʒmB
	 */
	private synchronized void unlock()
	{
		notifyAll();
	}
	
	/**
	 * WorkflowEngineB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		Runtime.getRuntime().addShutdownHook(new ShutdownHook());

		LogManager.create();
		eLog = LogManager.getEngineLogger();
		eLog.info(StringManager.get("I0001"));

		MessageBroker.create();
		eLog.info(StringManager.get("I0004"));
		
		ResourceManagerFactory.create();
		eLog.info(StringManager.get("I0005"));

		SessionManagerFactory.create();
		eLog.info(StringManager.get("I0006"));
		
		DataAccessManager.create();
		eLog.info(StringManager.get("I0025"));
		
		RequesterManager.create();
		eLog.info(StringManager.get("I0026"));
		
		ToolAgentManager.create();
		eLog.info(StringManager.get("I0027"));
		
		ProcessManagerFactory.create();
		eLog.info(StringManager.get("I0028"));

		ActivityBehaviorFactory.create();
		eLog.info(StringManager.get("I0029"));

		WorkItemPool.create();
		eLog.info(StringManager.get("I0030"));
		
		
		//GWԐڑ͕KvȂ琶
		String interWorkflow = System.getProperty(WorkflowEngineConstants.NAUTICA_INTER_WORKFLOW);
		if (interWorkflow != null && interWorkflow.equals("enable")) {
			InterWorkflowConnectorImpl.create();
			eLog.info(StringManager.get("I0007"));
		}
		
		bindLocalService();
		eLog.info(StringManager.get("I0008"));
		bindRemoteService();
		eLog.info(StringManager.get("I0009"));

		MessageBroker broker = MessageBroker.getInstance();
		broker.generateQueue(StartProcessRequestWatcher.NAME,
				new StartProcessRequestWatcher());
		eLog.info(StringManager.get("I0041"));
		broker.generateQueue(StartActivityRequestWatcher.NAME,
				new StartActivityRequestWatcher());
		eLog.info(StringManager.get("I0042"));
		broker.generateQueue(EndActivityRequestWatcher.NAME,
				new EndActivityRequestWatcher());
		eLog.info(StringManager.get("I0043"));
		broker.generateQueue(EndProcessRequestWatcher.NAME,
				new EndProcessRequestWatcher());
		eLog.info(StringManager.get("I0044"));
	}

	/**
	 * [JT[rXoChB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void bindLocalService() throws Exception
	{
		definitionRepository = new DefinitionRepositoryImpl();
		eLog.info(StringManager.get("I0010"));
		workflowEngineHandler = new WorkflowEngineHandlerImpl();
		eLog.info(StringManager.get("I0011"));
		workflowAdminHandler = new WorkflowAdminHandlerImpl();
		eLog.info(StringManager.get("I0012"));
		workItemHandler = new WorkItemHandlerImpl();
		eLog.info(StringManager.get("I0013"));
	}

	/**
	 * [gT[rXoChB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void bindRemoteService() throws Exception
	{
		String scope = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);
		if (scope == null) scope = "";
		scope = scope.trim();
		eLog.info("Workflow engine scope name: [" + scope + "]");
		
		Context context = new InitialContext();
		try {
			context.createSubcontext(scope);
		} catch (NameAlreadyBoundException ex) { /* NOP */ }

		if (scope.equals("") == false) scope += "/";

		WorkflowServiceManagerPO wsmPO
			= new WorkflowServiceManagerPO(
				this,
				definitionRepository,
				workflowEngineHandler,
				workflowAdminHandler,
				workItemHandler
				);
		context.rebind(scope + ServiceNames.NAUTICA_WORKFLOW_SERVICE, wsmPO);
		eLog.info(StringManager.get("I0014") + "(" + scope + ServiceNames.NAUTICA_WORKFLOW_SERVICE + ")");

		//GWԐڑ͕KvȂ琶
		String interWorkflow = System.getProperty(WorkflowEngineConstants.NAUTICA_INTER_WORKFLOW);
		if (interWorkflow != null && interWorkflow.equals("enable")) {
			InterWorkflowConnector c = InterWorkflowConnectorImpl.getInstance();
			InterWorkflowConnectorPO iwcPO = new InterWorkflowConnectorPO(c);
			context.rebind(scope + ServiceNames.NAUTICA_INTER_WORKFLOW_SERVICE, iwcPO);
			eLog.info(StringManager.get("I0015") + "(" + scope + ServiceNames.NAUTICA_INTER_WORKFLOW_SERVICE + ")");
		}
	}
	
	/**
	 * Vbg_EsB
	 */
	private void shutdown() throws Exception
	{
		MessageBroker broker = MessageBroker.getInstance();
		broker.shutdown();

		//[gIuWFNg̃AoCh
		unbindRemoteService();
		eLog.info(StringManager.get("I0016"));

		//T[rX̒~
		unbindLocalService();
		eLog.info(StringManager.get("I0017"));
	}

	/**
	 * [JT[rXAoChB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void unbindLocalService() throws Exception
	{
	    definitionRepository.unbind();
		definitionRepository = null;
		eLog.info(StringManager.get("I0018"));
		workflowEngineHandler = null;
		eLog.info(StringManager.get("I0019"));
		workflowAdminHandler = null;
		eLog.info(StringManager.get("I0020"));
		workItemHandler = null;
		eLog.info(StringManager.get("I0021"));
	}

	/**
	 * [gT[rXAoChB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void unbindRemoteService() throws Exception
	{
		String scope = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);
		if (scope == null) scope = "";
		scope = scope.trim();

		Context context = new InitialContext();

		if (scope.equals("") == false) scope += "/";
		context.unbind(scope + ServiceNames.NAUTICA_WORKFLOW_SERVICE);
		eLog.info(StringManager.get("I0022"));
		context.unbind(scope + ServiceNames.NAUTICA_INTER_WORKFLOW_SERVICE);
		eLog.info(StringManager.get("I0023"));
	}
	
	/**
	 * ZbV؂B
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	private void validateSession(String session)
	throws InvalidSessionException
	{
		if (session == null || session.trim().equals("")) {
			// ZbVIDݒłB
			String E0170 = StringManager.get("E0170");
			throw new InvalidSessionException(E0170);
		}

		SessionManagerFactory factory = SessionManagerFactory.getInstance();
		SessionManager manager = factory.getSessionManager();
		manager.validateSession(session);
	}
	
	/**
	 * Vbg_EptbNXbh.
	 */
	private class ShutdownHook extends Thread
	{
		/**
		 * Vbg_EsB
		 * 
		 * @see java.lang.Runnable#run()
		 */
		public void run()
		{
			try {
				engine.shutdown();
				eLog.info(StringManager.get("I0003"));
			} catch (Exception ex) {
				String E0002 = StringManager.get("E0003");
				eLog.error(E0002, ex);
			} finally {
				forceDeleteLockfile();
			}
		}
	}
}
