/* $Id: WorkflowEventObject.java,v 1.7 2005/08/26 04:53:45 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.SourceNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * [Nt[Cxg\B̃NX́A݊̂߂ɗpӂĂ邾
 * ݂̃GWł͎gĂȂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowEventObject implements WfEvent
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** Cxg̎ */
	private String type;
	
	/**CxgNWfExecutionObject */
	private WfExecutionObject source;
	
	/** Cxg */
	private String timestamp;
	
	/** vZX}l[W */
	private String processManagerName;
	
	/** vZX}l[W̃o[W */
	private String processManagerVersion;
	
	/** vZXID */
	private String processID;
	
	/** vZX */
	private String processName;
	
	/** ANeBreBID */
	private String activityID;
	
	/** ANeBreB */
	private String activityName;

	/**
	 * [Nt[Cxg𐶐B
	 *
	 * @param type Cxg̎
	 * @param source CxgNWfExecutionObject
	 * @param timestamp Cxg
	 * @param processManagerName vZX}l[W
	 * @param processManagerVersion vZX}l[W̃o[W
	 * @param processID vZXID
	 * @param processName vZX
	 * @param activityID ANeBreBID
	 * @param activityName ANeBreB
	 */
	public WorkflowEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID, String activityName)
	{
		this.type = type;
		this.source = source;
		this.timestamp = timestamp;
		this.processManagerName = processManagerName;
		this.processManagerVersion = processManagerVersion;
		this.processID = processID;
		this.processName = processName;
		this.activityID = activityID;
		this.activityName = activityName;
	}

	/**
	 * Cxg̎ނԂB
	 *
	 * @return Cxg̎
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getEventType()
	 */
	public String getEventType() throws WorkflowException
	{
		return type;
	}

	/**
	 * CxgNWfExecutionObjectԂB
	 *
	 * @return WfExecutionObject
	 * @throws SourceNotAvailableException \[XȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getSource()
	 */
	public WfExecutionObject getSource()
	throws SourceNotAvailableException, WorkflowException
	{
		return source;
	}

	/**
	 * CxgԂB
	 *
	 * @return Cxg
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getTimestamp()
	 */
	public String getTimestamp() throws WorkflowException
	{
		return timestamp;
	}

	/**
	 * CxgɊ֘AvZX}l[Ŵ̖ԂB
	 *
	 * @return vZX}l[W̖
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessManagerName()
	 */
	public String getProcessManagerName() throws WorkflowException
	{
		return processManagerName;
	}

	/**
	 * CxgɊ֘AvZX}l[W̃o[WԂB
	 *
	 * @return vZX}l[W̃o[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessManagerVersion()
	 */
	public String getProcessManagerVersion() throws WorkflowException
	{
		return processManagerVersion;
	}

	/**
	 * CxgɊ֘AvZXIDԂB
	 *
	 * @return vZXID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessID()
	 */
	public String getProcessID() throws WorkflowException
	{
		return processID;
	}

	/**
	 * CxgɊ֘AvZX̂ԂB
	 *
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessName()
	 */
	public String getProcessName() throws WorkflowException
	{
		return processName;
	}

	/**
	 * CxgɊ֘AANeBreBIDԂB
	 *
	 * @return ANeBreBID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getActivityID()
	 */
	public String getActivityID() throws WorkflowException
	{
		return activityID;
	}

	/**
	 * CxgɊ֘AANeBreB̂ԂB
	 *
	 * @return ANeBreB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getActivityName()
	 */
	public String getActivityName() throws WorkflowException
	{
		return activityName;
	}
}
