/* $Id: LogicalExpression.java,v 1.4 2005/08/26 04:54:52 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.expression;

import java.util.List;

import jp.co.argo21.nautica.workflow.xpdl.LogicalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.RelationalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.UnaryExpressionDocument;

import org.apache.xmlbeans.XmlObject;

/**
 * _
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class LogicalExpression implements Expression
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** AND */
	static public final int AND = LogicalExpressionDocument.LogicalExpression.Type.INT_AND;
	/** OR */
	static public final int OR  = LogicalExpressionDocument.LogicalExpression.Type.INT_OR;
	/** && */
	static private final String AND_STR = "&&";
	/** || */
	static private final String OR_STR  = "||";

	/** Zq */
	private int operator;
	/** ZΏۂ̏ */
	private Expression[] subExpressions;
	
	/**
	 * _𐶐B
	 * 
	 * @param expL	ӏ
	 * @param ope	Zq
	 * @param expR	Eӏ
	 */
	public LogicalExpression(Expression expL, int ope, Expression expR)
	{
		operator = ope;
		subExpressions = new Expression[2];
		subExpressions[0] = expL;
		subExpressions[1] = expR;
	}
	
	/**
	 * XML_𐶐B
	 * 
	 * @param exp	XML
	 */
	public LogicalExpression(LogicalExpressionDocument.LogicalExpression exp)
	{
		operator = exp.getType().intValue();
		subExpressions = new Expression[2];

		int i = 0;

		for (int j = 0; j < exp.sizeOfUnaryExpressionArray(); j++) {
			if (i == 2) break;
			UnaryExpressionDocument.UnaryExpression unary = exp.getUnaryExpressionArray(j);
			subExpressions[i] = new UnaryExpression(unary);
			i++;
		}

		for (int j = 0; j < exp.sizeOfLogicalExpressionArray(); j++) {
			if (i == 2) break;
			LogicalExpressionDocument.LogicalExpression logic = exp.getLogicalExpressionArray(j);
			subExpressions[i] = new LogicalExpression(logic);
			i++;
		}

		for (int j = 0; j < exp.sizeOfRelationalExpressionArray(); j++) {
			if (i == 2) break;
			RelationalExpressionDocument.RelationalExpression rel = exp.getRelationalExpressionArray(j);
			subExpressions[i] = new RelationalExpression(rel);
			i++;
		}
	}
	
	/**
	 * ̃IuWFNgɏi[B
	 * 
	 * @param o	XMLIuWFNg
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#saveTo(org.apache.xmlbeans.XmlObject)
	 */
	public void saveTo(XmlObject o)
	{
		if (o == null) return;
		if (!(o instanceof LogicalExpressionDocument.LogicalExpression)) return;

		LogicalExpressionDocument.LogicalExpression le
			= (LogicalExpressionDocument.LogicalExpression)o;

		le.setType(LogicalExpressionDocument.LogicalExpression.Type.Enum.forInt(operator));
		for (int i = 0; i < subExpressions.length; i++) {
			if (subExpressions[i] == null) continue;

			XmlObject exp = null;
			if (subExpressions[i] instanceof UnaryExpression) {
				exp = le.addNewUnaryExpression();
			} else if (subExpressions[i] instanceof LogicalExpression) {
				exp = le.addNewLogicalExpression();
			} else if (subExpressions[i] instanceof RelationalExpression) {
				exp = le.addNewRelationalExpression();
			}
			subExpressions[i].saveTo(exp);
		}
	}

	/**
	 * ̏ɏ]B
	 * 
	 * @param list	ϐ̌ݒl
	 * @return	ꂽꍇtrue
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#eval(java.util.List)
	 */
	public boolean eval(List list)
	{
		boolean left = false;
		boolean right = false;

		if (subExpressions[0] != null) left = subExpressions[0].eval(list);
		if (subExpressions[1] != null) right = subExpressions[1].eval(list);
		
		if (operator == AND) return (left && right);
		else return (left || right);
	}

	/**
	 * ̕\ԂB
	 * 
	 * @return	\
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getExpressionString()
	 */
	public String getExpressionString()
	{
		String ls = "null";
		String rs = "null";
		if (subExpressions[0] != null) ls = subExpressions[0].getExpressionString();
		if (subExpressions[1] != null) rs = subExpressions[1].getExpressionString();
		
		return "(" + ls +  ") " + getOpeString() + " (" + rs + ")";
	}

	/**
	 * ϐꗗ𗘗pȂ̕\ԂB
	 * 
	 * @param vars	ϐꗗ
	 * @return	\
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getExpressionString(java.util.List)
	 */
	public String getExpressionString(List vars)
	{
		String ls = "null";
		String rs = "null";
		if (subExpressions[0] != null) ls = subExpressions[0].getExpressionString(vars);
		if (subExpressions[1] != null) rs = subExpressions[1].getExpressionString(vars);
		
		return "(" + ls +  ") " + getOpeString() + " (" + rs + ")";
	}

	/**
	 * ̏Ɋ܂܂邷ׂĂ̏ԂB
	 * 
	 * @param exps	ꗗ
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getAllExpressions(java.util.List)
	 */
	public void getAllExpressions(List exps)
	{
		if (exps.contains(this) == false) exps.add(this);
		if (subExpressions[0] != null) subExpressions[0].getAllExpressions(exps);
		if (subExpressions[1] != null) subExpressions[1].getAllExpressions(exps);
	}

	/**
	 * z̕\ԂB
	 * 
	 * @return	\
	 */	
	private String getOpeString()
	{
		if (operator == AND) return AND_STR;
		else return OR_STR;
	}
}
