/* $Id: UnaryExpression.java,v 1.4 2005/08/26 04:54:51 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.expression;

import java.util.List;

import jp.co.argo21.nautica.workflow.xpdl.LogicalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.RelationalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.UnaryExpressionDocument;

import org.apache.xmlbeans.XmlObject;

/**
 * NOT
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class UnaryExpression implements Expression
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** NOT */
	static private final int NOT = UnaryExpressionDocument.UnaryExpression.Type.INT_NOT;

	/** Zq */
	private int operator;
	/** NOTZΏ */
	private Expression subExpression;
	
	/**
	 * NOT𐶐B
	 * 
	 * @param exp	ZΏۂ̏
	 */
	public UnaryExpression(Expression  exp)
	{
		operator = NOT;
		subExpression = exp;
	}
	
	/**
	 * XMLNOT𐶐B
	 * 
	 * @param exp	XML
	 */
	public UnaryExpression(UnaryExpressionDocument.UnaryExpression  exp)
	{
		operator = NOT;
		if (exp.isSetUnaryExpression()) {
			UnaryExpressionDocument.UnaryExpression unary = exp.getUnaryExpression();
			subExpression = new UnaryExpression(unary);
		} else if (exp.isSetLogicalExpression()) {
			LogicalExpressionDocument.LogicalExpression logic = exp.getLogicalExpression();
			subExpression = new LogicalExpression(logic);
		} else if (exp.isSetRelationalExpression()) {
			RelationalExpressionDocument.RelationalExpression rel = exp.getRelationalExpression();
			subExpression = new RelationalExpression(rel);
		}
	}
	
	/**
	 * ̃IuWFNgɏi[B
	 * 
	 * @param o	XMLIuWFNg
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#saveTo(org.apache.xmlbeans.XmlObject)
	 */
	public void saveTo(XmlObject o)
	{
		if (o == null) return;
		if (subExpression == null) return;
		if (!(o instanceof UnaryExpressionDocument.UnaryExpression)) return;

		UnaryExpressionDocument.UnaryExpression ue
			= (UnaryExpressionDocument.UnaryExpression)o;

		ue.setType(UnaryExpressionDocument.UnaryExpression.Type.Enum.forInt(operator));
		XmlObject exp = null;
		if (subExpression instanceof UnaryExpression) {
			exp = ue.addNewUnaryExpression();
		} else if (subExpression instanceof LogicalExpression) {
			exp = ue.addNewLogicalExpression();
		} else if (subExpression instanceof RelationalExpression) {
			exp = ue.addNewRelationalExpression();
		}
		subExpression.saveTo(exp);
	}

	/**
	 * ̏ɏ]B
	 * 
	 * @param list	ϐ̌ݒl
	 * @return	ꂽꍇtrue
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#eval(java.util.List)
	 */
	public boolean eval(List list)
	{
		if (subExpression == null) return false;
		else return (! subExpression.eval(list));
	}

	/**
	 * ̕\ԂB
	 * 
	 * @return	\
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getExpressionString()
	 */
	public String getExpressionString()
	{
		String s = "null";
		if (subExpression != null) s = subExpression.getExpressionString();

		return "! (" + s + ")";
	}

	/**
	 * ϐꗗ𗘗pȂ̕\ԂB
	 * 
	 * @param vars	ϐꗗ
	 * @return	\
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getExpressionString(java.util.List)
	 */
	public String getExpressionString(List vars)
	{
		String s = "null";
		if (subExpression != null) s = subExpression.getExpressionString(vars);

		return "! (" + s + ")";
	}

	/**
	 * ̏Ɋ܂܂邷ׂĂ̏ԂB
	 * 
	 * @param exps	ꗗ
	 * @see jp.co.argo21.nautica.workflow.expression.Expression#getAllExpressions(java.util.List)
	 */
	public void getAllExpressions(List exps)
	{
		if (exps.contains(this) == false) exps.add(this);
		if (subExpression != null) subExpression.getAllExpressions(exps);
	}
}
