/* $Id: AttributeFilter.java,v 1.8 2005/08/26 04:54:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.filter;

import jp.co.argo21.nautica.workflow.wfmc.Filter;

/**
 * ɂtB^Os
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class AttributeFilter implements Filter
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** tB^[^Cv */
	static private int FILTER_TYPE = 5003;

	/**  */
	private String name;

	/** Zq */
	private int comparison;
	
	/** l */
	private String value;
	
	/**
	 * tB^[𐶐B
	 *
	 * @param name 
	 * @param comparison Zq
	 * @param value l
	 */
	public AttributeFilter(String name, int comparison, String value)
	{
		this.name = name;
		this.value = value;

		switch (comparison) {
			case AttributeFilter.EQUAL:
			case AttributeFilter.GREATER_EQUAL:
			case AttributeFilter.GREATER_THAN:
			case AttributeFilter.LESS_EQUAL:
			case AttributeFilter.LESS_THAN:
			case AttributeFilter.NOT_EQUAL:
				this.comparison = comparison;
				break;
			default:
				this.comparison = NameFilter.NOT_EQUAL;
		}
	}
	
	/**
	 * ZqԂB
	 *
	 * @return Zq
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getComparison()
	 */
	public int getComparison()
	{
		return comparison;
	}

	/**
	 * tB^[ƂāAԂB
	 *
	 * @return tB^[
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterName()
	 */
	public String getFilterName()
	{
		return name;
	}

	/**
	 * tB^[ƂĒlԂB
	 *
	 * @return tB^[
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterString()
	 */
	public String getFilterString()
	{
		return value;
	}

	/**
	 * tB^[^CvԂB
	 *
	 * @return tB^[^Cv
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getType()
	 */
	public int getType()
	{
		return AttributeFilter.FILTER_TYPE;
	}
}
