/* $Id: StateFilter.java,v 1.9 2005/08/26 04:54:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.filter;

import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.wfmc.Filter;

/**
 * ԗp̃tB^[łB
 * ̃tB^[Ԃݒ肳ꂽlł̂IB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class StateFilter implements Filter
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** tB^[^Cv */
	static private int FILTER_TYPE = 5002;
	
	/**  */
	private WfState state;
	
	/**
	 * ԃtB^[𐶐B
	 *
	 * @param state 
	 */
	public StateFilter(WfState state)
	{
		this.state = state;
	}

	/**
	 * ZqԂBGroupFilter.EQUALԂ邪AgpȂB
	 *
	 * @return Zq
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getComparison()
	 */
	public int getComparison()
	{
		return StateFilter.EQUAL;
	}

	/**
	 * tB^[ƂāANXԂ邪AgpȂB
	 *
	 * @return tB^[
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterName()
	 */
	public String getFilterName()
	{
		return StateFilter.class.getName();
	}

	/**
	 * tB^[ƂďԂ̐l\ԂB
	 *
	 * @return tB^[
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterString()
	 */
	public String getFilterString()
	{
		return "" + state.toInt();
	}

	/**
	 * tB^[^CvԂB
	 *
	 * @return tB^[^Cv
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getType()
	 */
	public int getType()
	{
		return StateFilter.FILTER_TYPE;
	}
	
	/**
	 * ێĂԂԂB
	 *
	 * @return 
	 */
	public WfState getState()
	{
		return state;
	}
}
