/* $Id: MySQLFactory.java,v 1.6 2005/08/26 04:55:55 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.jdbc;

import javax.sql.DataSource;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;

/**
 * MySQLp̃f[^\[X𐶐B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLFactory implements DataSourceFactory
{
    /**
     * f[^\[Xt@NgIuWFNg𐶐B
     *
     */
    public MySQLFactory() {
        // ȂB
    }
    
	/**
	 * MySQLpf[^\[XԂB
	 *
	 * @return f[^\[X
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.jdbc.DataSourceFactory#getDataSource()
	 */
	public DataSource getDataSource() throws Exception
	{
		String url = System.getProperty("nautica.workflow.datasource.url");
		String user = System.getProperty("nautica.workflow.datasource.user");
		String pass = System.getProperty("nautica.workflow.datasource.password");

		MysqlConnectionPoolDataSource ds = new MysqlConnectionPoolDataSource();
		ds.setUrl(url);
		ds.setUser(user);
		ds.setPassword(pass);
		
		return ds;
	}
}
