/* $Id: WorkflowMQ.java,v 1.11 2005/08/26 04:55:54 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.jms;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * [Nt[p̃bZ[WL[\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowMQ
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** gUNViɃbZ[W邩ǂ̃tO*/
	static private final boolean RECEIVE_TRANSACTION = false;
	
	/** mF[h */
	static private final int RECEIVE_ACKNOWLEDGE_MODE = Session.AUTO_ACKNOWLEDGE;

	/** gUNViɃbZ[W邩ǂ̃tO*/
	static private final boolean SEND_TRANSACTION = true;
	
	/** mF[h */
	static private final int SEND_ACKNOWLEDGE_MODE = Session.SESSION_TRANSACTED;

	/** L[RlNVt@Ng */
	private QueueConnectionFactory factory;

	/** MpL[RlNV */
	private QueueConnection receiveConnection;

	/** MpL[ZbV */
	private QueueSession receiveSession;

	/** V[o */
	private QueueReceiver receiver;
	
	/** bZ[WL[ */
	private Queue queue;

	/**
	 * w肳ꂽOŃL[쐬Aw肳ꂽA_v^o^B
	 *
	 * @param name L[̖O
	 * @param adapter MbZ[WA_v^
	 * @throws MessagingException ɗOꍇ
	 */
	public WorkflowMQ(QueueConnectionFactory factory, String name, WorkflowMessageAdapter adapter)
	throws MessagingException
	{
		try {
			this.factory = factory;
			receiveConnection = factory.createQueueConnection();
			receiveConnection.setClientID(toString());
			receiveSession = receiveConnection.createQueueSession(RECEIVE_TRANSACTION, RECEIVE_ACKNOWLEDGE_MODE);
			queue = receiveSession.createQueue(name);
			receiver = receiveSession.createReceiver(queue);
			receiver.setMessageListener(adapter);
		} catch (JMSException ex) {
			if (receiver != null) {
				try { receiver.close(); } catch (JMSException ex2) { /* ignore */ }
			}
			if (receiveSession != null) {
				try { receiveSession.close(); } catch (JMSException ex2) { /* ignore */ }
			}
			if (receiveConnection != null) {
				try { receiveConnection.close(); } catch (JMSException ex2) { /* ignore */ }
			}
			// bZ[Wp̃A_v^̓o^Ɏs܂B
			String errMsg = StringManager.get("E0048");
			eLog.error(errMsg, ex);
			throw new MessagingException(errMsg, ex);
		}
	}
	
	/**
	 * YL[̃L[ԂB
	 *
	 * @return L[
	 * @throws MessagingException ɗOꍇ
	 */
	public String getQueueName() throws MessagingException
	{
		try {
			return queue.getQueueName();
		} catch (JMSException ex) {
			// bZ[WL[̖O̎擾Ɏs܂A
			String errMsg = StringManager.get("E0041");
			eLog.error(errMsg, ex);
			throw new MessagingException(errMsg, ex);
		}
	}
	
	/**
	 * YL[JnBɊJnĂꍇ́APɖB
	 *
	 * @throws MessagingException ɗOꍇ
	 */
	public void start() throws MessagingException
	{
		try {
			receiveConnection.start();
		} catch (JMSException ex) {
			// bZ[WL[Jnł܂B
			String errMsg = StringManager.get("E0046");
			eLog.error(errMsg, ex);
			throw new MessagingException(errMsg, ex);
		}
	}
	
	/**
	 * YL[ꎞIɒ~B
	 * ĊJꍇ́Astart()ĂԂ悤ɂB
	 *
	 * @throws MessagingException ɗOꍇ
	 */
	public void stop() throws MessagingException
	{
		try {
			receiveConnection.stop();
		} catch (JMSException ex) {
			// bZ[WL[~ł܂B
			String errMsg = StringManager.get("E0047");
			eLog.error(errMsg, ex);
			throw new MessagingException(errMsg, ex);
		}
	}
	
	/**
	 * YL[Vbg_EB
	 */
	public void shutdown()
	{
		if (receiver != null) {
			try {
				receiver.close();
			} catch (JMSException ex) {
				// M@\̃N[YɎs܂B
				String errMsg = StringManager.get("E0043");
				eLog.error(errMsg, ex);
			}
		}
		if (receiveSession != null) {
			try {
				receiveSession.close();
			} catch (JMSException ex) {
				// MZbṼN[YɎs܂B
				String errMsg = StringManager.get("E0044");
				eLog.error(errMsg, ex);
			}
		}
		if (receiveConnection != null) {
			try {
				receiveConnection.close();
			} catch (JMSException ex) {
				// Mڑ̃N[YɎs܂B
				String errMsg = StringManager.get("E0045");
				eLog.error(errMsg, ex);
			}
		}
	}

	/**
	 * w肳ꂽ[Nt[bZ[WL[ɑ΂đMB
	 *
	 * @param message [Nt[bZ[W
	 * @throws MessagingException ɗOꍇ
	 */
	public void send(WorkflowMessage message)
	throws MessagingException
	{
    	QueueConnection con = null;
    	QueueSession session = null;
    	QueueSender sender = null;
		try {
			con = factory.createQueueConnection();
			con.start();
			session = con.createQueueSession(SEND_TRANSACTION, SEND_ACKNOWLEDGE_MODE);
			sender = session.createSender(queue);
			sender.setDeliveryMode(DeliveryMode.PERSISTENT);			
			ObjectMessage om = session.createObjectMessage(message);
			sender.send(om);
			session.commit();
		} catch (JMSException ex) {
			if (session != null) {
				try { session.rollback(); } catch (JMSException ex2) { /* ignore */ }
			}
			// MɃG[N܂B
			String errMsg = StringManager.get("E0042");
			eLog.error(errMsg, ex);
			throw new MessagingException(errMsg, ex);
		} finally {
			if (sender != null) {
				try { sender.close(); } catch (JMSException ex) { /* ignore */ }
			}
			if (session != null) {
				try { session.close(); } catch (JMSException ex) { /* ignore */ }
			}
			if (con != null) {
				try { con.close(); } catch (JMSException ex) { /* ignore */ }
			}
		}
	}
}
