/* $Id: WorkflowMessageAdapter.java,v 1.7 2005/08/26 04:55:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.jms;

import java.io.Serializable;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * WorkflowMessage钊ۃA_v^IuWFNgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public abstract class WorkflowMessageAdapter implements MessageListener
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/**
	 * A_v^IuWFNg𐶐B
	 *
	 */
	public WorkflowMessageAdapter() {
	    // ȂB
	}
	
	/**
	 * {̃Xi[C^tF[X͓IɎgpB
	 *
	 * @param message bZ[W
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	public final void onMessage(Message message)
	{
		if (message instanceof ObjectMessage) {
			try {
				Serializable s = ((ObjectMessage)message).getObject();
				if (s instanceof WorkflowMessage) {
					onMessage((WorkflowMessage)s);
				}
			} catch (JMSException ex) {
				// bZ[W̃G[N܂B
				String errMsg = StringManager.get("E0040");
				eLog.error(errMsg, ex);
			}
		}
	}

	/**
	 * [Nt[bZ[Wꍇ́A{\bh
	 * 邱ƁB
	 *
	 * @param message bZ[W
	 */
	public abstract void onMessage(WorkflowMessage message);
}
