/* $Id: WfActivity.java,v 1.4 2005/08/26 04:55:12 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfActivity̓rWlXvZXɂ1̍ƗvXebv
 * Ǘ̂\C^tF[XłB
 * {ł́ÅǗ̂uANeBreBvƕ\LB
 * WfActivitýAPWfProcessɊ֘AtĂB
 * Cӂ̎_ɂāAWfProcessł͕WfActivityIuWFNg
 * ĂꍇB
 * WfActivitýAANeBreBɑ΂閾IȊ
 * ƌʂݒ肷鑀AWfProcessWfAssignmentƂ̊֘Aǉ邱ƂŁA
 * WfExecutionObjectĂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface WfActivity extends WfExecutionObject, WfRequester {

	/**
	 * ̃ANeBreBĂWfProcessԂB
	 *
	 * @return WfProcess
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfProcess getContainer() throws WorkflowException;

	/**
	 * 蓖ĂĂATCǧԂB
	 *
	 * @return WfAssignmenť
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getAssignmentCount() throws WorkflowException;

	/**
	 * CfNXŎw肳ꂽATCgԂB
	 *
	 * @param index CfNX
	 * @return WfAssignment
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfAssignment getAssignment(int index) throws WorkflowException;

	/**
	 * 蓖ĂĂ邷ׂẴATCgԂB
	 *
	 * @return WfAssignment
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfAssignment[] getAllAssignment() throws WorkflowException;

	/**
	 * w肳ꂽATCgÃANeBreBɊ蓖Ăꂽ̂ǂԂB
	 *
	 * @param ass WfAssignment
	 * @return ̃ANeBreBɊ蓖Ăꂽ̂łꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public boolean isMemberOfAssignment(WfAssignment ass) throws WorkflowException;

	/**
	 * WfActivitẙv邽߂ɁAAvP[VɂĎgpB
	 * ́AsetResult()ƋɁAANeBreB̌ʂvZXɕԂ߂ɎgpB
	 *
	 * @throws CannotCompleteException łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void complete()
	throws CannotCompleteException, WorkflowException;

	/**
	 * WfActivityɂĕ\Ƃ̎sɂĐ錋ʂԂB
	 * ʃf[^܂p\łȂꍇ́AOB
	 *
	 * @return@sʂԂ
	 * @throws ResultNotAvailableException ʂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue[] getResult()
	throws ResultNotAvailableException, WorkflowException;

	/**
	 * WfActivityɂĕ\Ƃ̎sɂĐ錋ʂݒ肷B
	 *
	 * @param result sʂݒ肷B
	 * @throws InvalidDataException ȃf[^̏ꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setResult(WfNameValue[] result)
	throws InvalidDataException, WorkflowException;
}
