/* $Id: WfEvent.java,v 1.5 2005/08/26 04:55:19 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfEvent́A[Nt[sɔCxg̊Ǘ̂\C^tF[XłB
 * OMGdlłWfEventAuditƂĂ邪AWfEventƂB
 * {ł́ÅǗ̂u[Nt[čvƕ\LB
 * WfEvent́AׂĂ̎ނ̃[Nt[č̊C^tF[X񋟂B
 * Cxg̎ނɂ́AԂ̕ωA\[X蓖Ă̕ύXAf[^̕ύXȂǂB
 * ܂A[Nt[č̓[Nt[̕ύXƂĂ̑ʂA
 * iĂKvB
 * ̕ύX́AWfExecutionObjectgetHistory()ɂăANZX\ƂB
 * WfEventIuWFNǵA[Nt[̏Ԃω鎞ɐ邪A
 * ̑Ԃ̓CxgNIuWFNg̑ԂƂ͓ƗĊǗB
 * ́Aʓr^pǗɂĒ߂̂ƂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface WfEvent extends WfObject {

	/**
	 * Cxg̎ނԂB
	 *
	 * @return Cxg̎
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getEventType() throws WorkflowException;

	/**
	 * CxgNWfExecutionObjectԂB
	 *
	 * @return WfExecutionObject
	 * @throws SourceNotAvailableException \[XȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfExecutionObject getSource()
	throws SourceNotAvailableException, WorkflowException;

	/**
	 * CxgԂB
	 *
	 * @return Cxg
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getTimestamp() throws WorkflowException;

	/**
	 * CxgɊ֘AvZX}l[Ŵ̖ԂB
	 *
	 * @return vZX}l[W̖
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getProcessManagerName() throws WorkflowException;

	/**
	 * CxgɊ֘AvZX}l[W̃o[WԂB
	 *
	 * @return vZX}l[W̃o[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getProcessManagerVersion() throws WorkflowException;

	/**
	 * CxgɊ֘AvZXIDԂB
	 *
	 * @return vZXID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getProcessID() throws WorkflowException;

	/**
	 * CxgɊ֘AvZX̂ԂB
	 *
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getProcessName() throws WorkflowException;

	/**
	 * CxgɊ֘AANeBreBIDԂB
	 *
	 * @return ANeBreBID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getActivityID() throws WorkflowException;

	/**
	 * CxgɊ֘AANeBreB̂ԂB
	 *
	 * @return ANeBreB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getActivityName() throws WorkflowException;
}
