/* $Id: WfExecutionObject.java,v 1.7 2005/08/26 04:55:18 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfExecutionObject́AWfProcessWfActivity̋ʂ̑ԁA
 * `Ǘ̂̊C^tF[XłB
 * {ł́ÅǗ̂usIuWFNgvƕ\LB
 * WfExecutionObject́AԂ̎擾ѐݒ@\񋟂B
 * _ł̏Ԃ擾鑀Aʂ̏ԂɑJڂ鑀A
 * ̏ԑJڂɑ΂鑀삪񋟂ĂB
 * ͕̑ۗ(suspend)AĊJ(resume)A~(terminate)Af(abort)łB
 * C^tF[Xɂ́AOAAL[ƂȂ鑮܂ށB
 * ܂As\čAw肳ꂽtB^ɊÂĕԂƂɂāA
 * WfExecutionObject̎s̊Ď񋟂B
 * ɂAReLXg̎擾Ɛݒ̃\bhB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public interface WfExecutionObject extends WfObject {

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getID() throws WorkflowException;

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getName() throws WorkflowException;

	/**
	 * ̂ݒ肷B
	 *
	 * @param name 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setName(String name) throws WorkflowException;

	/**
	 * ڍ׏ԂB
	 *
	 * @return ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getDescription() throws WorkflowException;

	/**
	 * ڍ׏ݒ肷B
	 *
	 * @param desc ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setDescription(String desc) throws WorkflowException;

	/**
	 * ݂̏ԂԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfState getState() throws WorkflowException;

	/**
	 * ݂̏ԂJډ\ȏԂ̈ꗗԂB
	 *
	 * @return Jډ\ȏԂ̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfState[] getTransitableStates() throws WorkflowException;

	/**
	 * w肳ꂽԂɑJڂ݂B
	 *
	 * @param state 
	 * @throws InvalidStateException ȏԂ̏ꍇ
	 * @throws TransitionNotAllowedException w肳ꂽԂɑJڂłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void changeState(WfState state)
	throws InvalidStateException, TransitionNotAllowedException, WorkflowException;

	/**
	 * ŌɏԂJڂԂԂB
	 *
	 * @return ŏIԕύX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getLastStateTime() throws WorkflowException;

	/**
	 * ۗ̎sIuWFNg̍ĊJvB
	 * v󂯓ꂽꍇAԂ́Aopen.not_running.suspendedA
	 * open.runningɐݒ肳B
	 *
	 * @throws CannotResumeException ĊJłȂꍇ 
	 * @throws NotRunningException słȂꍇ
	 * @throws NotSuspendedException ۗĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void resume()
	throws CannotResumeException, NotRunningException, 
		NotSuspendedException, WorkflowException;

	/**
	 * sIuWFNgۗ̕vB
	 * v󂯓ꂽꍇAԂ́Aopen.not_running.suspendedɐݒ肳B
	 *
	 * @throws CannotSuspendException ۗłȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws AlreadySuspendedException łɕۗĂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void suspend()
	throws CannotSuspendException, NotRunningException,
		AlreadySuspendedException, WorkflowException;

	/**
	 * s̎sIuWFNg̒~vB
	 * v󂯓ꂽꍇAԂclosed.terminatedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void terminate()
	throws CannotStopException, NotRunningException, WorkflowException;

	/**
	 * ۗꂽsIuWFNg̒fvB
	 * v󂯓ꂽꍇAԂclosed.abortedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void abort()
	throws CannotStopException, NotRunningException, WorkflowException;

	/**
	 * sIuWFNgɂ鑮ꗗԂB
	 *
	 * @return ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue[] getContext() throws WorkflowException;

	/**
	 * sIuWFNgɂ鑮ԂB
	 *
	 * @param name 
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue getContext(String name) throws WorkflowException;

	/**
	 * sIuWFNgɂ鑮ꗗݒ肷B
	 *
	 * @param context ꗗ
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setContext(WfNameValue[] context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException;

	/**
	 * sIuWFNgɂ鑮ݒ肷B
	 *
	 * @param context 
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setContext(WfNameValue context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException;

	/**
	 * ύX̐ԂB
	 *
	 * @return ύX̐
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getHistoryCount()
	throws HistoryNotAvailableException, WorkflowException;

	/**
	 * CfNXw肵āA擾B
	 *
	 * @param index CfNX
	 * @return ύX
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfEvent getHistory(int index)
	throws HistoryNotAvailableException, WorkflowException;

	/**
	 * ̎sIuWFNgɊւύX擾B
	 *
	 * @return ύX
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfEvent[] getAllHistories()
	throws HistoryNotAvailableException, WorkflowException;
}
