/* $Id: WfProcess.java,v 1.5 2005/08/26 04:55:25 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfProcesśAЂƂ̃rWlXvZX̊Ǘ̂\C^tF[XłB
 * {ł́ÅǗ̂uvZXvƕ\LB
 * WfProcesśAvZX̎sJn鑀A
 * vZXɂĐꂽʂ擾鑀A
 * WfRequesterWfActivityƂ̊֘Aǉ邱ƂŁA
 * WfExecutionObjectĂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface WfProcess extends WfExecutionObject {

	/**
	 * vZXv҂ԂB
	 *
	 * @return vZXv
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfRequester getRequester() throws WorkflowException;

	/**
	 * vZXv҂vZXɊ֘AtB
	 * vZXꂽ_ŁÅ֘AtsB
	 * vZX́AWfRequester̃C^tF[XʂāAԂ̕ύXʒmB
	 *
	 * @param requester vZXv
	 * @throws CannotChangeRequesterException vZXv҂XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setRequester(WfRequester requester)
	throws CannotChangeRequesterException, WorkflowException;

	/**
	 * vZX́AWfProcessMgrɊ֘AtB
	 * WfProcess鎞_Ŋ֘AtsAύX͂łȂB
	 *
	 * @return vZX}l[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfProcessManager getManager() throws WorkflowException;

	/**
	 * 0ȏWfActiviyvZXɊ֘AtB
	 * Xebv́A_ŃvZXopenȏԂłANeBreB\̂ƂB
	 * ł́AXebv̌ԂB
	 *
	 * @return Xebv̌
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getStepCount() throws WorkflowException;

	/**
	 * XebvIDŎw肳ꂽANeBreBԂB
	 *
	 * @param aid ANeBreBID
	 * @return ANeBreB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfActivity getStep(String aid) throws WorkflowException;

	/**
	 * _̑SXebvԂB
	 *
	 * @return SXebv
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfActivity[] getAllSteps() throws WorkflowException;

	/**
	 * Ŏw肳ꂽANeBreBÃvZX̃XebvɏĂ邩ǂԂB
	 *
	 * @param act ANeBreB
	 * @return Ăꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public boolean isMemberOfStep(WfActivity act) throws WorkflowException;

	/**
	 * Ŏw肳ꂽԂANeBreBԂB
	 *
	 * @param state 
	 * @return ANeBreB
	 * @throws InvalidStateException sȏ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfActivity[] getActivitiesInState(String state)
	throws InvalidStateException, WorkflowException;

	/**
	 * WfProcess̎sJn邽߂ɎgpB
	 * vZX̏Ԃ́Aopen.not_runningopen.runningɕωB
	 *
	 * @throws CannotStartException JnłȂꍇ
	 * @throws AlreadyRunningException łɊJnĂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void start()
	throws CannotStartException, AlreadyRunningException, WorkflowException;

	/**
	 * WfProcessɂĐ錋ʂԂB
	 * vZX܂ł͌ʂ͒`ȂB
	 * ʂ̎擾܂擾łȂꍇ́AOB
	 *
	 * @return 
	 * @throws ResultNotAvailableException ʂ擾łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue[] getResult()
	throws ResultNotAvailableException, WorkflowException;
}
