/* $Id: WfProcessManager.java,v 1.6 2005/08/26 04:55:04 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfProcessManageŕÃ[Nt[vZX̃ev[g
 * \C^tF[XłB
 * OMGdlłWfProcessMgrƂĂ邪AWfProcessManagerƂB
 * {ł́ÅǗ̂uvZX}l[Wvƕ\LB
 * WfProcessManageŕAWfProcessCX^X̃t@NgłB
 * vZX}l[ẂAvZXKvƂA
 * vZX`Ȃǂɑ΂ANZX񋟂B
 * vZX}l[ẂAvZX`̃bp[IuWFNgƂċ@\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public interface WfProcessManager extends WfObject
{
	/**
	 * ǗĂvZX̌ԂB
	 *
	 * @return vZX̌
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getProcessCount() throws WorkflowException;

	/**
	 * IDŎw肳ꂽvZXԂB
	 *
	 * @param pid vZXID
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfProcess getProcess(String pid) throws WorkflowException;

	/**
	 * Ǘׂ̂ẴvZXԂB
	 *
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfProcess[] getAllProcesses() throws WorkflowException;
	
	/**
	 * Ŏw肳ꂽvZXAǗɂ邩ǂԂB
	 *
	 * @param member vZXID
	 * @return Ǘɂꍇ́ATrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public boolean isMemberOfProcess(String member)
	throws WorkflowException;

	/**
	 * JeS[ԂB
	 *
	 * @return JeS
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getCategory() throws WorkflowException;

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getName() throws WorkflowException;

	/**
	 * o[WԂB
	 *
	 * @return o[W
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getVersion() throws WorkflowException;

	/**
	 * ڍ׏ԂB
	 *
	 * @return ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getDescription() throws WorkflowException;

	/**
	 * ԂԂBVK̃vZX̉ۂԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfState getState() throws WorkflowException;

	/**
	 * Ԃݒ肷B
	 *
	 * @param state  
	 * @throws TransitionNotAllowedException ԂύXłȂꍇ 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setState(WfState state)
	throws TransitionNotAllowedException, WorkflowException;

	/**
	 * CX^X̃ReLXg̐ݒ@`郁^ԂB
	 *
	 * @return ^
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue[] getContextSignature() throws WorkflowException;
	
	/**
	 * CX^XʂԂ@w肷郁^ԂB
	 *
	 * @return ^
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfNameValue[] getResultSignature() throws WorkflowException;

	/**
	 * vZX̃CX^X𐶐ANGX^ɌB
	 * vZXƁAnot_running.not_started̏Ԃɐݒ肳B
	 *
	 * @param requester vZXNGX^
	 * @param name lʉ\ȃvZX
	 * @return ꂽvZX
	 * @throws NotEnabledException vZXłȂꍇ
	 * @throws InvalidRequesterException NGX^Ȃꍇ
	 * @throws RequesterRequiredException NGX^w肳ĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfProcess createProcess(WfRequester requester, String name)
	throws NotEnabledException, InvalidRequesterException,
		RequesterRequiredException, WorkflowException;
}
