/* $Id: WfResource.java,v 1.4 2005/08/26 04:55:03 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfResourcéAANeBreBɊ蓖Ă
 * l╨\Ǘ̂\C^tF[XłB
 * {ł́ÅǗ̂u\[Xvƕ\LB
 * WfResourcéAWfAssignmentɂWfActivityƊ֘AtB
 * WfResourceNXƂčl̂́A
 * l╨\IuWFNgɑ΂A_v^ȂǂłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface WfResource extends WfObject {

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getID() throws WorkflowException;

	/**
	 * ̂Ԃ
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getName() throws WorkflowException;

	/**
	 * \[XɊ֘AtꂽATCǧԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getWorkItemCount() throws WorkflowException;

	/**
	 * IDŎw肳ꂽATCgԂB
	 *
	 * @param wid ID
	 * @return ATCg
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfAssignment getWorkItem(String wid) throws WorkflowException;

	/**
	 * \[XɊ֘AtꂽׂẴATCgԂB
	 *
	 * @return ATCg̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public WfAssignment[] getAllWorkItem() throws WorkflowException;

	/**
	 * Ŏw肳ꂽATCgƁA֘AǂԂB
	 *
	 * @param ass ATCg
	 * @return ֘Aꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public boolean isMemberOfWorkItems(WfAssignment ass)
	throws WorkflowException;

	/**
	 * Ɏw肵ATCgɂƂāA
	 * \[XsvɂȂƂʒm郊Xi[C^tF[XB
	 * ƂāA\[XɊ֘AtĂȂATCgƁA
	 * \[X闝RƂB
	 * ̃C^tF[X́AATCg폜ꂽꍇA
	 * ATCg̃\[X֍Ċ蓖Ăꂽꍇ
	 * IɌĂяo邱Ƃz肵ĂB
	 *
	 * @param ass ATCg
	 * @param info J闝R
	 * @throws NotAssignedException ATCg֘AĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void release(WfAssignment ass, String info)
	throws NotAssignedException, WorkflowException;
}
