/* $Id: DefinitionRepositoryPO.java,v 1.6 2005/08/26 04:53:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

/**
 * DefinitionRepositoryPÓA[JDefinitionRepositoryɑ΂
 * [gĂяo̎NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 * @see jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository
 */
public class DefinitionRepositoryPO
extends PortableRemoteObject
implements DefinitionRepositoryRemote
{
	private DefinitionRepository repository;

	/**
	 * DefinitionRepositoryPO𐶐B
	 *
	 * @param repository `|Wg
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	DefinitionRepositoryPO(DefinitionRepository repository)
	throws RemoteException
	{
		this.repository = repository;
	}

	/**
	 * w肳ꂽ`̓o^sAGWɔFB
	 *
	 * @param session ZbVID
	 * @param name [Nt[`
	 * @param path [Nt[`̑΃pX
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote#registerDefinition(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void registerDefinition(String session, String name, String path)
	throws InvalidSessionException, WorkflowException, RemoteException 
	{
		repository.registerDefinition(session, name, path);
	}
	
	/**
	 * Ƀ}b`vZX`ꗗԂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ꂽvZX`Tv̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote#getProcessDefinitions(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public ProcDef[] getProcessDefinitions(
			String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException
	{
		return repository.getProcessDefinitions(session, filter);
	}

	/**
	 * vZX`IDœ肳ꂽ`݂̌̏ԂJډ\
	 * vZX`ԈꗗԂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @return vZX`Ԃ̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote#getProcessDefinitionStates(java.lang.String, java.lang.String)
	 */
	public ProcessDefinitionState[] getProcessDefinitionStates(
			String session,String pdid)
	throws InvalidSessionException, InvalidProcessDefinitionException,
			RemoteException
	{
		
		return repository.getProcessDefinitionStates(session, pdid);
	}

	/**
	 * vZX`ԂύXB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param state vZX`
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote#changeProcessDefinitionState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState)
	 */
	public void changeProcessDefinitionState (String session,
			String pdid, ProcessDefinitionState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
			InvalidStateException, TransitionNotAllowedException,
			RemoteException
	{
		repository.changeProcessDefinitionState(session, pdid, state);
	}
}
