/* $Id: InterWorkflowConnectorRemote.java,v 1.4 2005/08/26 04:53:57 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * GWԐڑ̂߂̃C^tF[XƂāAInterWorkflowConnector񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface InterWorkflowConnectorRemote extends Remote {

	/**
	 * GWIDw肵āA[gGWANZXpIDԂB
	 *
	 * @param seid GWID
	 * @param password pX[h
	 * @return [g̃GWԂGWڑID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String connect(String seid, String password)
	throws WorkflowException, RemoteException;

	/**
	 * [g̃GWƂ̐ڑؒfB
	 *
	 * @param eid GWID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void disconnect(String eid)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^XԂ̕ύXvB
	 *
	 * @param eid GWID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void changeProcessState(String eid, String pid, ProcessState state)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^X̐vB
	 *
	 * @param eid [gGWڑID
	 * @param pdid vZX`ID
	 * @param flag ߂lԂKv邩ǂ\tO
	 * @param rootpid ṽvZXCX^XID
	 * @param aid ṽANeBreBCX^XID
	 * @param userid [UIDBɋL^pB
	 * @param roleid IDBɋL^pB
	 * @return ꂽvZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String createProcess(String eid, String pdid, int flag,
			String rootpid, String aid, String userid, String roleid)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^X̎擾vB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ̔zԂB
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Attribute[] getProcessAttributes(String eid, String pid,
			String rootpid, String aid)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^XԂ̎擾vB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public ProcessState getProcessState(String eid, String pid)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^X̕ύXʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void processAttributesChanged(String eid, String pid,
			Attribute[] attr)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^XԂ̕ύXʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void processStateChanged(String eid,
			String pid, ProcessState state)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^X̐ݒvB
	 *
	 * @param eid [gGWڑID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid vANeBreBCX^XID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void setProcessAttributes(String eid, String rootpid,
			String aid, String pid, Attribute[] attr)
	throws WorkflowException, RemoteException;

	/**
	 * gK[ƂȂANeBreBʒmB
	 * ́ANANeBreBƂ͕ʂȃANeBreBɂ
	 * vZX𐧌䂷ꍇ̒ʒmƂĎgpB
	 *
	 * @param eid [gGWڑID
	 * @param rootpid ṽvZXCX^XID
	 * @param aid vANeBreBCX^XID
	 * @param pid vZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void triggerActivity(String eid, String rootpid,
			String aid, String pid)
	throws WorkflowException, RemoteException;

	/**
	 * ̃GWvē쒆̃vZXCX^XIDꗗ
	 * 擾vB
	 *
	 * @param eid [gGWڑID
	 * @param filter ptB^[
	 * @return vZXCX^XIDꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String[] listProcesses(String eid, Filter filter)
	throws WorkflowException, RemoteException;

	/**
	 * vZXCX^X̐̕ʒmB
	 *
	 * @param eid [gGWڑID
	 * @param pid vZXCX^XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void relinquishProcess(String eid, String pid)
	throws WorkflowException, RemoteException;
}
