/* $Id: RepositoryLoaderPO.java,v 1.7 2005/08/26 04:53:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;

/**
 * RepositoryLoaderPO ́A[J RepositoryLoader ɑ΂
 * [gĂяo̎NXłB
 *
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class RepositoryLoaderPO
extends PortableRemoteObject
implements RepositoryLoaderRemote {
    
    private RepositoryLoader repository;
    
    /**
     * RepositoryLoaderPO 𐶐B
     * 
     * @param  repository      `|Wg
     * @throws RemoteException ʐMQȂǂ̏ꍇ
     */
    public RepositoryLoaderPO (RepositoryLoader repository) 
    throws RemoteException {
        super();
        this.repository = repository;
    }
    
    /**
     * w肳ꂽpX̒`t@C𕶎ŕԂB
     * Ȃ null ԂB
     * RemoteException ȊO̗Oꍇ null ԂB
     * 
     * @param sid      ZbVID
     * @param password ǗppX[h
     * @param path     pX
     * @return `t@C̕
     * @throws RemoteException ʐMQȂǂ̏ꍇ
     * @see jp.co.argo21.nautica.workflow.rmi.RepositoryLoaderRemote#getDefinition(java.lang.String, java.lang.String, java.lang.String)
     */
    public String getDefinition(String sid, String password, String path)
    throws RemoteException {
        return repository.getDefinition(sid, password, path);               
    }
    
    /**
     * w肳ꂽvZX`ɑΉpXԂB
     * Ȃ null ԂB
     * RemoteException ȊO̗Oꍇ null ԂB
     * 
     * @param sid    ZbVID
     * @param pdname vZX`
     * @return pX
     * @throws RemoteException ʐMQȂǂ̏ꍇ
     * @see jp.co.argo21.nautica.workflow.rmi.RepositoryLoaderRemote#getDefinitionPath(java.lang.String, java.lang.String)
     */
    public String getDefinitionPath(String sid, String pdname)
    throws RemoteException {
        return repository.getDefinitionPath(sid, pdname);
    }
}
