/* $Id: WorkItemHandlerPO.java,v 1.5 2005/08/26 04:53:56 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * WorkItemHandlerPÓA[JWorkItemHandlerɑ΂
 * [gĂяo̎NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 * @see jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler
 */
public class WorkItemHandlerPO
extends PortableRemoteObject
implements WorkItemHandlerRemote
{
	private WorkItemHandler itemHandler;

	/**
	 * WorkItemHandlerPO𐶐B
	 *
	 * @param handler WorkItemHandler
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	WorkItemHandlerPO(WorkItemHandler handler)
	throws RemoteException
	{
		this.itemHandler = handler;
	}

	/**
	 * ƍڈꗗ̎擾sB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ƍڈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#getWorkItems(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public WorkItem[] getWorkItems(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException
	{
		return itemHandler.getWorkItems(session, filter);
	}

	/**
	 * ƍڂ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @return ƍ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#getWorkItem(java.lang.String, java.lang.String)
	 */
	public WorkItem getWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException, RemoteException
	{
		return itemHandler.getWorkItem(session, wid);
	}

	/**
	 * ƍڂ̊sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#completeWorkItem(java.lang.String, java.lang.String)
	 */
	public void completeWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException, RemoteException
	{
		itemHandler.completeWorkItem(session, wid);
	}

	/**
	 * ݂̍ƍڂJډ\ȏԂ̈ꗗԂB
	 * ԂȂꍇ́A̔zԂB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڏԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#getWorkItemStates(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public WorkItemState[] getWorkItemStates(String session,
			String wid, Filter filter)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException, RemoteException
	{
		return itemHandler.getWorkItemStates(session, wid, filter);
	}
	
	/**
	 * ƍڏԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param state ƍڏ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#changeWorkItemState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.WorkItemState)
	 */
	public void changeWorkItemState(String session,
			String wid, WorkItemState state)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidStateException, TransitionNotAllowedException, RemoteException
	{
		itemHandler.changeWorkItemState(session, wid, state);
	}
	
	/**
	 * ƍڂ̍Ċ蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param sourceUser 蓖đÕ[U
	 * @param targetUser 蓖Č̃[U
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidSourceUserException 蓖đO[ULłȂꍇ
	 * @throws InvalidTargetUserException 蓖Đ惆[ULłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#reassignWorkItem(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Participant, jp.co.argo21.nautica.workflow.wfmc.Participant, java.lang.String)
	 */
	public void reassignWorkItem(String session,
			Participant sourceUser, Participant targetUser, String wid)
	throws InvalidSessionException, InvalidWorkItemException,
	InvalidSourceUserException, InvalidTargetUserException, RemoteException
	{
		itemHandler.reassignWorkItem(session, sourceUser, targetUser, wid);
	}
	
	/**
	 * ƍڑꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڑꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#getWorkItemAttributes(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Attribute[] getWorkItemAttributes(String session,
			String wid, Filter filter)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException, RemoteException
	{
		return itemHandler.getWorkItemAttributes(session, wid, filter);
	}
	
	/**
	 * ƍڑ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#getWorkItemAttributeValue(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Attribute getWorkItemAttributeValue(String session,
			String wid, String name)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException, RemoteException
	{
		return itemHandler.getWorkItemAttributeValue(session, wid, name);
	}

	/**
	 * ƍڑ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote#assignWorkItemAttribute(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignWorkItemAttribute(String session,
			String wid, Attribute attr)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException, AttributeAssignmentFailedException,
		RemoteException
	{
		itemHandler.assignWorkItemAttribute(session, wid, attr);
	}
}
