/* $Id: WorkflowAdminHandlerPO.java,v 1.7 2005/08/26 04:53:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;

/**
 * WorkflowAdminHandlerPÓA[JWorkflowAdminHandlerɑ΂
 * [gĂяo̎NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler
 */
public class WorkflowAdminHandlerPO
extends PortableRemoteObject
implements WorkflowAdminHandlerRemote
{
	private WorkflowAdminHandler adminHandler;

	/**
	 * WorkflowAdminHandlerPO𐶐B
	 *
	 * @param handler Ǘnh
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	WorkflowAdminHandlerPO(WorkflowAdminHandler handler)
	throws RemoteException
	{
		this.adminHandler = handler;
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param state VvZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#changeProcessesState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.ProcessState)
	 */
	public void changeProcessesState(String session,
			String pdid, Filter filter, ProcessState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidFilterException, InvalidStateException,
	TransitionNotAllowedException, RemoteException
	{
		adminHandler.changeProcessesState(session, pdid, filter, state);
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param state VANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#changeActivitiesState(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.ActivityState)
	 */
	public void changeActivitiesState(String session,
			String pdid, String adid, Filter filter, ActivityState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidActivityNameException, InvalidFilterException,
	InvalidStateException, TransitionNotAllowedException, RemoteException
	{
		adminHandler.changeActivitiesState(session, pdid, adid, filter, state);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁A~sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#terminateProcesses(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void terminateProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, RemoteException
	{
		adminHandler.terminateProcesses(session, pdid, filter);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁Å蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#assignProcessesAttribute(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignProcessesAttribute(String session,
			String pdid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidAttributeException, RemoteException
	{
		adminHandler.assignProcessesAttribute(session, pdid, filter, attr);
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁A
	 * ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#assignActivitiesAttribute(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignActivitiesAttribute(String session,
			String pdid, String adid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException, RemoteException
	{
		adminHandler.assignActivitiesAttribute(session, pdid, adid, filter, attr);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AfsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#abortProcesses(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void abortProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, RemoteException
	{
		adminHandler.abortProcesses(session, pdid, filter);
	}

	/**
	 * w肳ꂽvZXCX^X̒fsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#abortProcess(java.lang.String, java.lang.String)
	 */
	public void abortProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		RemoteException
	{
		adminHandler.abortProcess(session, pid);
	}

	/**
	 * w肳ꂽ`̓o^sAGWɔFB
	 *
	 * @param session ZbVID
	 * @param name [Nt[`
	 * @param path [Nt[`̑΃pX
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#registerDefinition(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void registerDefinition(String session, String name, String path)
	throws InvalidSessionException, WorkflowException, RemoteException
	{
		WorkflowEngine engine = WorkflowEngine.getInstance();
		DefinitionRepository repository = engine.getDefinitionRepository(session);
		repository.registerDefinition(session, name, path);
	}

	/**
	 * [Nt[GW̃Vbg_EsB
	 *
	 * @param session ZbVID
	 * @param adminKey ǗL[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException Vbg_EɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote#shutdown(java.lang.String, java.lang.String)
	 */
	public void shutdown(String session, String adminKey)
	throws InvalidSessionException, WorkflowException, RemoteException
	{
		WorkflowEngine.shutdown(session, adminKey);
	}
}
